/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.amazonaws.auth.AWSCredentials;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AWSCredentialsHelper;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionCredentialUtils;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.aws.S3ConnectionAWSSessionCredentialsProvider;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.legacy.aws.com.amazonaws.auth.BasicAWSCredentials;
import com.dataiku.dss.legacy.aws.com.amazonaws.auth.BasicSessionCredentials;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.identity.spi.AwsSessionCredentialsIdentity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;

public interface ConnectionWithAWSAuthCredentials
extends ConnectionWithEncryptedFields {
    public static final DKULogger logger = DKULogger.getLogger((String)"dku.aws");

    @Deprecated
    public static com.dataiku.dss.legacy.aws.com.amazonaws.auth.AWSCredentials fromAwsToV1Credentials(com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentials credentialsV2) {
        if (credentialsV2 instanceof com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsSessionCredentials) {
            return new BasicSessionCredentials(credentialsV2.accessKeyId(), credentialsV2.secretAccessKey(), ((com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsSessionCredentials)credentialsV2).sessionToken());
        }
        return new BasicAWSCredentials(credentialsV2.accessKeyId(), credentialsV2.secretAccessKey());
    }

    @Nonnull
    public IAWSAuthParams getIAWSAuthNonResolvedParams();

    public ProxySettings getProxySettingsFromConnection();

    public DSSConnection.CredentialsMode getCredentialsMode();

    default public boolean mustResolveAWSAuthOnDSSHost() {
        IAWSAuthParams params = this.getIAWSAuthNonResolvedParams();
        switch (params.getCredentialsMode()) {
            case CUSTOM_PROVIDER: {
                return true;
            }
            case KEYPAIR: {
                return false;
            }
            case ENVIRONMENT: {
                return true;
            }
            case STS_ASSUME_ROLE: {
                return true;
            }
        }
        throw new Error("Unsupported credentials mode:" + String.valueOf((Object)params.getCredentialsMode()));
    }

    default public SerializableAWSCredential getResolvedCredential(AuthCtx authCtx) throws IOException, DKUSecurityException {
        DSSConnection connection = (DSSConnection)((Object)this);
        IAWSAuthParams params = this.getIAWSAuthNonResolvedParams();
        switch (params.getCredentialsMode()) {
            case CUSTOM_PROVIDER: {
                if (StringUtils.isBlank((String)params.getCustomAWSCredentialsProviderClass())) {
                    throw new DKUSecurityException("AWS credentials provider class not given");
                }
                try {
                    Class<?> clazz = Class.forName(params.getCustomAWSCredentialsProviderClass());
                    AWSConnectionCredentialsProvider resolver = (AWSConnectionCredentialsProvider)clazz.newInstance();
                    resolver.setConnection(this);
                    resolver.setParams(params.getCustomAWSCredentialsProviderParams());
                    return resolver.get(authCtx);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Failed to resolve connection settings", t);
                }
            }
            case KEYPAIR: {
                SerializableAWSCredential ret = new SerializableAWSCredential();
                switch (this.getCredentialsMode()) {
                    case GLOBAL: {
                        PasswordEncryptionService symetricCryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
                        ret.accessKey = symetricCryptoService.decryptIfEncrypted(params.getAccessKey());
                        ret.secretKey = symetricCryptoService.decryptIfEncrypted(params.getSecretKey());
                        break;
                    }
                    case PER_USER: {
                        ICredentialsService.BasicCredential bcc = ConnectionCredentialUtils.getDecryptedBasicCredential_autoTXN(connection, authCtx);
                        ret.accessKey = bcc.user;
                        ret.secretKey = bcc.password;
                    }
                }
                return ret;
            }
            case ENVIRONMENT: {
                if (this.couldRunWithEnvironmentCredentials(params)) {
                    DefaultCredentialsProvider credentialsProviderChain = DefaultCredentialsProvider.create();
                    com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentials awsCredentials = credentialsProviderChain.resolveCredentials();
                    if (awsCredentials instanceof AwsSessionCredentialsIdentity) {
                        return new SerializableAWSCredential(awsCredentials.accessKeyId(), awsCredentials.secretAccessKey(), ((AwsSessionCredentialsIdentity)awsCredentials).sessionToken());
                    }
                    return new SerializableAWSCredential(awsCredentials.accessKeyId(), awsCredentials.secretAccessKey(), null);
                }
                throw new IOException("Resolving credentials from environment is not supported");
            }
            case STS_ASSUME_ROLE: {
                VariablesContext vc = ((VariablesService)SpringUtils.getBean(VariablesService.class)).getForConnectionAndUser(connection, authCtx);
                return AWSCredentialsHelper.getCredentialForAssumeRole(authCtx, connection.name, params.getStsRoleToAssume(), params.getStsAssumeExternalId(), params.getStsAssumeDurationSeconds(), params.getStsEndpoint(), vc);
            }
        }
        throw new Error("Unsupported credentials mode:" + String.valueOf((Object)params.getCredentialsMode()));
    }

    default public boolean actuallyHasAWSAuthCredentials() {
        return true;
    }

    default public boolean couldRunWithEnvironmentCredentials(IAWSAuthParams params) {
        switch (ApplicationConfigurator.getProcessType()) {
            case BACKEND: 
            case FEK: 
            case JEK: 
            case CAK: 
            case APIMAIN: 
            case EVENTSERVER: {
                return params.getCredentialsMode() == AWSCredentialMode.ENVIRONMENT;
            }
        }
        return false;
    }

    public static interface IAWSAuthParams {
        public AWSCredentialMode getCredentialsMode();

        public String getAccessKey();

        public String getSecretKey();

        public String getStsRoleToAssume();

        public String getStsEndpoint();

        public String getStsAssumeDurationSeconds();

        public String getStsAssumeExternalId();

        public String getCustomAWSCredentialsProviderClass();

        public List<AbstractSQLConnection.CustomDatabaseProperty> getCustomAWSCredentialsProviderParams();
    }

    public static enum AWSCredentialMode {
        KEYPAIR,
        ENVIRONMENT,
        STS_ASSUME_ROLE,
        CUSTOM_PROVIDER;

    }

    public static interface AWSConnectionCredentialsProvider {
        public void setConnection(ConnectionWithAWSAuthCredentials var1);

        public void setParams(List<AbstractSQLConnection.CustomDatabaseProperty> var1);

        public SerializableAWSCredential get(AuthCtx var1);
    }

    public static class SerializableAWSCredential {
        public String accessKey;
        public String secretKey;
        public String sessionToken;
        public long expirationTime;

        public SerializableAWSCredential() {
        }

        public SerializableAWSCredential(String accessKey, String secretKey, String sessionToken) {
            this.accessKey = accessKey;
            this.secretKey = secretKey;
            this.sessionToken = sessionToken;
        }

        public SerializableAWSCredential withExpirationTime(long expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public AWSCredentials toAWSCredentialsUnshadedSDK1() {
            if (this.sessionToken == null) {
                return new S3ConnectionAWSSessionCredentialsProvider.BasicDKUAWSCredentials(this.accessKey, this.secretKey);
            }
            return new S3ConnectionAWSSessionCredentialsProvider.BasicDKUAWSSessionCredentials(this.accessKey, this.secretKey, this.sessionToken);
        }

        public com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentials toAWSCredentials() {
            if (this.sessionToken == null) {
                return com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsBasicCredentials.create((String)this.accessKey, (String)this.secretKey);
            }
            return com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsSessionCredentials.create((String)this.accessKey, (String)this.secretKey, (String)this.sessionToken);
        }

        public AwsCredentials toUnshadedAWSCredentials() {
            if (this.sessionToken == null) {
                return AwsBasicCredentials.create(this.accessKey, this.secretKey);
            }
            return AwsSessionCredentials.create(this.accessKey, this.secretKey, this.sessionToken);
        }
    }

    public static class AWSAuthParams
    extends DSSConnection.DkuConnectionParams
    implements IAWSAuthParams {
        public AWSCredentialMode credentialsMode = AWSCredentialMode.KEYPAIR;
        public String accessKey;
        public String secretKey;
        public String stsRoleToAssume;
        public String stsEndpoint;
        public String stsAssumeDurationSeconds;
        public String stsAssumeExternalId;
        public String customAWSCredentialsProviderClass;
        public List<AbstractSQLConnection.CustomDatabaseProperty> customAWSCredentialsProviderParams = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();

        @Override
        public AWSCredentialMode getCredentialsMode() {
            return this.credentialsMode;
        }

        @Override
        public String getAccessKey() {
            return this.accessKey;
        }

        @Override
        public String getSecretKey() {
            return this.secretKey;
        }

        @Override
        public String getStsRoleToAssume() {
            return this.stsRoleToAssume;
        }

        @Override
        public String getStsEndpoint() {
            return this.stsEndpoint;
        }

        @Override
        public String getStsAssumeDurationSeconds() {
            return this.stsAssumeDurationSeconds;
        }

        @Override
        public String getStsAssumeExternalId() {
            return this.stsAssumeExternalId;
        }

        @Override
        public String getCustomAWSCredentialsProviderClass() {
            return this.customAWSCredentialsProviderClass;
        }

        @Override
        public List<AbstractSQLConnection.CustomDatabaseProperty> getCustomAWSCredentialsProviderParams() {
            return this.customAWSCredentialsProviderParams;
        }
    }
}

