/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedConnectionsDAO
extends ConnectionsDAO {
    @Autowired
    private TransactionService transactionService;
    private static Logger logger = Logger.getLogger(FilesBasedConnectionsDAO.class);
    public static final RelFile connectionsFile = RelFile.global((String)"connections.json");

    @Override
    protected ConnectionsDAO.ConnectionsFile read() throws IOException {
        return this.readFile(false);
    }

    @Override
    protected ConnectionsDAO.ConnectionsFile readUnsafe() throws IOException {
        return this.readFile(true);
    }

    private ConnectionsDAO.ConnectionsFile readFile(boolean unsafe) throws IOException {
        ConnectionsDAO.ConnectionsFile cf = this.read(unsafe);
        HashMap<String, DSSConnection> validConnections = new HashMap<String, DSSConnection>();
        for (Map.Entry<String, DSSConnection> c2 : cf.connections.entrySet()) {
            DSSConnection conn = c2.getValue();
            if (conn == null) continue;
            validConnections.put(c2.getKey(), conn);
        }
        cf.connections = validConnections;
        return cf;
    }

    private ConnectionsDAO.ConnectionsFile read(boolean unsafe) throws IOException {
        try (Transaction t = this.transactionService.retrieveOrBeginRead(IsolationLevel.YOLO);){
            if (unsafe) {
                ConnectionsDAO.ConnectionsFile connectionsFile = (ConnectionsDAO.ConnectionsFile)t.readObjectDefaultUnsafe(FilesBasedConnectionsDAO.connectionsFile, ConnectionsDAO.ConnectionsFile.class);
                return connectionsFile;
            }
            ConnectionsDAO.ConnectionsFile connectionsFile = (ConnectionsDAO.ConnectionsFile)t.readObjectDefault(FilesBasedConnectionsDAO.connectionsFile, ConnectionsDAO.ConnectionsFile.class);
            return connectionsFile;
        }
    }

    @Override
    protected void write(ConnectionsDAO.ConnectionsFile cf) throws IOException {
        if (TransactionContext.hasAttachedRWTransaction()) {
            RWTransactionRef t = TransactionContext.retrieveWrite();
            t.writeObject(connectionsFile, (Object)cf);
        } else {
            logger.warn((Object)"ConnectionsDAO: create a temporary write transaction");
            try (RWTransaction t = this.transactionService.beginWriteAsDSS();){
                t.writeObject(connectionsFile, (Object)cf);
            }
        }
    }
}

