/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.MetastoreDBBasedConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.HiveServer2ConnectionPoolService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class HiveConnection
extends AbstractSQLConnection
implements MetastoreDBBasedConnection {
    @Autowired
    private transient HiveServer2ConnectionPoolService hiveServer2ConnectionPoolService;
    public Params params = new Params();
    public static final String connectionType = "hiveserver2";
    private static HiveSQLDialect dialect;

    public HiveConnection(HiveServer2ConnectionPoolService hiveServer2ConnectionPoolService) {
        this.hiveServer2ConnectionPoolService = hiveServer2ConnectionPoolService;
    }

    @Override
    public Params getParams() {
        return this.params;
    }

    @Override
    protected void encryptLocalFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
    }

    @Override
    protected void decryptLocalFields(PasswordEncryptionService cryptoService) {
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        throw new UnsupportedOperationException("Not applicable");
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public boolean isProperSQL() {
        return false;
    }

    @Override
    public String getDatabaseName() {
        return this.params.db;
    }

    @Override
    public HiveSQLDialect getDialect() {
        if (dialect == null) {
            dialect = new HiveSQLDialect();
        }
        return dialect;
    }

    @Override
    String getDriver() {
        throw new Error("Must not be called");
    }

    @Override
    String getJdbcUrl() {
        throw new Error("Must not be called");
    }

    @Override
    String getDisplayableJdbcUrl() {
        return this.getJdbcUrl();
    }

    @Override
    public SQLConnectionProvider.SQLConnectionData getConnectionData_NT(AuthCtx authCtx, String projectKey) {
        HiveSQLConnectionData cd = new HiveSQLConnectionData(this, this.hiveServer2ConnectionPoolService);
        this.fillConnectionData(cd);
        return cd;
    }

    public static class Params
    extends AbstractSQLConnection.AbstractSQLParams {
        public int port = 10000;
        public String host;
        public String db;
        public String principal;
        public List<SimpleKeyValue> hiveconf = Lists.newArrayList();
        public String auxJarsAndUdfs;
        public String extraUrl;
        public boolean useUrl;
        public String customUrl;
        public String customDisplayedUrl;
        public String customDriver;
    }

    public static class HiveSQLConnectionData
    extends SQLConnectionProvider.AbstractSQLConnectionData {
        private Params connectionParams;
        private HiveServer2ConnectionPoolService hiveServer2ConnectionPoolService;

        public HiveSQLConnectionData(HiveConnection connection, HiveServer2ConnectionPoolService hiveServer2ConnectionPoolService) {
            super(ConnectionUtils.SQLConnectionType.HIVESERVER2, new HiveSQLDialect(), connection);
            this.hiveServer2ConnectionPoolService = hiveServer2ConnectionPoolService;
            this.connectionParams = (Params)JSON.deepCopy((Object)connection.params);
        }

        @Override
        public HiveConnection getConnection() {
            return (HiveConnection)super.getConnection();
        }

        @Override
        public SQLConnectionProvider.SQLConnectionWrapper buildConnection(AuthCtx authCtx, String projectKey, String debugId, boolean verboseRollback) throws SQLException, DKUSecurityException, InterruptedException {
            try {
                String clusterId = StringUtils.isBlank((String)projectKey) ? "__builtin__" : new ClusterSelector().getClusterForProject(projectKey, Cluster.ClusterArchitecture.HADOOP);
                return this.hiveServer2ConnectionPoolService.take(clusterId, authCtx, this.connectionParams.db, this.connectionParams.hiveconf, projectKey);
            }
            catch (Exception e) {
                throw new SQLException("Could not get Hiveserver2 connection from the pool", e);
            }
        }

        @Override
        public String getDriver(AuthCtx authCtx, String projectKey) {
            return "org.apache.hive.jdbc.HiveDriver";
        }

        @Override
        public SQLConnectionProvider.SparkJDBCInfo getSparkConnectionInfo(AuthCtx authCtx, String projectKey) throws SQLException {
            throw new UnsupportedOperationException("Can't access Hive from Spark via JDBC");
        }
    }
}

