/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.ImpalaSettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.MetastoreDBBasedConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SimpleSQLDSSConnectionWithBasicCredential;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datasets.sql.SQLCodes;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.impala.HighAvailabilityHost;
import com.dataiku.dip.impala.ImpalaConfigurator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class ImpalaConnection
extends SimpleSQLDSSConnectionWithBasicCredential
implements MetastoreDBBasedConnection,
ConnectionWithEncryptedFields {
    @Autowired
    private IImpersonationResolverService impersonationService;
    public static final String connectionType = "impala";
    public Params params = new Params();
    private static Logger logger = Logger.getLogger((String)"dip.connections.impala");

    @Override
    public Params getParams() {
        return this.params;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public boolean isProperSQL() {
        return false;
    }

    @Override
    public String getDatabaseName() {
        return this.params.db;
    }

    @Override
    public String getNameForCredentials() {
        return "@virtual(impala-jdbc):default";
    }

    @Override
    public SQLDialect getDialect() {
        return new ImpalaSQLDialect();
    }

    @Override
    String getDriver() {
        throw new Error("Must not be called");
    }

    @Override
    String getJdbcUrl() {
        throw new Error("Must not be called");
    }

    @Override
    String getDisplayableJdbcUrl() {
        return this.getJdbcUrl();
    }

    @Override
    public SQLConnectionProvider.SQLConnectionData getConnectionData_NT(AuthCtx authCtx, String projectKey) throws SQLException, DKUSecurityException {
        ClusterSettings clusterSettings;
        try {
            clusterSettings = new ClusterSelector().selectForProject(authCtx, projectKey);
        }
        catch (IOException e) {
            throw new SQLException("Unable to get cluster settings for Impala connection", e);
        }
        ImpalaConfigurator.setupConnectionFromSettings(this, clusterSettings.getImpalaSettings());
        Params connectionParams = (Params)JSON.deepCopy((Object)this.params);
        ICredentialsService.BasicCredential creds = this.getFullyResolvedCredentials_sqlLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), ICredentialsService.BasicCredential.class);
        ImpalaSQLConnectionData cd = new ImpalaSQLConnectionData(this, this.impersonationService, connectionParams, creds);
        this.fillConnectionData(cd);
        return cd;
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        if (this.params.authBehavior == ImpalaSettings.AuthBehavior.LDAP) {
            return new ICredentialsService.BasicCredential(this.params.user, this.params.password);
        }
        return new ICredentialsService.BasicCredential();
    }

    @Override
    protected void encryptLocalFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings unused) {
        if (StringUtils.isNotBlank((String)this.params.password)) {
            this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
        }
        this.encryptCustomFields(cryptoService);
    }

    @Override
    protected void decryptLocalFields(PasswordEncryptionService cryptoService) {
        if (StringUtils.isNotBlank((String)this.params.password)) {
            this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
        }
        this.decryptCustomFields(cryptoService);
    }

    @Override
    public boolean actuallyHasBasicCredential() {
        return this.params.authBehavior == ImpalaSettings.AuthBehavior.LDAP;
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        return super.getFullyResolvedCredentials_internal(ctx, clazz);
    }

    public static class Params
    extends AbstractSQLConnection.AbstractSQLParams
    implements Cloneable {
        public String db;
        public ImpalaSettings.AuthBehavior authBehavior;
        public String principal;
        public String user;
        public String password;
        public List<HighAvailabilityHost> datanodes = Lists.newArrayList();
        public boolean useSimbaDriver;
        public boolean useUrl;
        public String customUrl;
        public String customDisplayedUrl;
        public String customDriver;
        public boolean useSsl = false;
        public boolean isSelfSigned = false;
        public String trustStorePath;
        public String trustStorePassword;

        @Override
        public void expandInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
            super.expandInPlaceAtDAOLevelUsingGlobalContextOnly(vc);
            this.principal = vc.expand(this.principal);
            for (HighAvailabilityHost datanode : this.datanodes) {
                datanode.fqn = vc.expand(datanode.fqn);
            }
        }

        public Params clone() throws CloneNotSupportedException {
            return (Params)super.clone();
        }
    }

    public static class ImpalaSQLConnectionData
    extends SQLConnectionProvider.AbstractSQLConnectionData {
        private String driver;
        private int hostIndex = 0;
        private Params connectionParams;
        private IImpersonationResolverService impersonationService;
        private ICredentialsService.BasicCredential creds;

        public ImpalaSQLConnectionData(ImpalaConnection connection, IImpersonationResolverService impersonationService, Params connectionParams, ICredentialsService.BasicCredential creds) {
            super(ConnectionUtils.SQLConnectionType.IMPALA, new ImpalaSQLDialect(), connection);
            this.impersonationService = impersonationService;
            this.connectionParams = connectionParams;
            this.creds = creds;
        }

        private String getDriverFromParams(Params connectionParams) {
            if (connectionParams.useUrl) {
                return StringUtils.defaultIfBlank((String)connectionParams.customDriver, (String)"org.apache.hive.jdbc.HiveDriver");
            }
            if (connectionParams.useSimbaDriver) {
                return StringUtils.isBlank((String)connectionParams.customDriver) ? "com.cloudera.impala.jdbc.Driver" : connectionParams.customDriver;
            }
            return "org.apache.hive.jdbc.HiveDriver";
        }

        public String getDatabase() {
            return this.getConnection().params.db;
        }

        private Params getConnectionParams(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
            return this.connectionParams;
        }

        @Override
        public String getDriver(AuthCtx authCtx, String projectKey) {
            if (this.driver == null) {
                try {
                    this.driver = this.getDriverFromParams(this.getConnectionParams(authCtx, projectKey));
                }
                catch (DKUSecurityException | IOException e) {
                    throw new CodedRuntimeException((InfoMessage.MessageCode)SQLCodes.ERR_SQL_INVALID_CONF, "Cannot setup Impala connection because cluster can't be resolved", e);
                }
            }
            return this.driver;
        }

        private SQLConnectionProvider.JdbcConnectionData getJdbcConnectionData(AuthCtx authCtx, String projectKey) throws SQLException {
            HighAvailabilityHost host = this.connectionParams.datanodes.get(this.hostIndex);
            ImpalaConfigurator.setLastUsedHost(host);
            Params ourParams = (Params)JSON.deepCopy((Object)this.connectionParams);
            String hadoopUser = this.getHadoopUserIfRelevant(authCtx, projectKey);
            if (ourParams.useUrl) {
                return this.makeCustomUrlJdbcData(host, ourParams, hadoopUser);
            }
            StringWithDisplayedVersion auth = new StringWithDisplayedVersion();
            if (ourParams.useSimbaDriver && ourParams.useSsl) {
                this.makeAuthForSimbaSSL(host, ourParams, auth);
            } else if (ourParams.authBehavior == ImpalaSettings.AuthBehavior.KERBEROS) {
                this.makeAuthForKerberos(host, ourParams, auth);
            } else if (ourParams.authBehavior == ImpalaSettings.AuthBehavior.LDAP) {
                this.makeAuthForLDAP(authCtx, ourParams, auth);
            } else if (ourParams.authBehavior == ImpalaSettings.AuthBehavior.NOAUTH) {
                this.makeAuthForNoAuth(ourParams, auth);
            } else {
                throw new IllegalArgumentException("Unsupported auth behavior " + String.valueOf((Object)ourParams.authBehavior) + ". Should have been checked in ImpalaConfigurator.");
            }
            StringWithDisplayedVersion jdbcUrl = new StringWithDisplayedVersion();
            this.makeJdbcUrlFromAuth(host, ourParams, hadoopUser, auth, jdbcUrl);
            return new SQLConnectionProvider.SimpleJdbcConnectionData(jdbcUrl.value, jdbcUrl.displayedValue, this.getProperties(false), this.getProperties(true), this.getHiddenProperties());
        }

        private void makeJdbcUrlFromAuth(HighAvailabilityHost host, Params ourParams, String hadoopUser, StringWithDisplayedVersion auth, StringWithDisplayedVersion jdbcUrl) {
            if (ourParams.useSimbaDriver) {
                jdbcUrl.value = "jdbc:impala://" + host.fqn + ":" + host.port + "/" + ourParams.db + auth.value;
                jdbcUrl.displayedValue = "jdbc:impala://" + host.fqn + ":" + host.port + "/" + ourParams.db + auth.displayedValue;
            } else {
                jdbcUrl.value = "jdbc:hive2://" + host.fqn + ":" + host.port + "/" + ourParams.db + auth.value;
                jdbcUrl.displayedValue = "jdbc:hive2://" + host.fqn + ":" + host.port + "/" + ourParams.db + auth.displayedValue;
            }
            if (this.impersonationService.isEnabled() && this.connectionParams.useSimbaDriver) {
                jdbcUrl.value = jdbcUrl.value + ";DelegationUID=" + hadoopUser;
                jdbcUrl.displayedValue = jdbcUrl.displayedValue + ";DelegationUID=" + hadoopUser;
            }
            if (!ourParams.useSimbaDriver && ourParams.useSsl) {
                jdbcUrl.value = jdbcUrl.value + ";ssl=true;sslTrustStore=" + ourParams.trustStorePath + ";trustStorePassword=" + ourParams.trustStorePassword;
                jdbcUrl.displayedValue = jdbcUrl.displayedValue + ";ssl=true;sslTrustStore=****;trustStorePassword=****";
            }
        }

        private void makeAuthForNoAuth(Params ourParams, StringWithDisplayedVersion auth) {
            auth.value = ourParams.useSimbaDriver ? ";AuthMech=0" : ";auth=noSasl";
            auth.displayedValue = auth.value;
        }

        private void makeAuthForLDAP(AuthCtx authCtx, Params ourParams, StringWithDisplayedVersion auth) throws SQLException {
            if (ourParams.useSimbaDriver) {
                auth.value = ";AuthMech=3;UseSasl=0";
                if (this.creds != null && this.creds.user != null) {
                    this.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("UID", this.creds.user, false));
                }
                if (this.creds != null && this.creds.password != null) {
                    this.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("PWD", this.creds.password, true));
                }
            } else {
                auth.value = "";
                if (this.creds != null && this.creds.user != null) {
                    this.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("user", this.creds.user, false));
                }
                if (this.creds != null && this.creds.password != null) {
                    this.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("password", this.creds.password, true));
                }
            }
            auth.displayedValue = auth.value;
        }

        private void makeAuthForKerberos(HighAvailabilityHost host, Params ourParams, StringWithDisplayedVersion auth) {
            String principal = ourParams.principal.replaceAll("_HOST\\b", host.fqn);
            if (ourParams.useSimbaDriver) {
                Pattern impalaPrincipalPattern = Pattern.compile("(.*)/(.*)@(.*)");
                Matcher impalaPrincipalMatcher = impalaPrincipalPattern.matcher(principal);
                if (impalaPrincipalMatcher.matches()) {
                    auth.value = ";AuthMech=1";
                    auth.value = auth.value + ";KrbRealm=" + impalaPrincipalMatcher.group(3);
                    auth.value = auth.value + ";KrbHostFQDN=" + impalaPrincipalMatcher.group(2);
                    auth.value = auth.value + ";KrbServiceName=" + impalaPrincipalMatcher.group(1);
                } else {
                    auth.value = "";
                }
            } else {
                auth.value = ";principal=" + principal;
            }
            auth.displayedValue = auth.value;
        }

        private void makeAuthForSimbaSSL(HighAvailabilityHost host, Params ourParams, StringWithDisplayedVersion auth) {
            if (ourParams.authBehavior == ImpalaSettings.AuthBehavior.LDAP) {
                auth.value = ";AuthMech=4";
                auth.displayedValue = ";AuthMech=4";
                this.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("SSLTrustStore", ourParams.trustStorePath, true));
                this.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("SSLTrustStorePwd", ourParams.trustStorePassword, true));
                this.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("CAIssuedCertNamesMismatch", "1", false));
                if (ourParams.isSelfSigned) {
                    this.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("AllowSelfSignedCert", "1", false));
                    this.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("AllowSelfSignedCerts", "1", false));
                }
            } else if (ourParams.authBehavior == ImpalaSettings.AuthBehavior.KERBEROS) {
                String principal;
                auth.value = ";AuthMech=1";
                Pattern impalaPrincipalPattern = Pattern.compile("(.*)/(.*)@(.*)");
                Matcher impalaPrincipalMatcher = impalaPrincipalPattern.matcher(principal = ourParams.principal.replaceAll("_HOST\\b", host.fqn));
                if (impalaPrincipalMatcher.matches()) {
                    auth.value = auth.value + ";KrbRealm=" + impalaPrincipalMatcher.group(3);
                    auth.value = auth.value + ";KrbHostFQDN=" + impalaPrincipalMatcher.group(2);
                    auth.value = auth.value + ";KrbServiceName=" + impalaPrincipalMatcher.group(1);
                } else {
                    logger.warn((Object)("Principal '" + principal + "' doesn't look like a valid kerberos principal"));
                }
                auth.displayedValue = auth.value + ";SSL=1";
                auth.value = auth.value + ";SSL=1";
                this.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("SSLTrustStore", ourParams.trustStorePath, true));
                this.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("SSLTrustStorePwd", ourParams.trustStorePassword, true));
                this.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("CAIssuedCertNamesMismatch", "1", false));
                if (ourParams.isSelfSigned) {
                    this.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("AllowSelfSignedCert", "1", false));
                    this.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("AllowSelfSignedCerts", "1", false));
                }
            } else {
                throw new IllegalArgumentException("Unsupported auth behavior " + String.valueOf((Object)ourParams.authBehavior) + " used with SSL on the Cloudera driver.");
            }
        }

        private SQLConnectionProvider.JdbcConnectionData makeCustomUrlJdbcData(HighAvailabilityHost host, Params ourParams, String hadoopUser) {
            HashMap substitutions = Maps.newHashMap();
            substitutions.put("hadoopUser", hadoopUser);
            substitutions.put("database", ourParams.db);
            StrSubstitutor substitutor = new StrSubstitutor((Map)substitutions);
            String jdbcUrl = ourParams.customUrl.replaceAll("_HOST\\b", host.fqn);
            String displayedJdbcUrl = StringUtils.defaultIfBlank((String)ourParams.customDisplayedUrl, (String)ourParams.customUrl).replaceAll("_HOST\\b", host.fqn);
            jdbcUrl = substitutor.replace(jdbcUrl);
            displayedJdbcUrl = substitutor.replace(displayedJdbcUrl);
            return new SQLConnectionProvider.SimpleJdbcConnectionData(jdbcUrl, displayedJdbcUrl, this.getProperties(false), this.getProperties(true), this.getHiddenProperties());
        }

        private String getHadoopUserIfRelevant(AuthCtx authCtx, String projectKey) throws SQLException {
            String hadoopUser = "";
            if (this.impersonationService.isEnabled()) {
                if (!this.connectionParams.useUrl && !this.connectionParams.useSimbaDriver) {
                    logger.warn((Object)"Using impala with impersonation, but not with the Simba driver.");
                }
                try {
                    hadoopUser = this.impersonationService.getTargetUser((String)projectKey, (AuthCtx)authCtx).hadoopUser;
                }
                catch (DKUSecurityException e) {
                    throw new SQLException("Impersonation denied", e);
                }
            }
            return hadoopUser;
        }

        @Override
        public ImpalaConnection getConnection() {
            return (ImpalaConnection)super.getConnection();
        }

        @Override
        public SQLConnectionProvider.SQLConnectionWrapper buildConnection(AuthCtx authCtx, String projectKey, String debugId, boolean verboseRollback) throws SQLException, DKUSecurityException, InterruptedException {
            try {
                this.getConnectionParams(authCtx, projectKey);
            }
            catch (DKUSecurityException | IOException e) {
                throw new SQLException("Cannot setup Impala connection because cluster can't be resolved", e);
            }
            ArrayList connectionExceptionMessages = Lists.newArrayList();
            while (this.hostIndex < this.connectionParams.datanodes.size()) {
                SQLConnectionProvider.JdbcConnectionData jdbcData = this.getJdbcConnectionData(authCtx, projectKey);
                jdbcData = jdbcData.expandVariables(authCtx, this.getConnection(), projectKey);
                String jdbcUrl = jdbcData.getJdbcUrl();
                logger.info((Object)("Connecting to " + jdbcData.getDisplayableJdbcUrl() + " with props: " + jdbcData.getDisplayablePropertiesAsString()));
                try {
                    Class.forName(this.getDriver(authCtx, projectKey));
                }
                catch (ClassNotFoundException e) {
                    throw new CodedSQLException(SQLCodes.ERR_SQL_CANNOT_LOAD_DRIVER, "Unable to load driver", (Throwable)e);
                }
                final Driver driver = DriverManager.getDriver(jdbcUrl);
                assert (driver != null);
                try {
                    logger.info((Object)("Driver version " + driver.getMajorVersion() + "." + driver.getMinorVersion()));
                }
                catch (Exception ex) {
                    logger.warn((Object)"Failed to get info from driver", (Throwable)ex);
                }
                try {
                    Connection conn;
                    Properties props = jdbcData.getProperties();
                    final String jdbcUrlF = jdbcUrl;
                    final Properties propsF = props;
                    if (!this.connectionParams.useUrl && this.connectionParams.authBehavior == ImpalaSettings.AuthBehavior.KERBEROS && this.connectionParams.useSimbaDriver) {
                        try {
                            conn = (Connection)UserGroupInformation.getLoginUser().doAs((PrivilegedAction)new PrivilegedAction<Connection>(){

                                @Override
                                public Connection run() {
                                    try {
                                        return driver.connect(jdbcUrlF, propsF);
                                    }
                                    catch (SQLException e) {
                                        logger.error((Object)"Failed to establish connection", (Throwable)e);
                                        return null;
                                    }
                                }
                            });
                        }
                        catch (IOException e) {
                            throw new SQLException("Cannot auth", e);
                        }
                    } else {
                        conn = driver.connect(jdbcUrlF, propsF);
                    }
                    if (conn == null) {
                        throw new SQLException("Unable to retrieve connection " + jdbcUrl);
                    }
                    SQLConnectionProvider.SQLConnectionWrapper wrapper = new SQLConnectionProvider.SQLConnectionWrapper(this, conn, debugId, verboseRollback);
                    if (StringUtils.isNotBlank((String)this.getConnection().getParams().postConnectStatements)) {
                        SQLUtils.safeSplitAndExec(this.getDialect(), wrapper, this.getConnection().getParams().postConnectStatements, true);
                    }
                    return wrapper;
                }
                catch (Exception ex) {
                    logger.warn((Object)"Failed to connect to an impala host", (Throwable)ex);
                    ++this.hostIndex;
                    connectionExceptionMessages.add(ex.getMessage());
                }
            }
            throw new SQLException("Could not connect to any of the impala hosts from the setting :\n" + Joiner.on((String)System.getProperty("line.separator")).join((Iterable)connectionExceptionMessages));
        }

        @Override
        public SQLConnectionProvider.SparkJDBCInfo getSparkConnectionInfo(AuthCtx authCtx, String projectKey) throws SQLException {
            throw new UnsupportedOperationException("Can't access Impala from Spark via JDBC");
        }

        private class StringWithDisplayedVersion {
            String value;
            String displayedValue;

            private StringWithDisplayedVersion() {
            }
        }
    }
}

