/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections.aws;

import com.dataiku.dip.connections.ConnectionWithAWSAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.AuthCtxCreationService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import java.io.IOException;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;

public class S3ConnectionAWSSessionCredentialsProviderV2
implements AwsCredentialsProvider {
    private final String identifier;
    private AuthCtx authCtx;
    private final String connectionName;
    private DSSConnection connection;

    public S3ConnectionAWSSessionCredentialsProviderV2(String identifier, String connection) {
        this.identifier = identifier;
        this.connectionName = connection;
    }

    public S3ConnectionAWSSessionCredentialsProviderV2(AuthCtx authCtx, DSSConnection connection) {
        this.authCtx = authCtx;
        this.identifier = null;
        this.connectionName = null;
        this.connection = connection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AwsCredentials resolveCredentials() {
        TransactionService ts = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (Transaction t = ts.retrieveOrBeginRead();){
            AwsCredentials awsCredentials;
            if (this.connection == null && this.authCtx == null) {
                assert (this.identifier != null);
                assert (this.connectionName != null);
                ConnectionsDAO cdao = (ConnectionsDAO)SpringUtils.getBean(ConnectionsDAO.class);
                AuthCtxCreationService accs = (AuthCtxCreationService)SpringUtils.getBean(AuthCtxCreationService.class);
                this.authCtx = accs.create(this.identifier);
                this.connection = cdao.getConnection(this.authCtx, this.connectionName);
            }
            ConnectionWithAWSAuthCredentials.SerializableAWSCredential sac = this.connection.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(this.authCtx, null), ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class);
            if (sac.sessionToken == null) {
                awsCredentials = AwsBasicCredentials.create(sac.accessKey, sac.secretKey);
                return awsCredentials;
            }
            awsCredentials = AwsSessionCredentials.create(sac.accessKey, sac.secretKey, sac.sessionToken);
            return awsCredentials;
        }
        catch (DKUSecurityException | IOException e) {
            throw new RuntimeException("Failed to get AWS credentials", e);
        }
    }
}

