/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections.iceberg;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.CredentialsRemoteFetchConfigurationProvider;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.SessionCatalog;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.TableIdentifier;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.HTTPHeaders;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.HTTPRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.ImmutableHTTPRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTClient;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth.AuthManager;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth.AuthSession;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth.OAuth2Manager;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class IcebergDSSAuthManager
implements AuthManager {
    private final String name;
    private final OAuth2Manager delegate;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.iceberg.auth_manager");

    public IcebergDSSAuthManager(String name) {
        this.name = name;
        logger.info((Object)("instantiate " + name));
        this.delegate = "gcs-credentials-refresh".equals(name) ? null : ("adls-credentials-refresh".equals(name) ? null : new OAuth2Manager("sub-" + name));
    }

    public AuthSession initSession(RESTClient initClient, Map<String, String> properties) {
        if (this.delegate == null) {
            return super.initSession(initClient, properties);
        }
        return this.delegate.initSession(initClient, properties);
    }

    public AuthSession catalogSession(RESTClient restClient, Map<String, String> properties) {
        if (this.delegate == null) {
            String fetchInfoStr;
            if (properties.containsKey("gcs.oauth2.refresh-credentials-fetch-info")) {
                fetchInfoStr = properties.get("gcs.oauth2.refresh-credentials-fetch-info");
            } else if (properties.containsKey("adls.refresh-credentials-fetch-info")) {
                fetchInfoStr = properties.get("adls.refresh-credentials-fetch-info");
            } else {
                throw new IllegalArgumentException("No fetch info passed");
            }
            String azureContainer = properties.getOrDefault("adls.refresh-credentials-container", null);
            final CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo fetchInfo = (CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo)JSON.parse((String)fetchInfoStr, CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo.class);
            return new AuthSession(){

                public HTTPRequest authenticate(HTTPRequest request) {
                    HashMap<String, String> additionalHeaders = new HashMap<String, String>();
                    if (StringUtils.isNotBlank((String)fetchInfo.sharedSecret)) {
                        additionalHeaders.putIfAbsent("X-DKU-IPythonSharedSecret", fetchInfo.sharedSecret);
                    }
                    if (StringUtils.isNotBlank((String)fetchInfo.apiTicket)) {
                        additionalHeaders.putIfAbsent("X-DKU-APITicket", fetchInfo.apiTicket);
                    }
                    if (StringUtils.isNotBlank((String)fetchInfo.apiExecutionSecret)) {
                        additionalHeaders.putIfAbsent("X-DKU-ExecutionSecretId", fetchInfo.apiExecutionSecret);
                    }
                    additionalHeaders.putAll(fetchInfo.extraHeaders);
                    additionalHeaders.put("X-DKU-CallOrigin", DKUApp.getProcessType().name());
                    if (additionalHeaders.isEmpty()) {
                        return request;
                    }
                    HTTPHeaders newHeaders = request.headers().putIfAbsent(HTTPHeaders.of(additionalHeaders));
                    return ImmutableHTTPRequest.builder().from(request).headers(newHeaders).build();
                }

                public void close() {
                }
            };
        }
        return this.delegate.catalogSession(restClient, properties);
    }

    public AuthSession tableSession(RESTClient sharedClient, Map<String, String> properties) {
        if (this.delegate == null) {
            return super.tableSession(sharedClient, properties);
        }
        return this.delegate.tableSession(sharedClient, properties);
    }

    public AuthSession contextualSession(SessionCatalog.SessionContext context, AuthSession parent) {
        if (this.delegate == null) {
            return super.contextualSession(context, parent);
        }
        return this.delegate.contextualSession(context, parent);
    }

    public AuthSession tableSession(TableIdentifier table, Map<String, String> properties, AuthSession parent) {
        if (this.delegate == null) {
            return super.tableSession(table, properties, parent);
        }
        return this.delegate.tableSession(table, properties, parent);
    }

    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }
}

