/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.containers.exec;

import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.containers.exec.ContainerExecCodes;
import com.dataiku.dip.containers.exec.ContainerExecImagesHelper;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.DockerExecUtils;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SharedSecretUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContainerExecConfigTestService {
    private static Set<String> pendingTests = new HashSet<String>();
    @Autowired
    private FutureService futureService;
    @Autowired
    private APITicketService apiTicketService;
    private static final int PING_WAIT_TIMEOUT = 300000;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.containers.test");

    private static void addTest(String testId) {
        pendingTests.add(testId);
    }

    public static void removeTest(String testId) {
        pendingTests.remove(testId);
    }

    private static boolean isTestPending(String testId) {
        return pendingTests.contains(testId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Exception runContainer(AuthCtx authCtx, ContainerExecRuntimeConfig containerConfig, DKUtils.SmartLogTailBuilder logTailBuilder, String identifier, String backendSecret, InfoMessage.InfoMessages messages) throws Exception {
        Exception exception = null;
        RegularProcess process = null;
        DKUtils.ExecOutputConsumer consumer = null;
        String projectKey = "NA";
        String imageTag = ContainerExecImagesHelper.getImageTagToUse(containerConfig.dockerHost, containerConfig.baseImage, containerConfig.baseImageType, null, null, null);
        imageTag = ContainerExecImagesHelper.withRepositoryURL(containerConfig, imageTag);
        String executionId = KubernetesExecUtils.getNormalizedExecutionId("container-test-" + identifier);
        ConnectionErrorSniffer connectionErrorSniffer = new ConnectionErrorSniffer();
        try (AutoDelete tmpDir = DSSTempUtils.getTempFolder((String)"container-config-test");){
            try {
                switch (containerConfig.type) {
                    case DOCKER: {
                        String containerName = "dku_exec-" + executionId;
                        ProcessBuilder pb = new ProcessBuilder(DockerExecUtils.getDockerRunCommand(authCtx, RemoteRunsRegistry.ExecutionType.TEST_PING, null, "NA", null, containerConfig, "--name", containerName, "-e", "DKU_API_TICKET=" + backendSecret, "-e", "DKU_CURRENT_PROJECT_KEY=" + projectKey));
                        pb.command().addAll(DockerExecUtils.getEnvironmentCommandFlags(containerConfig));
                        pb.command().addAll(Lists.newArrayList((Object[])new String[]{imageTag, executionId}));
                        ContainerExecUtils.enrichDockerEnv(containerConfig, pb.environment());
                        pb.directory((File)tmpDir);
                        logTailBuilder.appendLine("Starting Docker container");
                        process = new RegularProcess(pb, (File)tmpDir, null, authCtx, projectKey);
                        break;
                    }
                    case KUBERNETES: {
                        File podFile = new File((File)tmpDir, "pod.yaml");
                        File secretFile = new File((File)tmpDir, "secret.yaml");
                        DKUFileUtils.writeFileUTF8((File)secretFile, (String)KubernetesExecUtils.getTicketSecretConf(executionId, backendSecret));
                        KubernetesExecUtils.LabelsAndAnnotations laa = KubernetesExecUtils.getIdentifiersBasedOnCRUContext(authCtx, executionId, containerConfig);
                        DKUFileUtils.writeFileUTF8((File)podFile, (String)KubernetesExecUtils.getPodConf(authCtx, executionId, projectKey, "NA", identifier, laa, Collections.emptyMap(), imageTag, containerConfig));
                        logTailBuilder.appendLine("Starting Kubernetes pod");
                        process = new KubernetesExecUtils.KubernetesPod(authCtx, null, KubernetesExecUtils.getPodName(executionId), containerConfig, secretFile, podFile);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown execution container: " + String.valueOf((Object)containerConfig.type));
                    }
                }
                consumer = new DKUtils.ExecOutputConsumer().withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withOutputConsumer((DKUtils.ExecSubscription)connectionErrorSniffer).withErrorConsumer((DKUtils.ExecSubscription)connectionErrorSniffer).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(logTailBuilder)).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(logTailBuilder));
                if (process instanceof KubernetesExecUtils.KubernetesPod) {
                    consumer.withOutputConsumer((DKUtils.ExecSubscription)((KubernetesExecUtils.KubernetesPod)process).getErrorSniffer());
                }
                process.start();
                consumer.start(process.getInputStream(), process.getErrorStream(), process.getOutputStream());
                int rv = process.waitFor(300000L);
                if (rv < 0) {
                    logTailBuilder.appendLine("Timeout, killing waiting process");
                    process.niceThenEvilKill();
                    throw new TimeoutException("Container run has exceeded timeout");
                }
                if (rv != 0) {
                    throw new RuntimeException("Process returned " + rv);
                }
                logger.info((Object)"Container process done");
                if (process != null && process instanceof KubernetesExecUtils.KubernetesPod) {
                    RegularProcess kp = process;
                    ((KubernetesExecUtils.KubernetesPod)kp).checkSniffedException();
                    KubernetesExecUtils.KubernetesPodStatus podStatus = KubernetesExecUtils.getPodStatus(authCtx, null, ((KubernetesExecUtils.KubernetesPod)kp).getPodName(), containerConfig);
                    logger.info((Object)("K8S pod returned as " + String.valueOf(podStatus)));
                    if (podStatus.isFailed()) {
                        throw new RuntimeException("Pod finished with failure");
                    }
                }
            }
            catch (Exception e) {
                if (process != null && process instanceof KubernetesExecUtils.KubernetesPod && ((KubernetesExecUtils.KubernetesPod)process).didCreatePod()) {
                    KubernetesExecUtils.KubernetesPod kp = (KubernetesExecUtils.KubernetesPod)process;
                    try {
                        String podName = kp.getPodName();
                        if (StringUtils.isBlank((String)podName)) {
                            logger.warn((Object)"Unable to find pod of job");
                        } else {
                            logTailBuilder.appendLine("Test ran in pod : " + podName);
                            String events = KubernetesExecUtils.getObjectEvents(authCtx, null, podName, containerConfig);
                            if (StringUtils.isBlank((String)events)) {
                                logger.warn((Object)"Unable to find events of pod");
                            } else {
                                logTailBuilder.appendLine("Pod had events :");
                                for (String line : events.split("\n")) {
                                    logTailBuilder.appendLine(line);
                                }
                                if (events.toLowerCase().contains("invalidimagename")) {
                                    messages.withFatal((InfoMessage.MessageCode)ContainerExecCodes.ERR_CONTAINER_CONF_TEST_KO, "Image name/repository url combination yields invalid reference (misplaced /, : or whitespace)");
                                } else if (events.toLowerCase().contains("errimagepull")) {
                                    messages.withFatal((InfoMessage.MessageCode)ContainerExecCodes.ERR_CONTAINER_CONF_TEST_KO, "Image name/repository url combination yields an image reference that is not known to the repository or not accessible");
                                }
                            }
                        }
                    }
                    catch (Exception e2) {
                        logger.warn((Object)"Failed to grab additional k8s info", (Throwable)e2);
                    }
                }
                exception = e;
            }
            finally {
                if (process != null && process instanceof KubernetesExecUtils.KubernetesPod && ((KubernetesExecUtils.KubernetesPod)process).didCreatePod()) {
                    try {
                        ((KubernetesExecUtils.KubernetesPod)process).delete(true);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Error while cleaning k8s resources", (Throwable)e);
                    }
                }
                if (consumer != null) {
                    try {
                        consumer.finish();
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Error while closing process", (Throwable)e);
                    }
                }
                if (connectionErrorSniffer != null && connectionErrorSniffer.found != null) {
                    logTailBuilder.appendLine("Host used for the test " + RemoteRunNetworkingUtils.getBackendHost());
                    if (!StringUtils.isEmpty((String)System.getenv("DKU_BACKEND_EXT_HOST"))) {
                        logTailBuilder.appendLine("  > forced to " + System.getenv("DKU_BACKEND_EXT_HOST"));
                    }
                    messages.withFatal((InfoMessage.MessageCode)ContainerExecCodes.ERR_CONTAINER_CONF_TEST_KO, "Unable to connect to DSS from container : " + connectionErrorSniffer.found);
                }
            }
        }
        logTailBuilder.appendLine("Container done" + (String)(exception == null ? "" : " with exception: " + ExceptionUtils.getMessageWithCauses((Throwable)exception)));
        return exception;
    }

    public FutureResponse<ContainerExecTestResult> testContainerConfig(AuthCtx authCtx, ContainerExecRuntimeConfig containerConfig) throws Exception {
        final DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
        final String identifier = SecretKeyGenerator.generateSmall();
        final String executionId = KubernetesExecUtils.getNormalizedExecutionId("container-test-" + identifier);
        final ContainerExecRuntimeConfig finalContainerConfig = containerConfig;
        final AuthCtx finalAuthCtx = authCtx;
        JsonObject definition = new JsonObject();
        JsonObject payload = new JsonObject();
        payload.addProperty("futureSharedSecret", SharedSecretUtils.getSharedSecret((boolean)false));
        String testId = SecretKeyGenerator.generateSmall();
        payload.addProperty("testId", testId);
        APITicketService.Ticket ticket = this.apiTicketService.createTicket(authCtx, "Container conf testing: ", null);
        final String secret = ticket.getSecret();
        final ContainerExecTestFutureThreadParams params = new ContainerExecTestFutureThreadParams();
        params.containerConfig = containerConfig;
        params.logTailBuilder = logTailBuilder;
        params.testId = testId;
        ContainerExecTestFutureThread containerExecTestTargetFutureThread = new ContainerExecTestFutureThread(authCtx, params);
        final FutureResponse<ContainerExecTestResult> targetFutureRet = this.futureService.runFutureOnFEKAndWaitForKernel(containerExecTestTargetFutureThread, new TypeToken<FutureResponse<ContainerExecTestResult>>(){});
        payload.addProperty("futurePort", (Number)targetFutureRet.fekPort);
        RemoteRunsRegistry.add(executionId, authCtx, "NA", null, null, RemoteRunsRegistry.ExecutionType.TEST_PING, definition.toString(), payload.toString(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        SimpleFutureThread<ContainerExecTestResult> containerLaunchThread = new SimpleFutureThread<ContainerExecTestResult>(authCtx){

            public void abort() {
                try {
                    logger.info((Object)"Abort remote future");
                    ContainerExecConfigTestService.this.futureService.abort(targetFutureRet.jobId);
                }
                catch (Exception e) {
                    logger.error((Object)"Could not delete future", (Throwable)e);
                }
                super.abort();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected ContainerExecTestResult compute() throws Exception {
                ContainerExecTestResult ret = new ContainerExecTestResult();
                try {
                    FutureResponse finalResponse;
                    Exception exception = ContainerExecConfigTestService.runContainer(finalAuthCtx, finalContainerConfig, logTailBuilder, identifier, secret, ret.messages);
                    if (exception == null) {
                        finalResponse = ContainerExecConfigTestService.this.futureService.waitForFinalResponse(targetFutureRet);
                    } else {
                        finalResponse = ContainerExecConfigTestService.this.futureService.getProgress(targetFutureRet.jobId);
                        try {
                            ContainerExecConfigTestService.this.futureService.abort(targetFutureRet.jobId);
                        }
                        catch (Exception e) {
                            logger.error((Object)"Could not delete future", (Throwable)e);
                        }
                    }
                    if (finalResponse.result != null && ((ContainerExecTestResult)finalResponse.result).messages != null) {
                        ret.messages.mergeFrom(((ContainerExecTestResult)finalResponse.result).messages);
                    } else {
                        ret.messages.withFatal((InfoMessage.MessageCode)ContainerExecCodes.ERR_CONTAINER_CONF_TEST_KO, exception == null ? "Test container could not contact DSS" : ExceptionUtils.getMessageWithCauses((Throwable)exception));
                    }
                    ret.messages.summarize();
                    ret.futureLog = logTailBuilder.get();
                }
                finally {
                    RemoteRunsRegistry.remove(executionId);
                    APITicketService.Ticket ticket = ContainerExecConfigTestService.this.apiTicketService.getTicket(secret);
                    ContainerExecConfigTestService.this.apiTicketService.expireTicket(ticket);
                }
                return ret;
            }

            @Override
            public double getDangerosity() {
                return 0.0;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"test_container_exec_configuration", (String)("Test container-exec configuration " + params.containerConfig.name));
            }

            public SmartLogTail getLog() {
                return logTailBuilder.get();
            }
        };
        return this.futureService.runFuture(containerLaunchThread, 0L, new TypeToken<FutureResponse<ContainerExecTestResult>>(){});
    }

    private static class ConnectionErrorSniffer
    implements DKUtils.LineSubscription {
        public String found;

        private ConnectionErrorSniffer() {
        }

        public void close() throws IOException {
        }

        public void handle(String line, boolean replace) throws IOException {
            String msg = "Could not reach DSS:";
            if (line.contains(msg)) {
                this.found = line.substring(line.indexOf(msg) + msg.length());
            }
        }
    }

    public class ContainerExecTestFutureThreadParams {
        ContainerExecRuntimeConfig containerConfig;
        DKUtils.SmartLogTailBuilder logTailBuilder;
        String testId;
    }

    public static class ContainerExecTestFutureThread
    extends SimpleFutureThread<ContainerExecTestResult> {
        private final ContainerExecTestFutureThreadParams params;

        private ContainerExecTestFutureThread(AuthCtx authCtx, ContainerExecTestFutureThreadParams params) {
            super(authCtx);
            this.params = params;
        }

        @Override
        public ContainerExecTestResult compute() throws Exception {
            InfoMessage.InfoMessages infoMessages = new InfoMessage.InfoMessages();
            ContainerExecConfigTestService.addTest(this.params.testId);
            ContainerExecTestResult ret = new ContainerExecTestResult();
            try {
                while (ContainerExecConfigTestService.isTestPending(this.params.testId)) {
                    ContainerExecTestFutureThread.sleep((long)500L);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Problem with container execution", (Throwable)e);
                infoMessages.withFatal((InfoMessage.MessageCode)ContainerExecCodes.ERR_CONTAINER_CONF_TEST_KO, "Problem with container execution: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
                pendingTests.remove(this.params.testId);
                ret.messages = infoMessages;
                return ret;
            }
            if (!ContainerExecConfigTestService.isTestPending(this.params.testId)) {
                infoMessages.withSuccess((InfoMessage.MessageCode)ContainerExecCodes.INFO_CONTAINER_CONF_TEST_OK, "Container connected to DSS");
            } else {
                infoMessages.withFatal((InfoMessage.MessageCode)ContainerExecCodes.ERR_CONTAINER_CONF_TEST_KO, "FEK (dynamic port) could not be reached");
                pendingTests.remove(this.params.testId);
            }
            ret.messages = infoMessages;
            return ret;
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"test_container_exec_configuration_target", (String)("Future target for test container-exec configuration " + this.params.containerConfig.name));
        }

        public SmartLogTail getLog() {
            return this.params.logTailBuilder.get();
        }

        static {
            JSON.registerAdapter(ContainerExecTestFutureThread.class, (Object)new JSON.Adapter<ContainerExecTestFutureThread>(){

                public ContainerExecTestFutureThread deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext ctx) throws JsonParseException {
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    AuthCtx owner = (AuthCtx)ctx.deserialize(jsonObj.get("owner"), DSSAuthCtx.class);
                    ContainerExecTestFutureThreadParams parameters = (ContainerExecTestFutureThreadParams)ctx.deserialize(jsonObj.get("params"), ContainerExecTestFutureThreadParams.class);
                    return new ContainerExecTestFutureThread(owner, parameters);
                }

                public JsonElement serialize(ContainerExecTestFutureThread ft, Type type, JsonSerializationContext ctx) {
                    JsonObject ret = new JsonObject();
                    ret.add("owner", ctx.serialize((Object)ft.owner));
                    ret.add("params", ctx.serialize((Object)ft.params));
                    return ret;
                }
            });
        }
    }

    public static class ContainerExecTestResult {
        public InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        public SmartLogTail futureLog = new SmartLogTail();
    }
}

