/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.containers.exec;

import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolsDAO;
import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.coreservices.MLBaseService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.code.CodeEnvUsagesService;
import com.dataiku.dip.code.JupyterCodeEnvUtils;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.containers.exec.UsedContainerExec;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.recipes.MetaWithContainerizablePayload;
import com.dataiku.dip.recipes.ParamsWithContainerizable;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.server.services.IJupyterService;
import com.dataiku.dip.server.services.JupyterUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppsDAO;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContainerExecUsagesService {
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private CodeEnvUsagesService codeEnvUsagesService;
    @Autowired
    private IJupyterService jupyterService;
    @Autowired
    private MLBaseService mLBaseService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private WebAppsDAO webAppsDAO;
    @Autowired
    private AgentToolsDAO agentToolsDAO;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.containers.exec.usages");

    @Nonnull
    public List<UsedContainerExec> listUsages(String projectKey) throws IOException {
        ArrayList<UsedContainerExec> result = new ArrayList<UsedContainerExec>();
        for (ContainerExecSelection containerExecSelection : this.listContainerExecSelections(projectKey)) {
            UsedContainerExec usage = this.mapToUsedContainerExec(containerExecSelection);
            if (usage == null) continue;
            result.add(usage);
        }
        return result;
    }

    @Nonnull
    public List<UsedContainerExec> listUsagesIncludingDeletedConfigs(String projectKey) throws IOException {
        ArrayList<UsedContainerExec> result = new ArrayList<UsedContainerExec>();
        for (ContainerExecSelection containerExecSelection : this.listContainerExecSelections(projectKey)) {
            if (containerExecSelection.containerMode != ContainerExecSelection.ContainerExecMode.EXPLICIT_CONTAINER) continue;
            UsedContainerExec usage = this.mapToUsedContainerExec(containerExecSelection);
            if (usage == null) {
                usage = new UsedContainerExec(containerExecSelection.containerConf, null, null);
            }
            result.add(usage);
        }
        return result;
    }

    @Nonnull
    public List<ContainerExecSelection> listContainerExecSelections(String projectKey) throws IOException {
        Transaction t;
        List savedModelList;
        List<AnalysisCoreParams> analysisCoreParamsList;
        if (StringUtils.isBlank((String)projectKey)) {
            return List.of();
        }
        ArrayList<ContainerExecSelection> usages = new ArrayList<ContainerExecSelection>();
        try (Transaction t2 = this.transactionService.retrieveOrBeginRead();){
            usages.addAll(this.listProjectContainerExecSelections(this.projectsService.getMandatoryUnsafe(projectKey)));
            for (JupyterUtils.JupyterNotebookListEntry listEntry : this.jupyterService.listUnsafe(null, projectKey)) {
                try {
                    usages.add(this.getNotebookContainerExecSelection(listEntry, projectKey));
                }
                catch (Exception e) {
                    logger.warnV((Throwable)e, "Failed to check usages in notebook %s. Skipping.", new Object[]{listEntry.getDisplayName()});
                }
            }
            for (SerializedRecipe sr : this.recipesDAO.listUnsafe(projectKey)) {
                try {
                    ParamsWithContainerizable paramsWithContainerizablePayload;
                    ParamsWithContainerizable paramsWithContainerizable = this.getParamsWithContainerizable(sr);
                    if (paramsWithContainerizable != null) {
                        usages.add(paramsWithContainerizable.getContainerSelection());
                    }
                    if ((paramsWithContainerizablePayload = this.getParamsWithContainerizablePayload(sr)) == null) continue;
                    usages.add(paramsWithContainerizablePayload.getContainerSelection());
                }
                catch (Exception e) {
                    logger.warnV((Throwable)e, "Failed to check usages in recipe %s. Skipping.", new Object[]{sr.getDisplayName()});
                }
            }
            for (WebApp webApp : this.webAppsDAO.listUnsafe(projectKey)) {
                try {
                    usages.add(this.getWebAppContainerExecSelection(webApp));
                }
                catch (Exception e) {
                    logger.warnV((Throwable)e, "Failed to check usages in webapp %s. Skipping.", new Object[]{webApp.getDisplayName()});
                }
            }
            for (RetrievableKnowledge rk : this.retrievableKnowledgeDAO.listUnsafe(projectKey)) {
                try {
                    usages.add(rk.containerExecSelection);
                }
                catch (Exception e) {
                    logger.warnV((Throwable)e, "Failed to check usages in retrievable knowledge %s. Skipping.", new Object[]{rk.getDisplayName()});
                }
            }
            for (AgentTool agentTool : this.agentToolsDAO.listUnsafe(projectKey)) {
                try {
                    ContainerExecSelection config = agentTool.getContainerSelection();
                    if (config == null) continue;
                    usages.add(config);
                }
                catch (Exception e) {
                    logger.warnV((Throwable)e, "Failed to check usages in agent tool %s. Skipping.", new Object[]{agentTool.getDisplayName()});
                }
            }
            analysisCoreParamsList = this.analysisCRUDService.listCoreUnsafe(projectKey, null);
            savedModelList = this.savedModelsDAO.listUnsafe(projectKey);
        }
        for (AnalysisCoreParams acp : analysisCoreParamsList) {
            try {
                t = this.transactionService.retrieveOrBeginRead();
                try {
                    usages.addAll(this.listAnalysesContainerExecSelections(acp));
                }
                finally {
                    if (t == null) continue;
                    t.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to check usages in analyses . Skipping.", (Throwable)e);
            }
        }
        for (SavedModel sm : savedModelList) {
            try {
                t = this.transactionService.retrieveOrBeginRead();
                try {
                    usages.addAll(this.listSavedModelContainerExecSelections(sm));
                }
                finally {
                    if (t == null) continue;
                    t.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to check usages in saved models. Skipping", (Throwable)e);
            }
        }
        return usages.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    public ParamsWithContainerizable getParamsWithContainerizable(SerializedRecipe sr) {
        if (sr.params instanceof ParamsWithContainerizable) {
            return (ParamsWithContainerizable)((Object)sr.params);
        }
        return null;
    }

    @Nullable
    public ParamsWithContainerizable getParamsWithContainerizablePayload(SerializedRecipe sr) throws IOException {
        String payload;
        RecipeMeta recipeMeta = RecipeRegistry.getMeta(sr.type);
        if (recipeMeta instanceof MetaWithContainerizablePayload && StringUtils.isNotBlank((String)(payload = this.recipesDAO.getPayloadOrNull(sr.projectKey, sr.name)))) {
            return (ParamsWithContainerizable)JSON.parse((String)payload, ((MetaWithContainerizablePayload)((Object)recipeMeta)).getContainerizableBearingParamsClass());
        }
        return null;
    }

    @Nullable
    public ContainerExecSelection getNotebookContainerExecSelection(JupyterUtils.JupyterNotebookListEntry listEntry, String projectKey) throws IOException {
        RelFile rf = this.jupyterService.getNotebookFile(projectKey, listEntry.name);
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            JsonObject notebook = (JsonObject)t.readObjectUnsafe(rf, JsonObject.class);
            JupyterCodeEnvUtils.NotebookCodeEnvInfo kernelInfo = JupyterCodeEnvUtils.getCodeEnvInfoFromNotebook(notebook);
            if (kernelInfo != null && kernelInfo.containerConf != null) {
                ContainerExecSelection selection = new ContainerExecSelection(ContainerExecSelection.ContainerExecMode.EXPLICIT_CONTAINER);
                selection.containerConf = kernelInfo.containerConf;
                ContainerExecSelection containerExecSelection = selection;
                return containerExecSelection;
            }
            ContainerExecSelection containerExecSelection = null;
            return containerExecSelection;
        }
    }

    @Nonnull
    public List<ContainerExecSelection> listAnalysesContainerExecSelections(AnalysisCoreParams acp) throws IOException {
        ArrayList<ContainerExecSelection> usages = new ArrayList<ContainerExecSelection>();
        for (MLTask mlTask : this.analysisCRUDService.listRawMLTasks(acp.projectKey, acp.id)) {
            if (mlTask.getContainerSelection() != null) {
                usages.add(mlTask.getContainerSelection());
            }
            MLTaskLoc loc = new MLTaskLoc(acp.projectKey, acp.id, mlTask.id);
            for (FullModelId fmi : this.mLBaseService.listCompletedModelIds(loc)) {
                if (fmi.getContainerSelection() == null) continue;
                usages.add(fmi.getContainerSelection());
            }
        }
        return usages;
    }

    @Nonnull
    public List<ContainerExecSelection> listProjectContainerExecSelections(SerializedProject input) {
        return Stream.of(input.settings.container, input.settings.containerForVisualRecipesWorkloads).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    public ContainerExecSelection getWebAppContainerExecSelection(WebApp input) {
        return input.params.infra.containerSelection;
    }

    @Nonnull
    public List<ContainerExecSelection> listSavedModelContainerExecSelections(SavedModel sm) {
        return this.codeEnvUsagesService.listFmisInSavedModel(sm).stream().map(fmi -> {
            try {
                return fmi.getContainerSelection();
            }
            catch (IOException e) {
                logger.warn((Object)"Failed to check usages in saved models. Skipping", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private UsedContainerExec mapToUsedContainerExec(@Nullable ContainerExecSelection selection) throws IOException {
        if (selection == null || selection.containerMode != ContainerExecSelection.ContainerExecMode.EXPLICIT_CONTAINER) {
            return null;
        }
        ContainerExecRuntimeConfig config = this.getContainerExecRuntimeConfig(selection.containerConf);
        return config != null ? new UsedContainerExec(config) : null;
    }

    @Nullable
    private ContainerExecRuntimeConfig getContainerExecRuntimeConfig(String configName) throws IOException {
        ClusterSettings clusterSettings = new ClusterSelector().selectGlobal();
        return clusterSettings.getContainerSettings().getByNameOrNull(configName);
    }
}

