/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.containers.exec;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.ResolvedCoreParams;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.WorkloadType;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.ContainerRecipeParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.spark.SparkExecutionConfig;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class ContainerExecUtils {
    private ContainerExecUtils() {
    }

    public static Map<String, String> getContainerExecEnvironmentFlags(ContainerExecRuntimeConfig containerConfig, Map<String, String> environment) {
        HashMap ret = Maps.newHashMap(environment);
        if (containerConfig != null && containerConfig.name != null) {
            ret.put("DKU_CONTAINER_EXEC_NAME", containerConfig.name);
        }
        return ret;
    }

    public static void enrichDockerEnv(ContainerBaseConfig config, Map<String, String> env) {
        ContainerExecUtils.enrichDockerEnv(config.dockerHost, config.dockerTLSVerify, config.dockerCertPath, env);
    }

    public static void enrichDockerEnv(String dockerHost, boolean dockerTLSVerify, String dockerCertPath, Map<String, String> env) {
        if (StringUtils.isNotBlank((String)dockerHost)) {
            env.put("DOCKER_HOST", dockerHost);
        }
        if (dockerTLSVerify) {
            env.put("DOCKER_TLS_VERIFY", "1");
            if (StringUtils.isNotBlank((String)dockerCertPath)) {
                env.put("DOCKER_CERT_PATH", dockerCertPath);
            }
        }
    }

    public static void killDockerContainer(String containerName, boolean force, Map<String, String> env, DKULogger logger) {
        String[] command = new String[force ? 5 : 3];
        command[0] = "docker";
        command[1] = "stop";
        if (force) {
            command[2] = "-t";
            command[3] = "0";
            command[4] = containerName;
        } else {
            command[2] = containerName;
        }
        try {
            DKUtils.ExecutionResults status = DKUtils.execAndGetOutputAndErrors((String[])command, env);
            if (status.rv != 0) {
                logger.errorV("Could not stop docker container: return value was %d (%s)", new Object[]{status.rv, status.err});
            }
        }
        catch (IOException e) {
            logger.error((Object)"Could not stop docker container", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error((Object)"Docker container stop process was interrupted", (Throwable)e);
        }
    }

    public static List<String> getAllowedContainerNames(AuthCtx authCtx, List<ContainerExecRuntimeConfig.Container> selectedTypes, @Nullable WorkloadType workloadType) {
        List<ContainerExecRuntimeConfig> configs = ApplicationConfigurator.getGeneralSettings().containerSettings.listConfigsForWorkloadType(workloadType);
        ArrayList<String> executionConfigsNames = new ArrayList<String>();
        block4: for (ContainerExecRuntimeConfig config : configs) {
            if (!selectedTypes.contains((Object)config.type)) continue;
            if (authCtx.isAdmin()) {
                executionConfigsNames.add(config.name);
                continue;
            }
            block0 : switch (config.usableBy) {
                case ALLOWED: {
                    for (String group : config.allowedGroups) {
                        if (!authCtx.isGroupsAware() || !authCtx.isInGroup(group)) continue;
                        executionConfigsNames.add(config.name);
                        break block0;
                    }
                    continue block4;
                }
                case ALL: {
                    executionConfigsNames.add(config.name);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown container access: " + String.valueOf((Object)config.usableBy));
                }
            }
        }
        return executionConfigsNames;
    }

    public static List<SparkExecutionConfig> getAllowedSparkContainerConfigs() throws IOException {
        SparkSettings sparkSettings = new ClusterSelector().selectGlobal().getSparkSettings();
        List<SparkExecutionConfig> configs = sparkSettings.executionConfigs;
        ArrayList<SparkExecutionConfig> executionConfigs = new ArrayList<SparkExecutionConfig>();
        for (SparkExecutionConfig config : configs) {
            if (!config.kubernetesSettings.managedKubernetes) continue;
            if (config.hasConfKey("spark.kubernetes.container.image", "spark.kubernetes.executor.container.image", "spark.kubernetes.driver.container.image")) continue;
            executionConfigs.add(config);
        }
        return executionConfigs;
    }

    public static List<String> getAllowedSparkContainerConfNames() throws IOException {
        return ContainerExecUtils.getAllowedSparkContainerConfigs().stream().map(config -> config.name).toList();
    }

    public static boolean isContainerizable(MLTask.BackendType backendType) {
        return backendType.equals((Object)MLTask.BackendType.PY_MEMORY) || backendType.equals((Object)MLTask.BackendType.KERAS);
    }

    public static void expandContainerParamsIfNeeded(SerializedRecipe mlRecipe, ResolvedCoreParams coreParams) {
        if (mlRecipe == null || coreParams == null) {
            return;
        }
        if (ContainerExecUtils.isContainerizable(coreParams.backendType)) {
            if (mlRecipe.params == null) {
                mlRecipe.params = new ContainerRecipeParams();
            }
            mlRecipe.getParamsAs(ContainerRecipeParams.class).setContainerSelection(coreParams.executionParams.containerSelection);
        }
    }

    public static Map<ContainerBuildConfig, Collection<ContainerImagePush>> deduplicateContainerBuilds(Collection<ContainerBaseConfig> configurations) {
        HashMultimap configs = HashMultimap.create();
        for (ContainerBaseConfig config : configurations) {
            configs.put((Object)ContainerBuildConfig.createFrom(config), (Object)new ContainerImagePush(config.repositoryURL, config.prePushMode, config.prePushScript));
        }
        return configs.asMap();
    }

    public static abstract class ContainerBaseConfig {
        public final BaseImageType baseImageType;
        @Nullable
        public String baseImage;
        public String repositoryURL;
        public String imagePullSecretName;
        public String dockerHost;
        public DockerPrepushHookMode prePushMode = DockerPrepushHookMode.NONE;
        public String prePushScript;
        public String dockerCertPath;
        public boolean dockerTLSVerify;

        protected ContainerBaseConfig(BaseImageType baseImageType) {
            this.baseImageType = baseImageType;
        }

        protected ContainerBaseConfig(BaseImageType baseImageType, ContainerBaseConfig containerBaseConfig) {
            this(baseImageType);
            this.baseImage = containerBaseConfig.baseImage;
            this.repositoryURL = containerBaseConfig.repositoryURL;
            this.imagePullSecretName = containerBaseConfig.imagePullSecretName;
            this.dockerHost = containerBaseConfig.dockerHost;
            this.prePushMode = containerBaseConfig.prePushMode;
            this.prePushScript = containerBaseConfig.prePushScript;
            this.dockerCertPath = containerBaseConfig.dockerCertPath;
            this.dockerTLSVerify = containerBaseConfig.dockerTLSVerify;
        }

        protected ContainerBaseConfig(ContainerBaseConfig containerBaseConfig) {
            this(containerBaseConfig.baseImageType, containerBaseConfig);
        }

        public static enum DockerPrepushHookMode {
            NONE,
            ECR,
            ACR,
            GCR,
            SCS,
            CUSTOM;

        }
    }

    public static class ContainerBuildConfig
    extends ContainerBaseConfig {
        protected ContainerBuildConfig(BaseImageType baseImageType) {
            super(baseImageType);
        }

        public static ContainerBuildConfig createFrom(ContainerBaseConfig containerConfig) {
            ContainerBuildConfig result = new ContainerBuildConfig(containerConfig.baseImageType);
            result.baseImage = Objects.toString(containerConfig.baseImage, "");
            result.repositoryURL = Objects.toString(containerConfig.repositoryURL, "");
            result.imagePullSecretName = Objects.toString(containerConfig.imagePullSecretName, "");
            result.dockerHost = Objects.toString(containerConfig.dockerHost, "");
            result.dockerCertPath = Objects.toString(containerConfig.dockerCertPath, "");
            result.dockerTLSVerify = containerConfig.dockerTLSVerify;
            return result;
        }

        public static boolean isImageAlwaysBuiltLocally(String repositoryURL) {
            return StringUtils.isNotBlank((String)repositoryURL);
        }

        public static boolean isImageBuiltLocally(ContainerBuildConfig config) {
            return ContainerBuildConfig.isImageAlwaysBuiltLocally(config.repositoryURL) || StringUtils.isBlank((String)config.dockerHost);
        }

        public boolean isImageBuiltLocally() {
            return ContainerBuildConfig.isImageBuiltLocally(this);
        }

        public int hashCode() {
            return this.isImageBuiltLocally() ? Objects.hash(new Object[]{this.baseImageType, this.baseImage, "", false, ""}) : Objects.hash(new Object[]{this.baseImageType, this.baseImage, this.dockerHost, this.dockerTLSVerify, this.dockerCertPath});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ContainerBuildConfig)) {
                return false;
            }
            ContainerBuildConfig o = (ContainerBuildConfig)obj;
            if (this.isImageBuiltLocally() != o.isImageBuiltLocally()) {
                return false;
            }
            if (this.isImageBuiltLocally()) {
                return Objects.equals((Object)this.baseImageType, (Object)o.baseImageType) && Objects.equals(this.baseImage, o.baseImage);
            }
            return Objects.equals(this.baseImage, o.baseImage) && Objects.equals((Object)this.baseImageType, (Object)o.baseImageType) && Objects.equals(this.dockerHost, o.dockerHost) && Objects.equals(this.dockerTLSVerify, o.dockerTLSVerify) && Objects.equals(this.dockerCertPath, o.dockerCertPath);
        }
    }

    public static class ContainerImagePush {
        public final String repositoryURL;
        public final ContainerBaseConfig.DockerPrepushHookMode prePushMode;
        public final String prePushScript;

        public ContainerImagePush(String repositoryURL, ContainerBaseConfig.DockerPrepushHookMode prePushMode, String prePushScript) {
            this.repositoryURL = Objects.toString(repositoryURL, "");
            this.prePushMode = prePushMode;
            this.prePushScript = Objects.toString(prePushScript, "");
        }

        public int hashCode() {
            return Objects.hash(this.repositoryURL, this.prePushScript);
        }

        public boolean equals(Object o) {
            return o instanceof ContainerImagePush && Objects.equals(this.repositoryURL, ((ContainerImagePush)o).repositoryURL) && Objects.equals(this.prePushScript, ((ContainerImagePush)o).prePushScript);
        }
    }

    public static abstract class KubernetesAwareContainerConfig
    extends ContainerBaseConfig {
        public transient String overridenFromK8SClusterId;
        @JSON.FileTransient
        public boolean noImplicitK8sClusterAndNoDefaultClusterId;
        public String kubeCtlContext;
        public String kubeConfigPath;
        public boolean ensureNamespaceCompliance = false;
        public boolean createNamespace;
        public String pullRepositoryURL;

        public abstract String getRequestedKubernetesNamespace();

        protected KubernetesAwareContainerConfig(BaseImageType baseImageType) {
            super(baseImageType);
        }

        protected KubernetesAwareContainerConfig(KubernetesAwareContainerConfig kubernetesAwareContainerConfig) {
            this(kubernetesAwareContainerConfig.baseImageType, kubernetesAwareContainerConfig);
        }

        protected KubernetesAwareContainerConfig(BaseImageType baseImageType, KubernetesAwareContainerConfig kubernetesAwareContainerConfig) {
            super(baseImageType, kubernetesAwareContainerConfig);
            this.overridenFromK8SClusterId = kubernetesAwareContainerConfig.overridenFromK8SClusterId;
            this.kubeCtlContext = kubernetesAwareContainerConfig.kubeCtlContext;
            this.kubeConfigPath = kubernetesAwareContainerConfig.kubeConfigPath;
            this.ensureNamespaceCompliance = kubernetesAwareContainerConfig.ensureNamespaceCompliance;
            this.createNamespace = kubernetesAwareContainerConfig.createNamespace;
            this.pullRepositoryURL = kubernetesAwareContainerConfig.pullRepositoryURL;
        }
    }

    public static enum BaseImageType {
        EXEC,
        SPARK,
        CDE,
        CDE_PLUGINS;

    }
}

