/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.containers.exec;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cluster.ClusterProperty;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.rpc.EncryptedRPC;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DockerExecUtils {
    private DockerExecUtils() {
    }

    public static List<String> getDockerRunCommand(AuthCtx authCtx, RemoteRunsRegistry.ExecutionType execType, String projectKey, String jobId, String activityId, ContainerExecRuntimeConfig containerConfig, String ... command) {
        ArrayList ret = Lists.newArrayList((Object[])new String[]{"docker", "run", "-t"});
        if (!ApplicationConfigurator.getParams().getBoolParam("dku.containerexec.keepContainersAfterRun", false)) {
            ret.add("--rm");
        }
        if (StringUtils.isNotBlank((String)containerConfig.dockerNetwork)) {
            ret.add("--network");
            ret.add(containerConfig.dockerNetwork);
        }
        if (StringUtils.isNotBlank((String)containerConfig.dockerRuntime)) {
            ret.add("--runtime");
            ret.add(containerConfig.dockerRuntime);
        }
        if (StringUtils.isNotBlank((String)containerConfig.dockerGpus)) {
            ret.add("--gpus");
            ret.add(containerConfig.dockerGpus);
        }
        ret.add("-l");
        ret.add("com.dataiku.install-id=" + ApplicationConfigurator.getInstallId());
        ret.add("-l");
        ret.add("com.dataiku.exec-submitter=" + authCtx.getIdentifier());
        ret.add("-l");
        ret.add("com.dataiku.exec-type=" + String.valueOf((Object)execType));
        ret.add("-l");
        ret.add("com.dataiku.project-key=" + projectKey);
        if (jobId != null) {
            ret.add("-l");
            ret.add("com.dataiku.job-id=" + jobId);
        }
        if (activityId != null) {
            ret.add("-l");
            ret.add("com.dataiku.activity-id=" + activityId);
        }
        for (ClusterProperty skv : containerConfig.dockerResources) {
            ret.add("--" + skv.key.replaceFirst("^--", ""));
            ret.add(skv.value);
        }
        ret.addAll(Arrays.asList(command));
        return ret;
    }

    private static Map<String, String> getNetworkingEnvironmentFlags() {
        HashMap ret = Maps.newHashMap();
        ret.put("DKU_BACKEND_PORT", RemoteRunNetworkingUtils.getBackendRPCPort());
        ret.put("DKU_BACKEND_HOST", RemoteRunNetworkingUtils.getBackendHost());
        ret.put("DKU_BACKEND_PROTOCOL", RemoteRunNetworkingUtils.getBackendRPCProtocol());
        ret.put("DKU_BASE_PORT", RemoteRunNetworkingUtils.getBasePort());
        ret.put("DKU_BASE_PROTOCOL", RemoteRunNetworkingUtils.getBaseProtocol());
        ret.put("DKU_SERVER_KIND", String.valueOf(RemoteRunNetworkingUtils.getServerKind()));
        ret.put("DKU_SERVER_PORT", "" + RemoteRunNetworkingUtils.getServerPort());
        ret.put("DKU_SERVER_HOST", RemoteRunNetworkingUtils.getBackendHost());
        ret.put("DKU_SERVER_PROTOCOL", RemoteRunNetworkingUtils.getServerProtocol());
        if (EncryptedRPC.enabled()) {
            ret.put("DKU_SERVER_CERT", EncryptedRPC.getPEMCertificateText());
        }
        return ret;
    }

    public static List<String> formatEnvironmentFlags(Map<String, String> envVars) {
        ArrayList ret = Lists.newArrayList();
        for (Map.Entry<String, String> e : envVars.entrySet()) {
            ret.add("-e");
            ret.add(String.format("%s=%s", e.getKey(), e.getValue()));
        }
        return ret;
    }

    public static Map<String, String> getEnvironmentFlags(ContainerExecRuntimeConfig containerConfig) {
        Map<String, String> mergedEnv = ContainerExecUtils.getContainerExecEnvironmentFlags(containerConfig, Maps.newHashMap());
        mergedEnv.putAll(DockerExecUtils.getNetworkingEnvironmentFlags());
        return mergedEnv;
    }

    public static List<String> getEnvironmentCommandFlags(ContainerExecRuntimeConfig containerConfig) {
        Map<String, String> mergedEnv = DockerExecUtils.getEnvironmentFlags(containerConfig);
        return DockerExecUtils.formatEnvironmentFlags(mergedEnv);
    }
}

