/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.contribs;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.contribs.PythonContrib;
import com.dataiku.dip.util.PythonInterpreterFactory;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.filefilter.SuffixFileFilter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.python.core.PyFunction;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;

public class PythonContribService {
    private static PythonContribService service_;
    Map<String, PythonContrib> contribs;
    DKULogger logger = DKULogger.getLogger((String)"python.contrib");

    public static synchronized PythonContribService getInstance() {
        if (service_ == null) {
            service_ = new PythonContribService();
        }
        return service_;
    }

    protected File baseFolder() {
        return ApplicationConfigurator.getFile((String[])new String[]{"contribs", "python"});
    }

    public File[] listPythonFiles() {
        File baseFolder = this.baseFolder();
        if (baseFolder.exists() && baseFolder.isDirectory()) {
            return baseFolder.listFiles((FilenameFilter)new SuffixFileFilter(".py"));
        }
        return new File[0];
    }

    public void addFile(File f) throws IOException {
        if (!this.baseFolder().exists()) {
            this.baseFolder().mkdirs();
        }
        FileUtils.copyFileToDirectory((File)f, (File)this.baseFolder());
    }

    public PythonContrib getContrib(String name) {
        return this.contribs.get(name);
    }

    public PythonContrib loadContrib(File f) throws Exception {
        String fileContent = DKUFileUtils.readFileToStringUTF8((File)f);
        this.logger.info((Object)("Loading Python contrib " + String.valueOf(f)));
        try (PythonInterpreter interpreter = PythonInterpreterFactory.newInstance(true);){
            PythonContrib contrib;
            interpreter.execfile(f.getAbsolutePath());
            PyObject entryPointObj = interpreter.get("map");
            if (!(entryPointObj instanceof PyFunction)) {
                throw new Exception("No Map Function in " + String.valueOf(f));
            }
            PyFunction func = (PyFunction)entryPointObj;
            PythonContrib pythonContrib = contrib = new PythonContrib(func, f, fileContent);
            return pythonContrib;
        }
    }

    public Collection<PythonContrib> getContribs() {
        if (this.contribs != null) {
            return this.contribs.values();
        }
        this.contribs = new HashMap<String, PythonContrib>();
        if (System.getenv("DKU_NO_PYCONTRIBS") != null) {
            return this.contribs.values();
        }
        for (File f : this.listPythonFiles()) {
            try {
                PythonContrib contrib = this.loadContrib(f);
                this.contribs.put(contrib.name, contrib);
            }
            catch (Exception e) {
                this.logger.warn((Object)e);
            }
        }
        return this.contribs.values();
    }
}

