/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao.impl;

import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.prediction.DeepHubPreTrainModelingParams;
import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.mec.MECPaths;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedModelEvaluationStoresDAO
extends AbstractStandardDAO<ModelEvaluationStore>
implements ModelEvaluationStoresDAO {
    @Autowired
    private FlowGraphService graphService;

    @Override
    protected String getHumanReadableType() {
        return ITaggingService.TaggableType.MODEL_EVALUATION_STORE.toHumanReadableString();
    }

    public static boolean looksLikeAModelEvaluationStoreId(String name) {
        return name.length() == 8;
    }

    @Override
    protected ModelEvaluationStore getOrNull_noTag(String projectKey, String id, boolean unsafe) throws IOException {
        RelFile rf;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (!tr.isFile(rf = this.getDAOFile(projectKey, id))) {
            return null;
        }
        ModelEvaluationStore sm = unsafe ? (ModelEvaluationStore)tr.readObjectUnsafe(rf, ModelEvaluationStore.class) : (ModelEvaluationStore)tr.readObject(rf, ModelEvaluationStore.class);
        if (sm != null) {
            sm.id = id;
            sm.projectKey = projectKey;
        }
        return sm;
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        TransactionRef tr = TransactionContext.retrieveRead();
        RelFile modelEvaluationStoresFolder = this.modelEvaluationStoresFolder(projectKey);
        if (!tr.isDirectory(modelEvaluationStoresFolder)) {
            return 0;
        }
        return tr.listFiles(modelEvaluationStoresFolder).size();
    }

    @Override
    protected List<ModelEvaluationStore> list_noTag(String projectKey, boolean unsafe) throws IOException {
        RelFile modelEvaluationStoresFolder = this.modelEvaluationStoresFolder(projectKey);
        TransactionRef tr = TransactionContext.retrieveRead();
        ArrayList<ModelEvaluationStore> ret = new ArrayList<ModelEvaluationStore>();
        if (tr.isDirectory(modelEvaluationStoresFolder)) {
            for (RelFile f : tr.listFiles(modelEvaluationStoresFolder)) {
                try {
                    String id = StringUtils.removeEnd((String)f.getLeafName(), (String)".json");
                    ModelEvaluationStore sr = (ModelEvaluationStore)this.getMandatory(projectKey, id, unsafe);
                    ret.add(sr);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to read model evaluation store file: " + String.valueOf(f)), (Throwable)e);
                }
            }
        }
        return ret;
    }

    @Override
    public void save(ModelEvaluationStore sm) throws IOException {
        this.graphService.invalidateCache();
        super.save(sm);
    }

    @Override
    public void delete(String projectKey, String id) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        this.graphService.invalidateCache();
        t.deleteFile(this.getDAOFile(projectKey, id));
        DKUFileUtils.forceDelete((File)MECPaths.modelEvaluationStoreBaseFolder(projectKey, id));
    }

    private RelFile modelEvaluationStoresFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "model_evaluation_stores"});
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Model evaluation store id is not specified");
        return new RelFile(this.modelEvaluationStoresFolder(projectKey), new String[]{id + ".json"});
    }

    static {
        DKUtils.forceInit(DeepHubPreTrainModelingParams.class);
        DKUtils.forceInit(MLTask.class);
    }
}

