/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao.impl;

import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.coremodel.ProjectVersionTags;
import com.dataiku.dip.dao.ProjectVersionTagsDAO;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedProjectVersionTagsDAO
implements ProjectVersionTagsDAO {
    public static final String VERSION_TAGS_FILENAME = "version-tags.json";
    static DKULogger logger = DKULogger.getLogger((String)"dku.versiontags.dao");

    private RelFile getTagsFile(String projectKey) {
        return new RelFile(new String[]{"projects", projectKey, ".dss-meta", VERSION_TAGS_FILENAME});
    }

    @Override
    public ProjectVersionTags get(String projectKey, boolean unsafe) throws IOException {
        ProjectVersionTags tags;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile tagsFile = this.getTagsFile(projectKey);
        if (!t.isFile(tagsFile)) {
            tags = new ProjectVersionTags();
        } else {
            if (unsafe) {
                try (DSSMetrics.TimeCtx ignored = DSSMetrics.timeCtx((String)"dku.dao.versionTags.readFileUnsafe");){
                    tags = (ProjectVersionTags)t.readObjectUnsafe(tagsFile, ProjectVersionTags.class);
                }
            }
            try (DSSMetrics.TimeCtx ignored = DSSMetrics.timeCtx((String)"dku.dao.versionTags.readFileSafe");){
                tags = (ProjectVersionTags)t.readObject(tagsFile, ProjectVersionTags.class);
            }
        }
        return tags.withProjectKey(projectKey);
    }

    @Override
    public void save(ProjectVersionTags tags) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)tags.projectKey), (Object)"Project key is not specified");
        RWTransactionRef t = TransactionContext.retrieveWrite();
        RelFile tagsFile = this.getTagsFile(tags.projectKey);
        t.writeObject(tagsFile, (Object)tags);
    }
}

