/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao.impl;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.prediction.DeepHubPreTrainModelingParams;
import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.FileFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedSavedModelsDAO
extends AbstractStandardDAO<SavedModel>
implements SavedModelsDAO {
    @Autowired
    private FlowGraphService graphService;

    @Override
    protected String getHumanReadableType() {
        return ITaggingService.TaggableType.SAVED_MODEL.toHumanReadableString();
    }

    public static boolean looksLikeASavedModelId(String name) {
        return name.length() == 8;
    }

    @Override
    protected SavedModel getOrNull_noTag(String projectKey, String id, boolean unsafe) throws IOException {
        RelFile rf;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (!tr.isFile(rf = this.getDAOFile(projectKey, id))) {
            return null;
        }
        SavedModel sm = unsafe ? (SavedModel)tr.readObjectUnsafe(rf, SavedModel.class) : (SavedModel)tr.readObject(rf, SavedModel.class);
        if (sm != null) {
            sm.id = id;
            sm.projectKey = projectKey;
            if (sm.lastExportedFrom != null) {
                FullModelId updatedFmi = FullModelId.buildFmiWithEnforcedProjectKey(sm.lastExportedFrom, projectKey);
                sm.lastExportedFrom = updatedFmi.toString();
            }
            if (sm.savedModelType == SavedModel.SavedModelType.PYTHON_AGENT) {
                for (SavedModel.SavedModelInlineVersion smiv : sm.inlineVersions) {
                    smiv.code = this.getPythonAgentCode(projectKey, id, smiv.versionId);
                }
            }
        }
        return sm;
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        TransactionRef tr = TransactionContext.retrieveRead();
        RelFile savedModelsFolder = this.savedModelsFolder(projectKey);
        if (!tr.isDirectory(savedModelsFolder)) {
            return 0;
        }
        return tr.listFiles(savedModelsFolder, (RelFileFilter)FileFilter.json()).size();
    }

    @Override
    protected List<SavedModel> list_noTag(String projectKey, boolean unsafe) throws IOException {
        RelFile savedModelsFolder = this.savedModelsFolder(projectKey);
        TransactionRef tr = TransactionContext.retrieveRead();
        ArrayList<SavedModel> ret = new ArrayList<SavedModel>();
        if (tr.isDirectory(savedModelsFolder)) {
            for (RelFile f : tr.listFiles(savedModelsFolder, (RelFileFilter)FileFilter.json())) {
                try {
                    String id = StringUtils.removeEnd((String)f.getLeafName(), (String)".json");
                    SavedModel sr = (SavedModel)this.getMandatory(projectKey, id, unsafe);
                    ret.add(sr);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to read saved model file: " + String.valueOf(f)), (Throwable)e);
                }
            }
        }
        return ret;
    }

    @Override
    public void save(SavedModel sm) throws IOException {
        this.graphService.invalidateCache();
        super.save(sm);
        if (sm.savedModelType == SavedModel.SavedModelType.PYTHON_AGENT) {
            this.savePythonAgentCode(sm);
        }
    }

    @Override
    public void delete(String projectKey, String id) throws IOException {
        SavedModel sm = this.getOrNull_noTag(projectKey, id, false);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        this.graphService.invalidateCache();
        if (sm.savedModelType == SavedModel.SavedModelType.PYTHON_AGENT) {
            this.deletePythonCodeFiles(projectKey, id, t);
        }
        t.deleteFile(this.getDAOFile(projectKey, id));
        File modelPath = MLPaths.savedModelBaseFolder(projectKey, id);
        FilesystemACLUtils.removeACLRestrictiveMask(modelPath);
        DKUFileUtils.forceDelete((File)modelPath);
    }

    private void deletePythonCodeFiles(String projectKey, String smId, RWTransactionRef t) throws IOException {
        RelFile savedModelsFolder = this.savedModelsFolder(projectKey);
        if (t.isDirectory(savedModelsFolder)) {
            for (RelFile f : t.listFiles(savedModelsFolder, (RelFileFilter)new FileFilter(".py"))) {
                if (!f.getLeafName().startsWith(smId + "_")) continue;
                t.deleteFile(f);
            }
        }
    }

    private RelFile savedModelsFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "saved_models"});
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Saved model id is not specified");
        return new RelFile(this.savedModelsFolder(projectKey), new String[]{id + ".json"});
    }

    private RelFile getPythonAgentCodeFile(String projectKey, String smId, String version) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)smId), (Object)"Saved Model id is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)version), (Object)"Saved Model version is not specified");
        return new RelFile(new String[]{"projects", projectKey, "saved_models", smId + "_" + version + ".py"});
    }

    private String getPythonAgentCode(String projectKey, String smId, String version) throws IOException {
        RelFile codeFile;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(codeFile = this.getPythonAgentCodeFile(projectKey, smId, version))) {
            return null;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Reading agent code file " + String.valueOf(codeFile)));
        }
        return t.readStringUTF8(codeFile);
    }

    private void savePythonAgentCode(SavedModel sm) throws IOException {
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        for (SavedModel.SavedModelInlineVersion smiv : sm.inlineVersions) {
            if (smiv.code == null) continue;
            RelFile codeFile = this.getPythonAgentCodeFile(sm.projectKey, sm.id, smiv.versionId);
            tr.writeStringUTF8(codeFile, smiv.code);
        }
    }

    static {
        DKUtils.forceInit(DeepHubPreTrainModelingParams.class);
        DKUtils.forceInit(MLTask.class);
    }
}

