/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dashboards.insights;

import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.dashboards.insights.InsightsDAO;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.FileFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedInsightsDAO
extends AbstractStandardDAO<Insight>
implements InsightsDAO {
    @Override
    public String getHumanReadableType() {
        return ITaggingService.TaggableType.INSIGHT.toHumanReadableString();
    }

    @Override
    protected List<Insight> list_noTag(String projectKey, boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        ArrayList<Insight> ret = new ArrayList<Insight>();
        RelFile insightsFolder = this.getInsightsFolder(projectKey);
        if (!t.exists(insightsFolder)) {
            return ret;
        }
        for (RelFile file : t.listFiles(insightsFolder, (RelFileFilter)FileFilter.json())) {
            try {
                String insightId = StringUtils.removeEnd((String)file.getLeafName(), (String)".json");
                Insight insight = unsafe ? (Insight)t.readObjectUnsafe(file, Insight.class) : (Insight)t.readObject(file, Insight.class);
                insight.id = insightId;
                insight.projectKey = projectKey;
                ret.add(insight);
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to read insight file " + String.valueOf(file) + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }
        return ret;
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        RelFile insightsFolder;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.exists(insightsFolder = this.getInsightsFolder(projectKey))) {
            return 0;
        }
        return t.listFiles(insightsFolder, (RelFileFilter)FileFilter.json()).size();
    }

    @Override
    protected Insight getOrNull_noTag(String projectKey, String id, boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile insightFile = this.getDAOFile(projectKey, id);
        this.logger.trace((Object)("Reading insight file " + String.valueOf(insightFile)));
        if (!t.isFile(insightFile)) {
            return null;
        }
        Insight insight = unsafe ? (Insight)t.readObjectUnsafe(insightFile, Insight.class) : (Insight)t.readObject(insightFile, Insight.class);
        insight.id = id;
        insight.projectKey = projectKey;
        return insight;
    }

    @Override
    public void delete(String projectKey, String id) throws IOException {
        RelFile insightFile;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (!t.isFile(insightFile = this.getDAOFile(projectKey, id))) {
            throw new NotFoundException("Insight does not exist: " + projectKey + "." + id);
        }
        t.deleteFile(insightFile);
    }

    public RelFile getInsightsFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "insights"});
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Insight id is not specified");
        return new RelFile(this.getInsightsFolder(projectKey), new String[]{id + ".json"});
    }
}

