/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dashboards.insights.eda;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dashboards.insights.InsightHandler;
import com.dataiku.dip.dashboards.insights.InsightsDAO;
import com.dataiku.dip.dashboards.insights.eda.EdaInsightParams;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.eda.compute.sampling.SamplesService;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class EdaInsightHandler
extends InsightHandler {
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private SamplesService samplesService;
    private final Insight insight;
    private final EdaInsightParams params;

    EdaInsightHandler(Insight insight) {
        this.insight = insight;
        this.params = (EdaInsightParams)insight.params;
        SpringUtils.getInstance().autowire((Object)this);
    }

    private byte[] getParamsDigest() {
        return DigestUtils.md5((String)JSON.stableJson((Object)this.params));
    }

    @Override
    public List<InsightHandler.RequiredPermission> getRequiredPermissions() {
        String datasetSmartName = this.params.dataSpec.inputDatasetSmartName;
        if (this.params == null || StringUtils.isBlank((String)datasetSmartName)) {
            return new ArrayList<InsightHandler.RequiredPermission>();
        }
        return Lists.newArrayList((Object[])new InsightHandler.RequiredPermission[]{InsightHandler.RequiredPermission.read(ITaggingService.TaggableType.DATASET, datasetSmartName)});
    }

    @Override
    public void checkSavePermissions(AuthCtx authCtx, Insight previous) throws UnauthorizedException {
        try {
            this.permissionsService.checkProjectPrivileges(authCtx, this.insight.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_DASHBOARDS);
        }
        catch (DKUSecurityException e) {
            throw new UnauthorizedException("Failed to save insight", "check-failed", (Throwable)e);
        }
    }

    @Override
    public void savePayload(String payload, InsightsDAO dao) throws IOException {
        if (payload != null && !payload.isEmpty()) {
            FileUtils.writeByteArrayToFile((File)this.getFingerprintFile(), (byte[])this.getParamsDigest());
            FileUtils.writeStringToFile((File)this.getCardResultFile(), (String)payload);
        }
    }

    private File getCardResultDirectory() {
        return ApplicationConfigurator.getFile((String[])new String[]{"insights-data", this.insight.projectKey, "eda", this.insight.id});
    }

    private File getCardResultFile() {
        return DKUFileUtils.getWithin((File)this.getCardResultDirectory(), (String[])new String[]{"eda-card-result.json"});
    }

    private File getFingerprintFile() {
        return ApplicationConfigurator.getFile((String[])new String[]{"insights-data", this.insight.projectKey, "eda", this.insight.id, "eda-card-result.fingerprint"});
    }

    @Override
    public String getPayload() throws IOException {
        byte[] hashStored;
        byte[] currentHash = this.getParamsDigest();
        try {
            hashStored = FileUtils.readFileToByteArray((File)this.getFingerprintFile());
        }
        catch (Exception e) {
            hashStored = new byte[]{};
        }
        if (!Arrays.equals(currentHash, hashStored)) {
            return JSON.json((Object)((Object)new CardResult.UnavailableCardResult(CardResult.UnavailabilityReason.OUTDATED, null, null)));
        }
        String payload = FileUtils.readFileToString((File)this.getCardResultFile());
        return payload;
    }

    @Override
    public void beforeDelete() throws IOException {
        DKUFileUtils.deleteDirectory((File)this.getCardResultDirectory());
        this.samplesService.removeByRef(new TaggableObjectsService.TaggableObjectRef(this.insight));
    }
}

