/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datadirectories;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.datadirectories.DataDirectoriesBucketer;
import com.dataiku.dip.datadirectories.DataDirectoriesFootprintModel;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class DataDirectoriesFootprintHierarchy {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.directories-footprint.hierarchy");
    public static Walker defaultWalker = DataDirectoriesFootprintHierarchy.makeRealWalker();

    private static Walker makeRealWalker() {
        return Files::walkFileTree;
    }

    public static void forceDefaultWalker(Walker walker) {
        defaultWalker = walker != null ? walker : DataDirectoriesFootprintHierarchy.makeRealWalker();
    }

    private static DataDirectoriesBucketer.Bucket buildFullDatadirHierarchy(DataDirectoriesBucketer.BucketingContext context, List<String> projectKeys) {
        return new DataDirectoriesBucketer.DatadirRoot(context).then(new DataDirectoriesBucketer.SomeFolder(context, "analysis-data").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.analysis, fp -> {
            fp.analysis = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "apinode-packages").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.apiNodePackages, fp -> {
            fp.apiNodePackages = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "insights-data").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.insights, fp -> {
            fp.insights = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "code-reports").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.codeReports, fp -> {
            fp.codeReports = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "managed_datasets").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.managedDatasets, fp -> {
            fp.managedDatasets = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "managed_folders").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.managedFolders, fp -> {
            fp.managedFolders = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "model_evaluation_stores").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.modelEvaluationStores, fp -> {
            fp.modelEvaluationStores = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "prepared_bundles").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.preparedBundles, fp -> {
            fp.preparedBundles = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "agent-tools").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.agentTools, fp -> {
            fp.agentTools = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "prompt-studios").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.promptStudios, fp -> {
            fp.promptStudios = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "python-guardrails").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.pythonGuardrails, fp -> {
            fp.pythonGuardrails = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "saved_models").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.savedModels, fp -> {
            fp.savedModels = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "scenarios").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.scenarios, fp -> {
            fp.scenarios = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "streaming-logs").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.continuousActivities, fp -> {
            fp.continuousActivities = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "wiki-attachments").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.wikiAttachments, fp -> {
            fp.wikiAttachments = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "webappruns").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.webApps, fp -> {
            fp.webApps = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "uploads").then(new DataDirectoriesBucketer.SomeFolder(context, "tmp_upload_box").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.tmp, fp -> {
            fp.tmp = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.uploadedDatasets, fp -> {
            fp.uploadedDatasets = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "thumbnails").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.thumbnails, fp -> {
            fp.thumbnails = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolderByPattern(context, "_pre_migration_backup_.*", true).then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.migrationBackups, fp -> {
            fp.migrationBackups = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "bin").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.bin, fp -> {
            fp.bin = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SpecificFilesGlobalAggregation(context, fp -> fp.globalFiles, fp -> {
            fp.globalFiles = new DataDirectoriesFootprintModel.SizeWithLocation();
        }, "((dss-version.json)|(install.ini)|(instance-id.txt))")).then(new DataDirectoriesBucketer.SomeFolder(context, "install-support").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.installSupport, fp -> {
            fp.installSupport = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "html-apps").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.installSupport, fp -> {
            fp.installSupport = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "run").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.run, fp -> {
            fp.run = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "most-used-datasets").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.tmp, fp -> {
            fp.tmp = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "tmp").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.tmp, fp -> {
            fp.tmp = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "privtmp").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.privtmp, fp -> {
            fp.privtmp = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "uif-tmp").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.uiftmp, fp -> {
            fp.uiftmp = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "pyenv").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.pyenv, fp -> {
            fp.pyenv = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "databases").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.runtimeDatabases, fp -> {
            fp.runtimeDatabases = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "data-catalog").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.dataCatalog, fp -> {
            fp.dataCatalog = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "cost-limiting").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.costLimiting, fp -> {
            fp.costLimiting = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "resources").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.resources, fp -> {
            fp.resources = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "clusters").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.clusters, fp -> {
            fp.clusters = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "code-envs").then(new DataDirectoriesBucketer.SomeFolderByPattern(context, "(desc|logs|resources)", false).then(new DataDirectoriesBucketer.TechnicalFiles()).then(new DataDirectoriesBucketer.SpecificFilesGlobalAggregation(context, fp -> fp.git, fp -> {
            fp.git = new DataDirectoriesFootprintModel.SizeWithLocation();
        }, "\\..*gitignore")).then(new DataDirectoriesBucketer.SomeFolder(context, ".git").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.git, fp -> {
            fp.git = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolderByPattern(context, "(python|R|julia)", false).then(new DataDirectoriesBucketer.CodeEnvList(context).then(new DataDirectoriesBucketer.CodeEnvAggregation(context))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolderByPattern(context, "(python|R|julia)", false).then(new DataDirectoriesBucketer.CodeEnvList(context).then(new DataDirectoriesBucketer.CodeEnvAggregation(context))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "acode-envs").then(new DataDirectoriesBucketer.SomeFolder(context, "logs").then(new DataDirectoriesBucketer.SomeFolderByPattern(context, "(python|R|julia)", false).then(new DataDirectoriesBucketer.CodeEnvList(context).then(new DataDirectoriesBucketer.CodeEnvAggregation(context))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolderByPattern(context, "(python|R|julia)", false).then(new DataDirectoriesBucketer.CodeEnvList(context).then(new DataDirectoriesBucketer.CodeEnvAggregation(context))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "diagnosis").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.diagnosis, fp -> {
            fp.diagnosis = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "exports").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.exports, fp -> {
            fp.exports = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "local").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.local, fp -> {
            fp.local = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "story").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.story, fp -> {
            fp.story = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "bundle_activation_backups").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.bundleActivationBackups, fp -> {
            fp.bundleActivationBackups = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "R.lib").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.RLib, fp -> {
            fp.RLib = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "unified-monitoring").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.unifiedMonitoring, fp -> {
            fp.unifiedMonitoring = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "timelines").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.timelines, fp -> {
            fp.timelines = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "popular-datasets").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.popularDatasets, fp -> {
            fp.popularDatasets = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "model_cache").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.modelCache, fp -> {
            fp.modelCache = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "plugins").then(new DataDirectoriesBucketer.SomeFolderByPattern(context, "(dev|installed)", false).then(new DataDirectoriesBucketer.PluginList(context).then(new DataDirectoriesBucketer.PluginAggregation(context))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "api-deployer").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.apiDeployer, fp -> {
            fp.apiDeployer = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "features-usage").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.featuresUsage, fp -> {
            fp.featuresUsage = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "code-studio-templates").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.codeStudioTemplates, fp -> {
            fp.codeStudioTemplates = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "jupyter-run").then(new DataDirectoriesBucketer.SomeFolder(context, "dku-workdirs").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.dkuWorkdirs, fp -> {
            fp.dkuWorkdirs = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolderByPattern(context, "(ipython|jupyter)", false).then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.jupyterRun, fp -> {
            fp.jupyterRun = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "notebook_results").then(new DataDirectoriesBucketer.SomeFolderByPattern(context, "(sql|jupyter)", false).then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.notebookResults, fp -> {
            fp.notebookResults = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "caches").then(new DataDirectoriesBucketer.SomeFolder(context, "shaker-full-pivot-lino").then(new DataDirectoriesBucketer.ProjectUnderscoreStuffList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.shakerFullPivot, fp -> {
            fp.shakerFullPivot = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "shaker-samples").then(new DataDirectoriesBucketer.ProjectDotStuffList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.shakerSamples, fp -> {
            fp.shakerSamples = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.caches, fp -> {
            fp.caches = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "lib").then(new DataDirectoriesBucketer.SomeFolder(context, "projects").then(new DataDirectoriesBucketer.TechnicalFiles()).then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.libResources, fp -> {
            fp.libResources = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "code_studio").then(new DataDirectoriesBucketer.TechnicalFiles()).then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.codeStudioResources, fp -> {
            fp.codeStudioResources = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "user-data").then(new DataDirectoriesBucketer.TechnicalFiles()).then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.lib, fp -> {
            fp.lib = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolderByPattern(context, ".*", false).then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.lib, fp -> {
            fp.lib = new DataDirectoriesFootprintModel.SizeWithLocation();
        })))).then(new DataDirectoriesBucketer.SomeFolder(context, "jobs").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.jobs, fp -> {
            fp.jobs = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "imported_bundles").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.importedBundles, fp -> {
            fp.importedBundles = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "project-standards").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.projectStandards, fp -> {
            fp.projectStandards = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "workload-folders").then(new DataDirectoriesBucketer.SomeFolderByPattern(context, ".*", false).then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.workloadFolders, fp -> {
            fp.workloadFolders = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole()))).then(new DataDirectoriesBucketer.SomeFolder(context, "docportal").then(new DataDirectoriesBucketer.SomeFolder(context, "global").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.docportal, fp -> {
            fp.docportal = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "projects").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.docportal, fp -> {
            fp.docportal = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "config").then(new DataDirectoriesBucketer.TechnicalFiles()).then(new DataDirectoriesBucketer.SpecificFilesGlobalAggregation(context, fp -> fp.git, fp -> {
            fp.git = new DataDirectoriesFootprintModel.SizeWithLocation();
        }, "\\..*gitignore")).then(new DataDirectoriesBucketer.SomeFolder(context, ".git").then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.git, fp -> {
            fp.git = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SomeFolder(context, "projects").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.SomeFolder(context, ".git").then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.git, fp -> {
            fp.git = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.config, fp -> {
            fp.config = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "ipython_notebooks").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.notebooks, fp -> {
            fp.notebooks = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolderByPattern(context, "(clusters|code_studio_templates|project_folders|plugins|user-data|api-deployer|code-snippets|workspaces|project-deployer|data-collections|meanings|user-pictures)", false).then(new DataDirectoriesBucketer.GlobalAggregation(context, fp -> fp.globalConfig, fp -> {
            fp.globalConfig = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.SpecificFilesGlobalAggregation(context, fp -> fp.globalConfig, fp -> {
            fp.globalConfig = new DataDirectoriesFootprintModel.SizeWithLocation();
        }, "((dip.properties)|(.*\\.json))")).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "code_studios").then(new DataDirectoriesBucketer.SomeFolder(context, "exec").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.codeStudios, fp -> {
            fp.codeStudios = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "merge_requests").then(new DataDirectoriesBucketer.SomeFolder(context, "projects").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.mergeRequests, fp -> {
            fp.mergeRequests = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "knowledge-banks").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.knowledgeBanks, fp -> {
            fp.knowledgeBanks = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.SomeFolder(context, "project-deployer").then(new DataDirectoriesBucketer.SomeFolder(context, "projects").then(new DataDirectoriesBucketer.ProjectList(context, projectKeys).then(new DataDirectoriesBucketer.ProjectAggregation(context, fp -> fp.projectDeployer, fp -> {
            fp.projectDeployer = new DataDirectoriesFootprintModel.SizeWithLocation();
        }))).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.Blackhole())).then(new DataDirectoriesBucketer.Blackhole());
    }

    private static DataDirectoriesBucketer.Bucket getHierarchyOfType(HierarchyType hierarchyType, DataDirectoriesBucketer.BucketingContext context, List<String> projectKeys) {
        DataDirectoriesBucketer.Bucket hierarchy = DataDirectoriesFootprintHierarchy.buildFullDatadirHierarchy(context, projectKeys);
        return DataDirectoriesBucketer.transformRecursively(hierarchy, hierarchyType.visitor(), hierarchyType.simplifier(context));
    }

    public static DataDirectoriesBucketer.Bucket buildFullDatadirHierarchyForTests(DataDirectoriesFootprintModel.DatadirFootprint global, List<String> projectKeys) {
        DataDirectoriesBucketer.BucketingContext context = new DataDirectoriesBucketer.BucketingContext(global);
        context.knownProjects = new DataDirectoriesFootprintModel.Sizes();
        return DataDirectoriesFootprintHierarchy.buildFullDatadirHierarchy(context, projectKeys);
    }

    public static DataDirectoriesBucketer.Bucket buildSingleProjectDatadirHierarchy(DataDirectoriesFootprintModel.ProjectFootprint project) {
        return DataDirectoriesFootprintHierarchy.buildSingleProjectDatadirHierarchy(new DataDirectoriesFootprintModel.DatadirFootprint(), project);
    }

    static DataDirectoriesBucketer.Bucket buildSingleProjectDatadirHierarchy(DataDirectoriesFootprintModel.DatadirFootprint global, DataDirectoriesFootprintModel.ProjectFootprint project) {
        global.projects = DataDirectoriesFootprintModel.Sizes.of(project);
        DataDirectoriesBucketer.BucketingContext context = new DataDirectoriesBucketer.BucketingContext(global);
        context.knownProjects = global.projects;
        return DataDirectoriesFootprintHierarchy.getHierarchyOfType(new SingleKnownProjectHierarchyType(project), context, (List<String>)ImmutableList.of((Object)project.projectKey));
    }

    public static DataDirectoriesBucketer.Bucket buildAllProjectsDatadirHierarchy(List<DataDirectoriesFootprintModel.ProjectFootprint> projects, List<String> projectKeys) {
        return DataDirectoriesFootprintHierarchy.buildAllProjectsDatadirHierarchy(new DataDirectoriesFootprintModel.DatadirFootprint(), projects, projectKeys);
    }

    static DataDirectoriesBucketer.Bucket buildAllProjectsDatadirHierarchy(DataDirectoriesFootprintModel.DatadirFootprint global, List<DataDirectoriesFootprintModel.ProjectFootprint> projects, List<String> projectKeys) {
        global.projects = new DataDirectoriesFootprintModel.Sizes<DataDirectoriesFootprintModel.ProjectFootprint>(projects);
        DataDirectoriesBucketer.BucketingContext context = new DataDirectoriesBucketer.BucketingContext(global);
        context.knownProjects = global.projects;
        return DataDirectoriesFootprintHierarchy.getHierarchyOfType(new AllKnownProjectsHierarchyType(), context, projectKeys);
    }

    public static DataDirectoriesBucketer.Bucket buildGlobalDatadirHierarchy(DataDirectoriesFootprintModel.DatadirFootprint global) {
        DataDirectoriesBucketer.BucketingContext context = new DataDirectoriesBucketer.BucketingContext(global);
        return DataDirectoriesFootprintHierarchy.getHierarchyOfType(new GlobalDataHierarchyType(), context, new ArrayList<String>());
    }

    public static DataDirectoriesBucketer.Bucket buildOrphanProjectsDatadirHierarchy(List<DataDirectoriesFootprintModel.ProjectFootprint> projects, List<String> projectKeys) {
        return DataDirectoriesFootprintHierarchy.buildOrphanProjectsDatadirHierarchy(new DataDirectoriesFootprintModel.DatadirFootprint(), projects, projectKeys);
    }

    static DataDirectoriesBucketer.Bucket buildOrphanProjectsDatadirHierarchy(DataDirectoriesFootprintModel.DatadirFootprint global, List<DataDirectoriesFootprintModel.ProjectFootprint> projects, List<String> projectKeys) {
        global.orphanProjects = new DataDirectoriesFootprintModel.Sizes<DataDirectoriesFootprintModel.ProjectFootprint>(projects);
        DataDirectoriesBucketer.BucketingContext context = new DataDirectoriesBucketer.BucketingContext(global);
        context.unknownProjects = global.orphanProjects;
        return DataDirectoriesFootprintHierarchy.getHierarchyOfType(new OrphanProjectsHierarchyType(projectKeys), context, projectKeys);
    }

    public static DataDirectoriesBucketer.Bucket buildUnknownDatadirHierarchy(List<DataDirectoriesFootprintModel.UnknownData> unknownData) {
        return DataDirectoriesFootprintHierarchy.buildUnknownDatadirHierarchy(new DataDirectoriesFootprintModel.DatadirFootprint(), unknownData);
    }

    static DataDirectoriesBucketer.Bucket buildUnknownDatadirHierarchy(DataDirectoriesFootprintModel.DatadirFootprint global, List<DataDirectoriesFootprintModel.UnknownData> unknownData) {
        global.unknown = new DataDirectoriesFootprintModel.Sizes<DataDirectoriesFootprintModel.UnknownData>(unknownData);
        DataDirectoriesBucketer.BucketingContext context = new DataDirectoriesBucketer.BucketingContext(global);
        return DataDirectoriesFootprintHierarchy.getHierarchyOfType(new UnknownDataHierarchyType(context), context, new ArrayList<String>());
    }

    public static DataDirectoriesBucketer.Bucket buildAllDSSDatadirHierarchy(DataDirectoriesFootprintModel.DatadirFootprint global, List<String> projectKeys) {
        global.projects = new DataDirectoriesFootprintModel.Sizes();
        global.orphanProjects = new DataDirectoriesFootprintModel.Sizes();
        DataDirectoriesBucketer.BucketingContext context = new DataDirectoriesBucketer.BucketingContext(global);
        context.knownProjects = global.projects;
        context.unknownProjects = global.orphanProjects;
        return DataDirectoriesFootprintHierarchy.buildFullDatadirHierarchy(context, projectKeys);
    }

    public static FileVisitor<Path> buildVisitor(Path visitRoot, DataDirectoriesBucketer.Bucket hierarchy) {
        String hangOnPath = DKUApp.getParams().getParam("dku.testHarness.hangOnPath", null);
        return DataDirectoriesFootprintHierarchy.buildVisitor(visitRoot, hierarchy, hangOnPath);
    }

    static FileVisitor<Path> buildVisitor(Path visitRoot, DataDirectoriesBucketer.Bucket hierarchy, String hangPattern) {
        return new HierarchyVisitor(visitRoot, hierarchy, hangPattern);
    }

    public static interface Walker {
        public void walk(Path var1, FileVisitor<Path> var2) throws IOException;
    }

    public static interface HierarchyType {
        public DataDirectoriesBucketer.BucketVisitor visitor();

        public DataDirectoriesBucketer.NodeBucketSimplifier simplifier(DataDirectoriesBucketer.BucketingContext var1);
    }

    public static class SingleKnownProjectHierarchyType
    implements HierarchyType {
        private final DataDirectoriesFootprintModel.ProjectFootprint project;

        public SingleKnownProjectHierarchyType(DataDirectoriesFootprintModel.ProjectFootprint project) {
            this.project = project;
        }

        @Override
        public DataDirectoriesBucketer.BucketVisitor visitor() {
            return new DataDirectoriesBucketer.KeepProjectDataVisitor();
        }

        @Override
        public DataDirectoriesBucketer.NodeBucketSimplifier simplifier(DataDirectoriesBucketer.BucketingContext context) {
            return new DataDirectoriesBucketer.SingleProjectSimplifier(context, this.project);
        }
    }

    public static class AllKnownProjectsHierarchyType
    implements HierarchyType {
        @Override
        public DataDirectoriesBucketer.BucketVisitor visitor() {
            return new DataDirectoriesBucketer.KeepProjectDataVisitor();
        }

        @Override
        public DataDirectoriesBucketer.NodeBucketSimplifier simplifier(DataDirectoriesBucketer.BucketingContext context) {
            return new DataDirectoriesBucketer.BasicSimplifier(context);
        }
    }

    public static class GlobalDataHierarchyType
    implements HierarchyType {
        @Override
        public DataDirectoriesBucketer.BucketVisitor visitor() {
            return new DataDirectoriesBucketer.KeepGlobalDataVisitor();
        }

        @Override
        public DataDirectoriesBucketer.NodeBucketSimplifier simplifier(DataDirectoriesBucketer.BucketingContext context) {
            return new DataDirectoriesBucketer.BasicSimplifier(context);
        }
    }

    public static class OrphanProjectsHierarchyType
    implements HierarchyType {
        private final List<String> projectKeys;

        public OrphanProjectsHierarchyType(List<String> projectKeys) {
            this.projectKeys = projectKeys;
        }

        @Override
        public DataDirectoriesBucketer.BucketVisitor visitor() {
            return new DataDirectoriesBucketer.KeepProjectDataVisitor();
        }

        @Override
        public DataDirectoriesBucketer.NodeBucketSimplifier simplifier(DataDirectoriesBucketer.BucketingContext context) {
            return new DataDirectoriesBucketer.OrphanProjectsSimplifier(context, this.projectKeys);
        }
    }

    public static class UnknownDataHierarchyType
    implements HierarchyType {
        private final DataDirectoriesBucketer.BucketingContext context;

        public UnknownDataHierarchyType(DataDirectoriesBucketer.BucketingContext context) {
            this.context = context;
        }

        @Override
        public DataDirectoriesBucketer.BucketVisitor visitor() {
            return new DataDirectoriesBucketer.KeepUnknownDataVisitor(this.context);
        }

        @Override
        public DataDirectoriesBucketer.NodeBucketSimplifier simplifier(DataDirectoriesBucketer.BucketingContext context) {
            return new DataDirectoriesBucketer.KnownDataSkipper(context);
        }
    }

    private static class HierarchyVisitor
    implements FileVisitor<Path> {
        private final Path visitRoot;
        private final DataDirectoriesBucketer.Bucket hierarchy;
        private final Pattern hangPattern;
        private final Stack<VisitStep> steps = new Stack();

        public HierarchyVisitor(Path visitRoot, DataDirectoriesBucketer.Bucket hierarchy, String hangPattern) {
            this.visitRoot = visitRoot;
            this.hierarchy = hierarchy;
            this.hangPattern = StringUtils.isBlank((String)hangPattern) ? null : Pattern.compile(hangPattern);
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            this.hangIfAppropriate(dir);
            if (!dir.startsWith(this.visitRoot)) {
                logger.warnV("preVisitDirectory outside %s", new Object[]{dir});
                return FileVisitResult.CONTINUE;
            }
            Path relativeDir = this.visitRoot.relativize(dir);
            logger.trace(() -> String.format("preVisitDirectory inside %s depth %s", relativeDir, this.steps.size()));
            if (this.steps.isEmpty()) {
                if (this.hierarchy.handles(relativeDir, false)) {
                    return this.enterDirectory(relativeDir, this.hierarchy);
                }
                throw new IOException("Unable to visit, can't start from " + String.valueOf(relativeDir));
            }
            VisitStep top = this.steps.peek();
            if (top.bucket instanceof DataDirectoriesBucketer.NodeBucket) {
                for (DataDirectoriesBucketer.Bucket node : ((DataDirectoriesBucketer.NodeBucket)top.bucket).possibilities()) {
                    if (!node.handles(relativeDir, false)) continue;
                    if (node.recurse()) {
                        return this.enterDirectory(relativeDir, node);
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }
                throw new IOException("Unable to visit, no bucketing possible for " + String.valueOf(relativeDir) + " inside " + String.valueOf(top));
            }
            return this.enterDirectory(relativeDir, top.bucket);
        }

        private FileVisitResult enterDirectory(Path relativeDir, DataDirectoriesBucketer.Bucket bucket) {
            bucket.onEnter(relativeDir);
            this.steps.push(new VisitStep(relativeDir, bucket));
            return FileVisitResult.CONTINUE;
        }

        private DataDirectoriesBucketer.AggregatingBucket getAggregator(Path relativeFile, DataDirectoriesBucketer.Bucket bucket) throws IOException {
            if (bucket instanceof DataDirectoriesBucketer.NodeBucket) {
                for (DataDirectoriesBucketer.Bucket node : ((DataDirectoriesBucketer.NodeBucket)bucket).possibilities()) {
                    if (!node.handles(relativeFile, true)) continue;
                    if (node instanceof DataDirectoriesBucketer.AggregatingBucket) {
                        return (DataDirectoriesBucketer.AggregatingBucket)node;
                    }
                    throw new IOException("Unable to visit, bucketing for " + String.valueOf(relativeFile) + " is not handled by " + String.valueOf(node));
                }
                throw new IOException("Unable to visit, no bucketing possible for " + String.valueOf(relativeFile) + " inside " + String.valueOf(bucket));
            }
            if (bucket instanceof DataDirectoriesBucketer.AggregatingBucket) {
                return (DataDirectoriesBucketer.AggregatingBucket)bucket;
            }
            throw new IOException("File in unexpected location : " + String.valueOf(relativeFile) + " but bucket is " + String.valueOf(bucket));
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.hangIfAppropriate(file);
            VisitStep top = this.steps.peek();
            Path relativeFile = this.visitRoot.relativize(file);
            logger.trace(() -> String.format("visitFile %s depth %s", relativeFile, this.steps.size()));
            DataDirectoriesBucketer.AggregatingBucket aggregator = this.getAggregator(relativeFile, top.bucket);
            aggregator.handle(relativeFile, attrs.size(), false);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            logger.trace(() -> String.format("visitFileFailed %s depth %s : %s : %s", file, this.steps.size(), exc.getClass().getSimpleName(), ExceptionUtils.getMessageWithCauses((Throwable)exc)));
            VisitStep top = this.steps.peek();
            Path relativeFile = this.visitRoot.relativize(file);
            DataDirectoriesBucketer.AggregatingBucket aggregator = this.getAggregator(relativeFile, top.bucket);
            aggregator.handle(relativeFile, 0L, true);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            if (!dir.startsWith(this.visitRoot)) {
                logger.trace(() -> String.format("postVisitDirectory outside %s", dir));
                return FileVisitResult.CONTINUE;
            }
            Path relativeDir = this.visitRoot.relativize(dir);
            logger.trace(() -> String.format("postVisitDirectory inside  %s depth %s", relativeDir, this.steps.size()));
            VisitStep popped = this.steps.pop();
            popped.bucket.onExit(relativeDir);
            return FileVisitResult.CONTINUE;
        }

        private void hangIfAppropriate(Path file) {
            if (this.hangPattern != null && this.hangPattern.matcher(file.toString()).matches()) {
                logger.infoV("Hanging 60s on %s", new Object[]{file});
                DKUtils.unsafeSleep((long)60000L);
            }
        }
    }

    private static class VisitStep {
        DataDirectoriesBucketer.Bucket bucket;
        Path path;

        VisitStep(Path path, DataDirectoriesBucketer.Bucket bucket) {
            this.path = path;
            this.bucket = bucket;
        }
    }
}

