/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow;

import com.dataiku.common.server.APIError;
import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.activity.ConnectionTasksService;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.ActivityState;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.FlowModelEvaluationStore;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.FlowSavedModel;
import com.dataiku.dip.dataflow.jobrunner.SerializedJobActivity;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.dataflow.pipeline.AbstractPipelineRunnableSubgraph;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class JobActivity {
    private SerializedJobActivityStatus status;
    private RunnableSubgraph subgraph;
    public ActivityRunSummary runSummary = new ActivityRunSummary();
    public boolean skipExplicitOrWriteProtected = false;
    public boolean topLevelActivity;
    public boolean pruned;
    public Throwable firstFailure;
    public int aliveThreads;
    public long startTime;
    public long endTime;
    public ActivityState state = ActivityState.NOT_STARTED;
    public WarningsContext warnContext = new WarningsContext();
    public List<JobActivity> dependencies = new ArrayList<JobActivity>();
    public RecipeRunningThings runningThings = new RecipeRunningThings();
    public RequiredReason requiredReason;
    ActivityTimer preparingTimer = new ActivityTimer();
    ActivityTimer runningTimer = new ActivityTimer();
    ActivityTimer waitingTimer = new ActivityTimer();
    private static Logger logger = Logger.getLogger((String)"dku.job.activity");

    public String id() {
        if (this.subgraph == null) {
            return "ROOT";
        }
        return this.subgraph.id();
    }

    public RunnableSubgraph getSubgraph() {
        return this.subgraph;
    }

    public JobActivity(RunnableSubgraph subgraph) {
        this.subgraph = subgraph;
    }

    public JobActivity withDependencies(List<JobActivity> dependencies) {
        this.dependencies.addAll(dependencies);
        return this;
    }

    public synchronized void initStatus() {
        if (this.status != null) {
            return;
        }
        this.status = new SerializedJobActivityStatus();
        this.status.activityId = this.id();
        this.status.def = this.getSerialized();
        this.status.skipExplicitOrWriteProtected = this.skipExplicitOrWriteProtected;
        if (this.subgraph instanceof RecipeRunnableSubgraph) {
            this.status.activityType = SerializedJobActivityStatus.ActivityType.RECIPE;
            this.status.recipeType = ((RecipeRunnableSubgraph)this.subgraph).getRecipe().getModel().type;
            this.status.recipeName = this.subgraph.getName();
        } else if (this.subgraph instanceof AbstractPipelineRunnableSubgraph) {
            AbstractPipelineRunnableSubgraph pipelineRunnableSubgraph = (AbstractPipelineRunnableSubgraph)this.subgraph;
            this.status.activityType = pipelineRunnableSubgraph.getActivityType();
            for (JobActivity subActivity : pipelineRunnableSubgraph.getAllIncludedActivitiesWithRoot()) {
                if (!(subActivity.getSubgraph() instanceof RecipeRunnableSubgraph)) continue;
                RecipeRunnableSubgraph subRecipe = (RecipeRunnableSubgraph)subActivity.getSubgraph();
                SerializedJobActivityStatus.PipelineRecipe pr = new SerializedJobActivityStatus.PipelineRecipe();
                pr.activityId = subActivity.id();
                pr.recipeName = subRecipe.getRecipe().getName();
                pr.recipeType = subRecipe.getRecipe().getModel().type;
                if (subActivity.getSubgraph().getTargetsDatasets().size() > 0) {
                    FlowDataset firstTargetDataset = subActivity.getSubgraph().getTargetsDatasets().get(0);
                    pr.outputPartition = subRecipe.getTargetPartition(firstTargetDataset).id();
                }
                this.status.pipelineRecipes.add(pr);
            }
        }
        for (FlowComputable flowComputable : this.subgraph.getSources()) {
            SerializedJobActivityStatus.SerializedSourceDS source = new SerializedJobActivityStatus.SerializedSourceDS();
            source.type = flowComputable.getType();
            source.id = flowComputable.getFullId();
            for (Partition partition : this.subgraph.getSourcePartitions(flowComputable)) {
                SerializedJobActivityStatus.SourcePartitionStats partitionStats = new SerializedJobActivityStatus.SourcePartitionStats();
                partitionStats.id = partition.id();
                source.partitions.add(partitionStats);
            }
            this.status.sources.add(source);
        }
        for (FlowComputable flowComputable : this.subgraph.getTargets()) {
            SerializedJobActivityStatus.SerializedTargetDS targetST = new SerializedJobActivityStatus.SerializedTargetDS();
            targetST.type = flowComputable.getType();
            targetST.id = flowComputable.getFullId();
            if (flowComputable instanceof FlowSavedModel) {
                targetST.label = ((FlowSavedModel)flowComputable).getSavedModel().name;
            } else if (flowComputable instanceof FlowManagedFolder) {
                targetST.label = ((FlowManagedFolder)flowComputable).getManagedFolder().name;
            } else if (flowComputable instanceof FlowModelEvaluationStore) {
                targetST.label = ((FlowModelEvaluationStore)flowComputable).getModelEvaluationStore().name;
            }
            targetST.partition = new SerializedJobActivityStatus.TargetPartitionStats();
            targetST.partition.id = this.subgraph.getTargetPartition(flowComputable).id();
            this.status.targets.add(targetST);
        }
    }

    public JsonObject getActivitySpecificVariables() {
        if (this.subgraph instanceof RecipeRunnableSubgraph) {
            return ((RecipeRunnableSubgraph)this.subgraph).getRecipe().getModel().variables;
        }
        if (this.subgraph instanceof AbstractPipelineRunnableSubgraph) {
            AbstractPipelineRunnableSubgraph pipelineRunnableSubgraph = (AbstractPipelineRunnableSubgraph)this.subgraph;
            JobActivity root = pipelineRunnableSubgraph.getRoot();
            if (root.subgraph instanceof RecipeRunnableSubgraph) {
                return ((RecipeRunnableSubgraph)root.subgraph).getRecipe().getModel().variables;
            }
            logger.warn((Object)("Root of a pipeline subgraph is not a recipe but " + String.valueOf(root.subgraph)));
        }
        logger.warn((Object)("Did not know how to return variables for subgraph of class " + String.valueOf(this.subgraph.getClass())));
        return new JsonObject();
    }

    public SerializedJobActivity getSerialized() {
        SerializedJobActivity sja = new SerializedJobActivity();
        sja.activityId = this.id();
        if (this.subgraph != null) {
            for (FlowRecipe flowRecipe : this.subgraph.listRecipes()) {
                SerializedJobActivity.Recipe sjaRecipe = new SerializedJobActivity.Recipe();
                sjaRecipe.projectKey = flowRecipe.getProjectKey();
                sjaRecipe.name = flowRecipe.getName();
                sjaRecipe.type = flowRecipe.getModel().type;
                sja.recipes.add(sjaRecipe);
            }
            if (!sja.recipes.isEmpty()) {
                SerializedJobActivity.Recipe recipe = sja.recipes.get(0);
                sja.recipeProjectKey = recipe.projectKey;
                sja.recipeName = recipe.name;
                sja.recipeType = recipe.type;
            }
            for (FlowComputable flowComputable : this.subgraph.getSources()) {
                SerializedJobActivity.Source src = new SerializedJobActivity.Source();
                src.projectKey = DatasetLocUtils.resolveFull(flowComputable.getFullId()).getProjectKey();
                src.datasetName = DatasetLocUtils.resolveFull(flowComputable.getFullId()).getName();
                for (Partition partition : this.subgraph.getSourcePartitions(flowComputable)) {
                    src.partitionIds.add(partition.id());
                }
                sja.sources.add(src);
            }
            for (FlowComputable flowComputable : this.subgraph.getTargets()) {
                SerializedJobActivity.Target tgt = new SerializedJobActivity.Target();
                tgt.projectKey = DatasetLocUtils.resolveFull(flowComputable.getFullId()).getProjectKey();
                tgt.datasetName = DatasetLocUtils.resolveFull(flowComputable.getFullId()).getName();
                tgt.partitionId = this.subgraph.getTargetPartition(flowComputable).id();
                sja.targets.add(tgt);
            }
        }
        for (JobActivity jobActivity : this.dependencies) {
            sja.dependencies.add(jobActivity.id());
        }
        sja.requiredReason = this.requiredReason;
        return sja;
    }

    public SerializedJobActivityStatus getStatus() {
        assert (this.subgraph != null);
        this.initStatus();
        assert (this.status != null);
        this.status.runningTime = this.runningTimer.snapshot();
        this.status.waitingTime = this.waitingTimer.snapshot();
        this.status.preparingTime = this.preparingTimer.snapshot();
        this.status.state = this.state;
        this.status.endTime = this.endTime;
        this.status.startTime = this.startTime;
        if (this.endTime != 0L) {
            this.status.totalTime = this.endTime - this.startTime;
        }
        this.status.runningManagedThreads = this.aliveThreads;
        this.status.warnings = this.warnContext.getOutput();
        if (this.firstFailure != null) {
            this.status.firstFailure = this.firstFailure instanceof APIError.SerializedErrorException ? ((APIError.SerializedErrorException)this.firstFailure).error : new SerializedError(this.firstFailure, true);
        }
        this.status.runningThings = this.runningThings;
        return this.status;
    }

    public SerializedJobActivityStatus.SerializedSourceDS getSourceStatus(String computableId) {
        assert (this.status != null);
        for (SerializedJobActivityStatus.SerializedSourceDS ds : this.status.sources) {
            if (!ds.id.equals(computableId)) continue;
            return ds;
        }
        throw new Error("Source status not found for " + computableId);
    }

    public SerializedJobActivityStatus.SerializedTargetDS getTargetStatus(String computableId) {
        assert (this.status != null);
        for (SerializedJobActivityStatus.SerializedTargetDS ds : this.status.targets) {
            if (!ds.id.equals(computableId)) continue;
            return ds;
        }
        throw new Error("Target status not found for " + computableId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillSourceTotalSizes(DatasetsDAO dao) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        if (!DKUApp.getParams().getBoolParam("dku.jobs.fillSourceSizesInStatus", false)) {
            return;
        }
        logger.debug((Object)"Filling source sizes");
        assert (this.status != null);
        for (SerializedJobActivityStatus.SerializedSourceDS source : this.status.sources) {
            switch (source.type) {
                case DATASET: {
                    RWTransactionRef rwt = TransactionContext.retrieveWrite();
                    FlowDataset input = this.subgraph.getSourceDataset(source.id);
                    DatasetHandler dh = null;
                    try {
                        dh = DatasetHandlerFactory.build(rwt.getUser(), input.getMandatory(dao));
                    }
                    catch (Exception e) {
                        break;
                    }
                    try {
                        for (Partition partition : this.subgraph.getSourcePartitions(input)) {
                            SerializedJobActivityStatus.SourcePartitionStats partitionStats = null;
                            for (SerializedJobActivityStatus.SourcePartitionStats _ps : source.partitions) {
                                if (!_ps.id.equals(partition.id())) continue;
                                partitionStats = _ps;
                                break;
                            }
                            if (!(dh instanceof AbstractFSDatasetHandler)) continue;
                            if (partitionStats == null) {
                                throw ErrorContext.iae((String)("Source partition stats not found for:" + partition.id()));
                            }
                            try {
                                source.statsType = SerializedJobActivityStatus.SourceStatsType.FILES_WITHOUT_PROGRESS;
                                AbstractFSDatasetHandler fsdh = (AbstractFSDatasetHandler)dh;
                                FilePartitioner.ResolvedFilesFilterResult res = fsdh.getRequiredFiles(partition);
                                assert (partitionStats != null);
                                partitionStats.totalFiles = res.getAllPaths().size();
                                partitionStats.totalSize = res.getTotalSize();
                            }
                            catch (DataStoreIOException e) {
                                logger.warn((Object)("Failed to fill source size " + input.getFullId() + " / " + partition.id()), (Throwable)e);
                            }
                        }
                        break;
                    }
                    finally {
                        dh.close();
                    }
                }
                case SAVED_MODEL: {
                    break;
                }
                case MANAGED_FOLDER: {
                    break;
                }
                case MODEL_EVALUATION_STORE: {
                    break;
                }
                case RETRIEVABLE_KNOWLEDGE: {
                    break;
                }
                case STREAMING_ENDPOINT: {
                    throw new Error("shouldn't be building a streaming endpoint");
                }
            }
        }
        logger.debug((Object)"Done filling source sizes");
    }

    public void fillTargetWrittenSizes(DatasetsDAO dao) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        if (!DKUApp.getParams().getBoolParam("dku.jobs.fillTargetSizesInStatus", false)) {
            return;
        }
        for (SerializedJobActivityStatus.SerializedTargetDS targetDS : this.status.targets) {
            switch (targetDS.type) {
                case DATASET: {
                    FlowDataset output = this.subgraph.getTargetDataset(targetDS.id);
                    Dataset dataset = output.getMandatory(dao);
                    if (!DatasetHandlerFactory.getMeta(dataset).isReadable()) break;
                    RWTransactionRef rwt = TransactionContext.retrieveWrite();
                    try (DatasetHandler dh = DatasetHandlerFactory.build(rwt.getUser(), output.getMandatory(dao));){
                        if (!dh.getMeta().isFS()) break;
                        try {
                            AbstractFSDatasetHandler fsdh = (AbstractFSDatasetHandler)dh;
                            FilePartitioner.ResolvedFilesFilterResult res = fsdh.getRequiredFiles(this.subgraph.getTargetPartition(output));
                            targetDS.partition.writtenFiles = res.getAllPaths().size();
                            targetDS.partition.writtenBytes = res.getTotalSize();
                        }
                        catch (DataStoreIOException e) {
                            logger.warn((Object)("Failed to fill written size for " + output.getFullId()), (Throwable)e);
                        }
                        break;
                    }
                }
                case SAVED_MODEL: {
                    break;
                }
                case MANAGED_FOLDER: {
                    break;
                }
                case MODEL_EVALUATION_STORE: {
                    break;
                }
                case RETRIEVABLE_KNOWLEDGE: {
                    break;
                }
            }
        }
    }

    public void setAllSourcesCompletelyRead() {
        for (SerializedJobActivityStatus.SerializedSourceDS source : this.status.sources) {
            for (SerializedJobActivityStatus.SourcePartitionStats sps : source.partitions) {
                if (sps.totalRecords > 0L) {
                    sps.readRecords = sps.totalRecords;
                }
                if (sps.totalSize <= 0L) continue;
                sps.readBytes = sps.totalSize;
            }
        }
    }

    public void setTargetWrittenData(String targetDatasetFullName, int files, long bytes, long records) {
        for (SerializedJobActivityStatus.SerializedTargetDS targetST : this.status.targets) {
            if (!targetST.id.equals(targetDatasetFullName)) continue;
            targetST.partition.writtenFiles = files;
            targetST.partition.writtenBytes = bytes;
            targetST.partition.writtenRecords = records;
        }
    }

    public void stopTimers() {
        this.preparingTimer.stop();
        this.runningTimer.stop();
        this.waitingTimer.stop();
        this.runSummary.preparingTime = this.preparingTimer.snapshot();
        this.runSummary.waitingTime = this.waitingTimer.snapshot();
        this.runSummary.runningTime = this.runningTimer.snapshot();
    }

    public void setStatusMessage(String message) {
        this.status.messageCode = null;
        this.status.message = message;
    }

    public void setStatusMessage(SerializedJobActivityStatus.DetailedActivityState state, InfoMessage.MessageCode code, String message) {
        this.stopTimers();
        if (state != null) {
            switch (state) {
                case PREPARING: {
                    this.preparingTimer.start();
                    break;
                }
                case ACTIVE: {
                    this.runningTimer.start();
                    break;
                }
                case WAITING_RESOURCES: {
                    this.waitingTimer.start();
                }
            }
        }
        this.status.detailedState = state;
        this.status.messageCode = code != null ? code.getCode() : null;
        this.status.message = message;
    }

    public void setRequiredNonRecursiveForcedBuild() {
        this.requiredReason = new RequiredReason();
        this.requiredReason.type = RequiredReasonType.NON_RECURSIVE_FORCED_BUILD;
    }

    public void setRequiredRecursiveForcedBuild() {
        this.requiredReason = new RequiredReason();
        this.requiredReason.type = RequiredReasonType.FORCED_RECURSIVE_BUILD;
    }

    public void setRequiredForDeps() {
        this.requiredReason = new RequiredReason();
        this.requiredReason.type = RequiredReasonType.HAS_REQUIRED_DEPS;
    }

    public void setRequiredNeverExecuted() {
        this.requiredReason = new RequiredReason();
        this.requiredReason.type = RequiredReasonType.NEVER_EXECUTED;
    }

    public void setRequiredTargetSettingsChanged(String targetFullName, long previousRecordTime, String previousRecordJobId) {
        this.requiredReason = new RequiredReason();
        this.requiredReason.type = RequiredReasonType.TARGET_DATASET_SETTINGS_HAVE_CHANGED;
        this.requiredReason.targetFullName = targetFullName;
        this.requiredReason.previousRecordTime = previousRecordTime;
        this.requiredReason.previousRecordJobId = previousRecordJobId;
    }

    public void setRequiredRecipeChanged(long previousRecordTime, String previousRecordJobId) {
        this.requiredReason = new RequiredReason();
        this.requiredReason.type = RequiredReasonType.RECIPE_HAS_CHANGED;
        this.requiredReason.previousRecordTime = previousRecordTime;
        this.requiredReason.previousRecordJobId = previousRecordJobId;
    }

    public void setRequiredSourceChanged(String sourceFullName, String sourcePartition, long previousRecordTime, String previousRecordJobId) {
        this.requiredReason = new RequiredReason();
        this.requiredReason.type = RequiredReasonType.SOURCE_DATASET_HAS_CHANGED;
        this.requiredReason.sourceFullName = sourceFullName;
        this.requiredReason.sourcePartition = sourcePartition;
        this.requiredReason.previousRecordTime = previousRecordTime;
        this.requiredReason.previousRecordJobId = previousRecordJobId;
    }

    public void setRequiredSourceOutOfDate(long previousRecordTime, String previousRecordJobId) {
        this.requiredReason = new RequiredReason();
        this.requiredReason.type = RequiredReasonType.SOURCE_DATA_OUT_OF_DATE;
        this.requiredReason.previousRecordTime = previousRecordTime;
        this.requiredReason.previousRecordJobId = previousRecordJobId;
    }

    public static class ActivityRunSummary {
        public String activityId;
        public String state;
        public String failureCode;
        public String activityType;
        public String requiredReasonType;
        public String engineType;
        public String containerConfType;
        public Long totalTime;
        public Long preparingTime;
        public Long waitingTime;
        public Long runningTime;
    }

    public static class RecipeRunningThings {
        public List<ConnectionTasksService.SQLQueryRun> sql = new ArrayList<ConnectionTasksService.SQLQueryRun>();
        public List<ConnectionTasksService.HiveRun> hive = new ArrayList<ConnectionTasksService.HiveRun>();

        public synchronized ConnectionTasksService.HiveRun addHive() {
            ConnectionTasksService.HiveRun rrh = new ConnectionTasksService.HiveRun();
            this.hive.add(rrh);
            return rrh;
        }

        public synchronized ConnectionTasksService.SQLQueryRun addSQL(String connection) {
            ConnectionTasksService.SQLQueryRun rrh = new ConnectionTasksService.SQLQueryRun();
            rrh.startedOn = System.currentTimeMillis();
            rrh.connection = connection;
            this.sql.add(rrh);
            return rrh;
        }
    }

    private static class ActivityTimer {
        long accumulated;
        boolean counting;
        long countingStartTime;

        private ActivityTimer() {
        }

        synchronized void start() {
            this.counting = true;
            this.countingStartTime = System.currentTimeMillis();
        }

        synchronized void stop() {
            if (this.counting) {
                this.counting = false;
                this.accumulated += System.currentTimeMillis() - this.countingStartTime;
                this.countingStartTime = 0L;
            }
        }

        synchronized long snapshot() {
            if (this.counting) {
                return this.accumulated + System.currentTimeMillis() - this.countingStartTime;
            }
            return this.accumulated;
        }
    }

    public static class RequiredReason {
        RequiredReasonType type;
        String targetFullName;
        String sourceFullName;
        String sourcePartition;
        long previousRecordTime;
        String previousRecordJobId;
    }

    public static enum RequiredReasonType {
        HAS_REQUIRED_DEPS,
        FORCED_RECURSIVE_BUILD,
        NON_RECURSIVE_FORCED_BUILD,
        NEVER_EXECUTED,
        TARGET_DATASET_SETTINGS_HAVE_CHANGED,
        RECIPE_HAS_CHANGED,
        SOURCE_DATASET_HAS_CHANGED,
        SOURCE_DATA_OUT_OF_DATE;

    }
}

