/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.Zone;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dao.ZonesDAO;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.dataflow.ComputeImpactedInputPartitions;
import com.dataiku.dip.dataflow.ComputeImpactedOutputPartitions;
import com.dataiku.dip.dataflow.ComputeRequiredRefreshMissingOnlyBuild;
import com.dataiku.dip.dataflow.ComputeRequiredRefreshRecursiveBuild;
import com.dataiku.dip.dataflow.ComputeRequiredRefreshRecursiveForcedBuild;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ImplicitDependencyRunnableSubgraph;
import com.dataiku.dip.dataflow.Job;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeHashComputer;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.ReverseJobUnprunedTreeComputer;
import com.dataiku.dip.dataflow.commands.PartitionRefreshCommand;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowImplicitRecipe;
import com.dataiku.dip.dataflow.graph.FlowLabelingTask;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.FlowModelEvaluationStore;
import com.dataiku.dip.dataflow.graph.FlowPartitionable;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.utils.JobPrinter;
import com.dataiku.dip.dataflow.jobrunner.SerializedJob;
import com.dataiku.dip.dataflow.kernel.master.BuildUtils;
import com.dataiku.dip.dataflow.pdep.DimensionDependencySpec;
import com.dataiku.dip.dataflow.pipeline.BuildPipelines;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.mec.ModelEvaluationStoreHandler;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class JobComputer {
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DatasetsDAO dao;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private ZonesDAO zonesDAO;
    private SerializedJob beforePruning;
    private JobActivity topLevelActivity;
    private final JobDef def;
    private final FlowGraph graph;
    private final Set<PartitionRefreshCommand> alreadyAddedToMT = new HashSet<PartitionRefreshCommand>();
    private final Map<String, JobActivity> alreadyBuiltActivities = new HashMap<String, JobActivity>();
    private final Map<String, List<Partition>> datasetPartitions = new HashMap<String, List<Partition>>();
    private final Map<String, Map<String, Partition>> partitionIdsPerRecipe = new HashMap<String, Map<String, Partition>>();
    private final GeneralSettingsDAO.GeneralSettings generalSettings;
    private final AuthCtx authCtx;
    private String currentlyBoundingFlowZone;
    private Map<AnyLoc, Zone> zonesMap = new HashMap<AnyLoc, Zone>();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.compute");

    public JobComputer(AuthCtx authCtx, JobDef def, FlowGraph graph) {
        this.authCtx = authCtx;
        SpringUtils.getInstance().autowire((Object)this);
        this.graph = graph;
        this.def = def;
        this.generalSettings = ApplicationConfigurator.getGeneralSettings();
    }

    public Job compute() throws Exception {
        if (this.def.type == JobDef.JobType.REVERSE_FORCED_BUILD) {
            ReverseJobUnprunedTreeComputer computer = new ReverseJobUnprunedTreeComputer(this.graph);
            return computer.compute(this.def);
        }
        if (this.def.isFindOutputMode) {
            this.checkBuildabilityForFindOutputs(this.def);
        }
        this.topLevelActivity = this.computeUnprunedJobActivity();
        logger.info((Object)("Before prune, job looks like:\n" + JobPrinter.print(new Job(this.def, this.topLevelActivity), 0)));
        this.cleanupImplicitActivities(this.topLevelActivity);
        logger.info((Object)("After cleanup of implicit recipes, job looks like:\n" + JobPrinter.print(new Job(this.def, this.topLevelActivity), 0)));
        this.beforePruning = new SerializedJob(this.topLevelActivity);
        logger.info((Object)("Job project: " + this.def.projectKey));
        SerializedProject sp = this.projectsDAO.getOrNullUnsafe(this.def.projectKey);
        assert (sp != null);
        if (sp.settings.flowBuildSettings.mergeSparkPipelines) {
            this.buildTopLevelActivity(sp, RecipePipelineHelper.PipelineType.SPARK);
        }
        if (sp.settings.flowBuildSettings.mergeSqlPipelines) {
            this.buildTopLevelActivity(sp, RecipePipelineHelper.PipelineType.SQL);
        }
        logger.info((Object)"Doing job pruning according to settings");
        this.prune();
        logger.info((Object)"After prune, job looks like that");
        logger.info((Object)JobPrinter.print(new Job(this.def, this.topLevelActivity), 0));
        logger.info((Object)"Done building final job graph");
        return new Job(this.def, this.topLevelActivity);
    }

    private void buildTopLevelActivity(SerializedProject sp, RecipePipelineHelper.PipelineType pipelineType) throws Exception {
        String type;
        boolean pruneBeforePipelines = switch (pipelineType) {
            case RecipePipelineHelper.PipelineType.SPARK -> {
                type = "Spark";
                yield sp.settings.flowBuildSettings.pruneBeforeSparkPipelines;
            }
            case RecipePipelineHelper.PipelineType.SQL -> {
                type = "SQL";
                yield sp.settings.flowBuildSettings.pruneBeforeSqlPipelines;
            }
            default -> throw new IllegalStateException(String.format("%s is not supported. Only Spark and Sql pipelines are.", new Object[]{pipelineType}));
        };
        logger.infoV("Evaluating %s pipeline merging", new Object[]{type});
        if (pruneBeforePipelines) {
            logger.info((Object)"Doing pre-merge prune");
            this.prune();
            logger.info((Object)"After pre-merge prune, job looks like that");
            logger.info((Object)JobPrinter.print(new Job(this.def, this.topLevelActivity), 0));
        }
        this.topLevelActivity = new BuildPipelines(this.authCtx, pipelineType).visit(this.topLevelActivity);
        logger.infoV("After %s pipelines, job looks like that", new Object[]{type});
        logger.info((Object)JobPrinter.print(new Job(this.def, this.topLevelActivity), 0));
    }

    public SerializedJob getBeforePruning() {
        return this.beforePruning;
    }

    private FlowRecipe getRecipeForTarget(String targetId) {
        for (FlowRecipe _r : this.graph.recipes) {
            for (FlowComputable target : _r.getTargets()) {
                if (!target.getFullId().equals(targetId)) continue;
                return _r;
            }
        }
        return null;
    }

    private FlowLabelingTask getLabelingTasksForTarget(String targetId) {
        for (FlowLabelingTask _lt : this.graph.labelingTasks) {
            for (FlowComputable target : _lt.getTargets()) {
                if (!target.getFullId().equals(targetId)) continue;
                return _lt;
            }
        }
        return null;
    }

    private List<FlowImplicitRecipe> getImplicitRecipesForTarget(String targetId) {
        return this.graph.implicitRecipes.stream().filter(implicitRecipe -> implicitRecipe.getTargets().stream().anyMatch(t -> t.getFullId().equals(targetId))).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void handleActivityRec(JobActivity activity, PartitionRefreshCommand currentCommand, String originalProjectKey) throws Exception {
        block47: {
            block44: {
                this.alreadyAddedToMT.add(currentCommand);
                if (this.def.stopAtComputableRefs != null && this.def.stopAtComputableRefs.contains(currentCommandRef = AnyLoc.resolveFull(currentCommand.target.getFullId()).getSmartName(this.def.projectKey))) {
                    JobComputer.logger.infoV("%s is a stop-at computable, stop recursion", new Object[]{currentCommandRef});
                    return;
                }
                newActivity = null;
                recipe = this.getRecipeForTarget(currentCommand.target.getFullId());
                implicitRecipes = this.getImplicitRecipesForTarget(currentCommand.target.getFullId());
                labelingTask = this.getLabelingTasksForTarget(currentCommand.target.getFullId());
                if (recipe == null && implicitRecipes.size() == 0 && labelingTask == null) {
                    JobComputer.logger.info((Object)"End of tree reached");
                    return;
                }
                if (labelingTask != null) {
                    JobComputer.logger.info((Object)"Labeling task reached, stop fetching dependencies");
                    return;
                }
                if (implicitRecipes.size() <= 0) break block44;
                for (FlowImplicitRecipe implicitRecipe : implicitRecipes) {
                    JobComputer.logger.infoV("Refreshing %s/%s with implicit recipe %s", new Object[]{currentCommand.target.getFullId(), currentCommand.partition.id(), implicitRecipe.getName()});
                    realSubgraph = new ImplicitDependencyRunnableSubgraph(implicitRecipe);
                    newActivity = new JobActivity(realSubgraph);
                    ErrorContext.pushWithNDC((String)("activity " + newActivity.getSubgraph().getName() + "_" + String.valueOf(currentCommand.partition)));
                    try {
                        block46: {
                            block45: {
                                new ComputeImpactedOutputPartitions(this.dao, currentCommand, newActivity.getSubgraph()).compute();
                                JobComputer.logger.info((Object)("computed output partitions: " + String.valueOf(newActivity.getSubgraph().getTargetPartitions())));
                                sourcePartitioned = false;
                                sourceObj = null;
                                targetObj = null;
                                if (implicitRecipe.getPredecessor() instanceof FlowPartitionable) {
                                    sourceObj = ((FlowPartitionable)implicitRecipe.getPredecessor()).getPartitioned(this.dao);
                                    sourcePartitioned = sourceObj.getPartitioningSchema().isPartitioned();
                                }
                                targetPartitioned = false;
                                if (implicitRecipe.getSuccessor() instanceof FlowPartitionable) {
                                    targetObj = ((FlowPartitionable)implicitRecipe.getSuccessor()).getPartitioned(this.dao);
                                    targetPartitioned = targetObj.getPartitioningSchema().isPartitioned();
                                }
                                outputPartitions = Lists.newArrayList();
                                if (!sourcePartitioned) break block45;
                                if (!JobComputer.$assertionsDisabled && sourceObj == null) {
                                    throw new AssertionError();
                                }
                                allDepRecipeModel = new SerializedRecipe();
                                allDepRecipe = new FlowRecipe(allDepRecipeModel);
                                for (String dimensionName : sourceObj.getPartitioningSchema().getDimensionNames()) {
                                    dds = new DimensionDependencySpec();
                                    dds.inputDataset = sourceObj.getFullName();
                                    dds.inputDimension = dimensionName;
                                    dds.params = Maps.newHashMap();
                                    if (!targetPartitioned) ** GOTO lbl56
                                    if (!JobComputer.$assertionsDisabled && targetObj == null) {
                                        throw new AssertionError();
                                    }
                                    if (targetObj.getPartitioningSchema().getDimensionNamesSet().contains(dimensionName)) {
                                        dds.outputDataset = targetObj.getFullName();
                                        dds.outputDimension = dimensionName;
                                        dds.function = "equals";
                                    } else {
                                        throw ErrorContext.iaef((String)"Cannot match dimension '%s' of %s with any dimension of input %s", (Object)dimensionName, (Object[])new Object[]{targetObj.getFullName(), sourceObj.getFullName()});
lbl56:
                                        // 1 sources

                                        dds.function = "all_available";
                                    }
                                    allDepRecipe.addPartitionDeps(dds);
                                }
                                allDepRecipe.addPredecessor(implicitRecipe.getPredecessor(), "main");
                                allDepRecipe.addSuccessor(implicitRecipe.getSuccessor(), "main");
                                allDepSubgraph = new RecipeRunnableSubgraph(allDepRecipe);
                                allDepSubgraph.setTargetPartitions(realSubgraph.getTargetPartitions());
                                ci = new ComputeImpactedInputPartitions(TransactionContext.retrieveWrite().getUser(), allDepSubgraph, this.datasetPartitions);
                                SpringUtils.getInstance().autowire((Object)ci);
                                ci.compute();
                                JobComputer.logger.info((Object)("computed input partitions : " + String.valueOf(allDepSubgraph.getSourcePartitions())));
                                parts = allDepSubgraph.getSourcePartitions().get(sourceObj.getFullName());
                                if (parts != null) {
                                    outputPartitions.addAll(parts);
                                }
                                realSubgraph.setSourcePartitions(allDepSubgraph.getSourcePartitions());
                                break block46;
                            }
                            outputPartitions.add(Partition.newNP());
                        }
                        requiredPartitions = Maps.newHashMap();
                        requiredPartitions.put(implicitRecipe.getPredecessor().getFullId(), outputPartitions);
                        newActivity.getSubgraph().getSourcePartitions().putAll(requiredPartitions);
                    }
                    finally {
                        ErrorContext.popWithNDC();
                    }
                }
                break block47;
            }
            if (!JobComputer.$assertionsDisabled && recipe == null) {
                throw new AssertionError();
            }
            JobComputer.logger.infoV("Refreshing %s/%s with recipe %s", new Object[]{currentCommand.target.getFullId(), currentCommand.partition.id(), recipe.getName()});
            if (RecipeRegistry.getMeta(recipe.getModel()).isContinuous()) {
                return;
            }
            if (this.def.stopAtFlowZoneBoundary) {
                loc = new AnyLoc(recipe.getProjectKey(), recipe.getName());
                zone = this.zonesMap.get(loc);
                recipeZone = null;
                recipeZone = zone != null ? zone.getId() : Zone.DEFAULT_ZONE.getId();
                if (!JobComputer.$assertionsDisabled && recipeZone == null) {
                    throw new AssertionError();
                }
                JobComputer.logger.infoV("Single-zone mode enabled, recipe is in zone=%s, bounding=%s", new Object[]{recipeZone, this.currentlyBoundingFlowZone});
                if (!recipeZone.equals(this.currentlyBoundingFlowZone)) {
                    JobComputer.logger.infoV("Stopping recursion, going out of flow zone " + this.currentlyBoundingFlowZone, new Object[0]);
                    return;
                }
            }
            realSubgraph = new RecipeRunnableSubgraph(recipe);
            newActivity = new JobActivity(realSubgraph);
            ErrorContext.pushWithNDC((String)("activity " + newActivity.getSubgraph().getName() + "_" + String.valueOf(currentCommand.partition)));
            try {
                recipeId = recipe.getFullId();
                currentPartitionId = currentCommand.partition.id();
                if (this.partitionIdsPerRecipe.containsKey(recipeId)) {
                    recipePartitionIds = this.partitionIdsPerRecipe.get(recipeId);
                    if ("NP".equals(currentPartitionId)) {
                        if (recipePartitionIds.size() > 1) {
                            throw ErrorContext.iaef((String)"Cannot guarantee non-concurrency in building %s", (Object)currentCommand.target.getFullId(), (Object[])new Object[0]);
                        }
                        JobComputer.logger.info((Object)"This activity is an alias! (because we are building a NP dataset after a P one)");
                        return;
                    }
                    recipePartitionIds.put(currentPartitionId, currentCommand.partition);
                } else if (!"NP".equals(currentPartitionId)) {
                    recipePartitionIds = Maps.newHashMap();
                    recipePartitionIds.put(currentPartitionId, currentCommand.partition);
                    this.partitionIdsPerRecipe.put(recipeId, recipePartitionIds);
                }
                new ComputeImpactedOutputPartitions(this.dao, currentCommand, newActivity.getSubgraph()).compute();
                JobComputer.logger.info((Object)("computed output partitions: " + String.valueOf(newActivity.getSubgraph().getTargetPartitions())));
                if (recipe.isGenerator() || recipe.getPredecessors().size() <= 0) ** GOTO lbl137
                ci = new ComputeImpactedInputPartitions(TransactionContext.retrieveWrite().getUser(), realSubgraph, this.datasetPartitions);
                SpringUtils.getInstance().autowire((Object)ci);
                ci.compute();
                JobComputer.logger.info((Object)("computed input partitions : " + String.valueOf(newActivity.getSubgraph().getSourcePartitions())));
            }
            finally {
                ErrorContext.popWithNDC();
            }
        }
        if (this.alreadyBuiltActivities.containsKey(sgId = newActivity.id())) {
            JobComputer.logger.info((Object)"This activity is an alias!");
            activity.dependencies.add(this.alreadyBuiltActivities.get(sgId));
            return;
        }
        this.alreadyBuiltActivities.put(newActivity.id(), newActivity);
        switch (1.$SwitchMap$com$dataiku$dip$coremodel$JobDef$JobType[this.def.type.ordinal()]) {
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                newPartitionedCommands = Lists.newArrayList();
                newNonPartitionedCommands = Lists.newArrayList();
                for (FlowComputable source : newActivity.getSubgraph().getSources()) {
                    sourceLoc = AnyLoc.resolveFull(source.getFullId());
                    if (!sourceLoc.getProjectKey().equals(originalProjectKey)) {
                        cp = source.getCrossProjectBehavior();
                        if (cp == SerializedDataset.CrossProjectBuildBehaviour.DEFAULT) {
                            v0 = cp = this.generalSettings.globalCrossProjectBuildBehaviour == GeneralSettingsDAO.GlobalCrossProjectBuildBehaviour.STOP_AT_BOUNDARIES ? SerializedDataset.CrossProjectBuildBehaviour.STOP : SerializedDataset.CrossProjectBuildBehaviour.TRAVERSE;
                        }
                        if (!JobComputer.$assertionsDisabled && cp == SerializedDataset.CrossProjectBuildBehaviour.DEFAULT) {
                            throw new AssertionError();
                        }
                        if (cp == SerializedDataset.CrossProjectBuildBehaviour.STOP) {
                            JobComputer.logger.info((Object)("Stopping recursion at project boundary: " + source.getFullId()));
                            continue;
                        }
                    }
                    if (newActivity.getSubgraph().getSourcePartitions().containsKey(source.getFullId())) {
                        for (Partition partition : newActivity.getSubgraph().getSourcePartitions().get(source.getFullId())) {
                            newCommand = new PartitionRefreshCommand(source, partition);
                            if (StringUtils.isBlank((String)partition.id()) || "NP".equals(partition.id())) {
                                newNonPartitionedCommands.add(newCommand);
                                continue;
                            }
                            newPartitionedCommands.add(newCommand);
                        }
                        continue;
                    }
                    JobComputer.logger.info((Object)"End of partitions dependencies");
                }
                for (PartitionRefreshCommand newCommand : newPartitionedCommands) {
                    this.handleActivityRec(newActivity, newCommand, originalProjectKey);
                }
                for (PartitionRefreshCommand newCommand : newNonPartitionedCommands) {
                    this.handleActivityRec(newActivity, newCommand, originalProjectKey);
                }
                break;
            }
        }
        activity.dependencies.add(newActivity);
    }

    private void indexZones() throws IOException {
        List zones = this.zonesDAO.listUnsafe(this.def.projectKey);
        for (Zone zone : zones) {
            for (SmartObjectRef objectRef : zone.getItems()) {
                this.zonesMap.put(AnyLoc.resolveFull(objectRef.getFullId(this.def.projectKey)), zone);
            }
        }
    }

    private void handleOneOutput(JobDef.JobOutput o) throws Exception {
        FlowComputable computableToRefresh = null;
        ArrayList<Partition> partitionsToRefresh = new ArrayList<Partition>();
        o.type = BuildUtils.detectOutputType(o);
        logger.info((Object)("Job output type: " + String.valueOf((Object)o.type)));
        switch (o.type) {
            case DATASET: {
                computableToRefresh = this.getPartitionsToRefreshForDataset(o, partitionsToRefresh);
                break;
            }
            case SAVED_MODEL: {
                computableToRefresh = this.getPartitionsToRefreshForSavedModel(o, partitionsToRefresh);
                break;
            }
            case MANAGED_FOLDER: {
                computableToRefresh = this.getPartitionsToRefreshForMf(o, partitionsToRefresh);
                break;
            }
            case MODEL_EVALUATION_STORE: {
                computableToRefresh = this.getPartitionsToRefreshForModelEvaluationStore(o, partitionsToRefresh);
                break;
            }
            case RETRIEVABLE_KNOWLEDGE: {
                computableToRefresh = this.getPartitionsToRefreshForRetrievableKnowledge(o, partitionsToRefresh);
                break;
            }
            case STREAMING_ENDPOINT: {
                computableToRefresh = this.getPartitionsToRefreshForStreamingEndpoint(o, partitionsToRefresh);
            }
        }
        if (computableToRefresh == null) {
            throw ErrorContext.iaef((String)"Target to refresh '%s' not found as target of one of the loaded recipes", (Object)o.targetDataset, (Object[])new Object[0]);
        }
        if (this.def.stopAtFlowZoneBoundary) {
            this.indexZones();
            AnyLoc loc = AnyLoc.resolveFull(computableToRefresh.getFullId());
            Zone zone = this.zonesMap.get(loc);
            this.currentlyBoundingFlowZone = zone != null ? zone.getId() : Zone.DEFAULT_ZONE.getId();
            logger.info((Object)("Single-zone mode enabled, computed bounding zone=" + this.currentlyBoundingFlowZone));
        }
        for (Partition partitionToRefresh : partitionsToRefresh) {
            logger.infoV("computing job from target %s partition %s", new Object[]{computableToRefresh.getFullId(), partitionToRefresh.id()});
            if (computableToRefresh.getRebuildBehavior() == SerializedDataset.RebuildBehavior.WRITE_PROTECT) {
                RWTransactionRef rwt = TransactionContext.retrieveWrite();
                switch (computableToRefresh.getType()) {
                    case DATASET: {
                        this.checkPartitionToRefreshForDataset(computableToRefresh, partitionToRefresh, rwt);
                        break;
                    }
                    case MANAGED_FOLDER: {
                        this.checkPartitionToRefreshForMf(computableToRefresh, partitionToRefresh, rwt);
                        break;
                    }
                    case MODEL_EVALUATION_STORE: {
                        this.checkPartitionToRefreshForModelEvaluationStore(computableToRefresh, partitionToRefresh, rwt);
                        break;
                    }
                    case SAVED_MODEL: {
                        break;
                    }
                    case STREAMING_ENDPOINT: {
                        break;
                    }
                }
            }
            this.handleActivityRec(this.topLevelActivity, new PartitionRefreshCommand(computableToRefresh, partitionToRefresh), o.targetDatasetProjectKey);
            for (JobActivity ja : this.topLevelActivity.dependencies) {
                ja.topLevelActivity = true;
            }
        }
    }

    private FlowComputable getPartitionsToRefreshForStreamingEndpoint(JobDef.JobOutput o, List<Partition> partitionsToRefresh) throws IOException {
        StreamingEndpoint sm = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatoryUnsafe(o.targetDatasetProjectKey, o.targetDataset);
        FlowComputable computableToRefresh = this.graph.getComputable(sm.projectKey + "." + sm.id);
        partitionsToRefresh.add(Partition.newNP());
        return computableToRefresh;
    }

    private FlowComputable getPartitionsToRefreshForSavedModel(JobDef.JobOutput o, List<Partition> partitionsToRefresh) throws IOException {
        SavedModel sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(o.targetDatasetProjectKey, o.targetDataset);
        FlowComputable computableToRefresh = this.graph.getComputable(sm.projectKey + "." + sm.id);
        if (sm.isPartitioned()) {
            if (o.targetPartition != null) {
                partitionsToRefresh.addAll(PartitionFactory.fromPartitionSpec(sm.partitioning, o.targetPartition));
            } else {
                FlowRecipe recipe = this.getRecipeForTarget(computableToRefresh.getFullId());
                logger.info((Object)("Found recipe " + (recipe == null ? "<Not found>" : JSON.log((Object)recipe.getModel()))));
                if (recipe == null || !recipe.getModel().redispatchPartitioning) {
                    throw ErrorContext.iaef((String)"Missing partition to refresh id for %s", (Object)computableToRefresh.getFullId(), (Object[])new Object[0]);
                }
                partitionsToRefresh.add(Partition.newALL((PartitioningScheme)sm.partitioning));
            }
        } else {
            partitionsToRefresh.add(Partition.newNP());
        }
        return computableToRefresh;
    }

    private FlowComputable getPartitionsToRefreshForMf(JobDef.JobOutput o, List<Partition> partitionsToRefresh) throws IOException {
        ManagedFolder odb = (ManagedFolder)this.managedFolderDAO.getMandatory(o.targetDatasetProjectKey, o.targetDataset);
        FlowComputable computableToRefresh = this.graph.getComputable(odb.projectKey + "." + odb.id);
        if (o.targetPartition == null && odb.getPartitioningSchema().isPartitioned()) {
            FlowRecipe recipe = this.getRecipeForTarget(computableToRefresh.getFullId());
            logger.info((Object)("Found recipe " + (recipe == null ? "<Not found>" : JSON.log((Object)recipe.getModel()))));
            if (recipe == null || !recipe.getModel().redispatchPartitioning) {
                throw ErrorContext.iaef((String)"Missing partition to refresh id for %s", (Object)computableToRefresh.getFullId(), (Object[])new Object[0]);
            }
            partitionsToRefresh.add(Partition.newALL((PartitioningScheme)odb.getPartitioningSchema()));
        } else {
            partitionsToRefresh.addAll(PartitionFactory.fromPartitionSpec(odb.getPartitioningSchema(), o.targetPartition));
            for (Partition partitionToRefresh : partitionsToRefresh) {
                if (partitionToRefresh.getDimensionValues().keySet().equals(odb.getPartitioningSchema().getDimensionNamesSet())) continue;
                throw ErrorContext.iae((String)"Invalid job target partition, wrong dimensions");
            }
        }
        return computableToRefresh;
    }

    private FlowComputable getPartitionsToRefreshForModelEvaluationStore(JobDef.JobOutput o, List<Partition> partitionsToRefresh) throws IOException {
        ModelEvaluationStore mes = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getMandatory(o.targetDatasetProjectKey, o.targetDataset);
        FlowComputable computableToRefresh = this.graph.getComputable(mes.projectKey + "." + mes.id);
        if (o.targetPartition == null && mes.getPartitioningSchema().isPartitioned()) {
            FlowRecipe recipe = this.getRecipeForTarget(computableToRefresh.getFullId());
            logger.info((Object)("Found recipe " + (recipe == null ? "<Not found>" : JSON.log((Object)recipe.getModel()))));
            if (recipe == null || !recipe.getModel().redispatchPartitioning) {
                throw ErrorContext.iaef((String)"Missing partition to refresh id for %s", (Object)computableToRefresh.getFullId(), (Object[])new Object[0]);
            }
            partitionsToRefresh.add(Partition.newALL((PartitioningScheme)mes.getPartitioningSchema()));
        } else {
            partitionsToRefresh.addAll(PartitionFactory.fromPartitionSpec(mes.getPartitioningSchema(), o.targetPartition));
            for (Partition partitionToRefresh : partitionsToRefresh) {
                if (partitionToRefresh.getDimensionValues().keySet().equals(mes.getPartitioningSchema().getDimensionNamesSet())) continue;
                throw ErrorContext.iae((String)"Invalid job target partition, wrong dimensions");
            }
        }
        return computableToRefresh;
    }

    private FlowComputable getPartitionsToRefreshForRetrievableKnowledge(JobDef.JobOutput o, List<Partition> partitionsToRefresh) throws IOException {
        RetrievableKnowledge rk = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getMandatory(o.targetDatasetProjectKey, o.targetDataset);
        FlowComputable computableToRefresh = this.graph.getComputable(rk.projectKey + "." + rk.id);
        partitionsToRefresh.add(Partition.newNP());
        return computableToRefresh;
    }

    private FlowComputable getPartitionsToRefreshForDataset(JobDef.JobOutput o, List<Partition> partitionsToRefresh) throws IOException {
        Dataset dataset = this.datasetAccessService.getMandatory(o.targetDatasetProjectKey, o.targetDataset);
        FlowComputable computableToRefresh = this.graph.datasets.get(dataset.getFullName());
        if (StringUtils.isBlank((String)o.targetPartition) && dataset.getPartitioningSchema().isPartitioned()) {
            FlowRecipe recipe = this.getRecipeForTarget(computableToRefresh.getFullId());
            logger.info((Object)("Found recipe " + (recipe == null ? "<Not found>" : JSON.log((Object)recipe.getModel()))));
            if (recipe == null || !recipe.getModel().redispatchPartitioning) {
                throw ErrorContext.iaef((String)"Missing partition to refresh id for %s", (Object)computableToRefresh.getFullId(), (Object[])new Object[0]);
            }
            partitionsToRefresh.add(Partition.newALL((PartitioningScheme)dataset.getPartitioningSchema()));
        } else {
            partitionsToRefresh.addAll(PartitionFactory.fromPartitionSpec(dataset.getPartitioningSchema(), o.targetPartition));
            for (Partition partitionToRefresh : partitionsToRefresh) {
                if (partitionToRefresh.getDimensionValues().keySet().equals(dataset.getPartitioningSchema().getDimensionNamesSet())) continue;
                throw ErrorContext.iae((String)"Invalid job target partition, wrong dimensions");
            }
        }
        return computableToRefresh;
    }

    private void checkPartitionToRefreshForDataset(FlowComputable computableToRefresh, Partition partitionToRefresh, RWTransactionRef rwt) throws Exception {
        Dataset ds = ((FlowDataset)computableToRefresh).getMandatory(this.dao);
        try (DatasetHandler datasetHandler = DatasetHandlerFactory.build(rwt.getUser(), ds);){
            if (datasetHandler.partitionExists(partitionToRefresh)) {
                PartitioningScheme scheme = partitionToRefresh.getScheme();
                throw ErrorContext.iaef((String)"Target dataset '%s' is write-protected, cannot %s", (Object)ds.getFullName(), (Object[])new Object[]{scheme != null && scheme.isPartitioned() ? "rebuild" : "overwrite partition " + partitionToRefresh.id()});
            }
        }
    }

    private void checkPartitionToRefreshForMf(FlowComputable computableToRefresh, Partition partitionToRefresh, RWTransactionRef rwt) throws IOException, CodedException, DKUSecurityException {
        ManagedFolder mf = ((FlowManagedFolder)computableToRefresh).getManagedFolder();
        try (ManagedFolderHandler managedFolderHandler = (ManagedFolderHandler)mf.buildHandler(rwt.getUser());){
            if (managedFolderHandler.partitionExists(partitionToRefresh)) {
                PartitioningScheme scheme = partitionToRefresh.getScheme();
                throw ErrorContext.iaef((String)"Target folder '%s' is write-protected, cannot %s", (Object)mf.getFullName(), (Object[])new Object[]{scheme != null && scheme.isPartitioned() ? "rebuild" : "overwrite partition " + partitionToRefresh.id()});
            }
        }
    }

    private void checkPartitionToRefreshForModelEvaluationStore(FlowComputable computableToRefresh, Partition partitionToRefresh, RWTransactionRef rwt) throws Exception {
        ModelEvaluationStore mf = ((FlowModelEvaluationStore)computableToRefresh).getModelEvaluationStore();
        try (ModelEvaluationStoreHandler modelEvaluationStoreHandler = (ModelEvaluationStoreHandler)mf.buildHandler(rwt.getUser());){
            if (modelEvaluationStoreHandler.partitionExists(partitionToRefresh)) {
                PartitioningScheme scheme = partitionToRefresh.getScheme();
                throw ErrorContext.iaef((String)"Target evaluation store '%s' is write-protected, cannot %s", (Object)mf.getFullName(), (Object[])new Object[]{scheme != null && scheme.isPartitioned() ? "rebuild" : "overwrite partition " + partitionToRefresh.id()});
            }
        }
    }

    private JobActivity computeUnprunedJobActivity() throws Exception {
        this.topLevelActivity = new JobActivity(null);
        ArrayList partitionedOutputs = Lists.newArrayList();
        ArrayList nonPartitionedOutputs = Lists.newArrayList();
        for (JobDef.JobOutput o : this.def.outputs) {
            if (StringUtils.isBlank((String)o.targetPartition) || "NP".equals(o.targetPartition)) {
                nonPartitionedOutputs.add(o);
                continue;
            }
            partitionedOutputs.add(o);
        }
        for (JobDef.JobOutput o : partitionedOutputs) {
            this.handleOneOutput(o);
        }
        for (JobDef.JobOutput o : nonPartitionedOutputs) {
            this.handleOneOutput(o);
        }
        return this.topLevelActivity;
    }

    private void prune() throws Exception {
        ComputableHashComputer dtComputer = new ComputableHashComputer(TransactionContext.retrieveWrite().getUser());
        dtComputer.allowUseOfSession();
        RecipeHashComputer ttComputer = new RecipeHashComputer(this.recipesDAO, this.dao);
        switch (this.def.type) {
            case NON_RECURSIVE_FORCED_BUILD: {
                logger.info((Object)("not pruning activity, job type is " + String.valueOf((Object)this.def.type)));
                for (JobActivity ja : this.topLevelActivity.dependencies) {
                    ja.setRequiredNonRecursiveForcedBuild();
                }
                break;
            }
            case RECURSIVE_BUILD: {
                logger.info((Object)"RECURSIVE_BUILD: pruning non-required activities");
                ComputeRequiredRefreshRecursiveBuild crros = new ComputeRequiredRefreshRecursiveBuild(dtComputer, ttComputer, this.def, this.topLevelActivity);
                SpringUtils.getInstance().autowire((Object)crros);
                crros.prune();
                break;
            }
            case RECURSIVE_FORCED_BUILD: {
                logger.info((Object)"RECURSIVE_FORCED_BUILD: pruning non-required activities");
                ComputeRequiredRefreshRecursiveForcedBuild crros = new ComputeRequiredRefreshRecursiveForcedBuild(dtComputer, ttComputer, this.def, this.topLevelActivity);
                SpringUtils.getInstance().autowire((Object)crros);
                crros.prune();
                break;
            }
            case RECURSIVE_MISSING_ONLY_BUILD: {
                logger.info((Object)"MISSING_ONLY_BUILD: pruning non-required activities");
                ComputeRequiredRefreshMissingOnlyBuild crros = new ComputeRequiredRefreshMissingOnlyBuild(dtComputer, ttComputer, this.def, this.topLevelActivity);
                SpringUtils.getInstance().autowire((Object)crros);
                crros.prune();
                break;
            }
        }
    }

    private void cleanupImplicitActivities(JobActivity activity) {
        this.cleanupImplicitActivities(activity, new HashSet<String>());
    }

    private void cleanupImplicitActivities(JobActivity activity, Set<String> alreadyVisited) {
        if (alreadyVisited.contains(activity.id())) {
            return;
        }
        alreadyVisited.add(activity.id());
        ArrayList activities = Lists.newArrayList();
        for (JobActivity subActivity : activity.dependencies) {
            this.cleanupImplicitActivities(subActivity, alreadyVisited);
            if (subActivity.getSubgraph() instanceof ImplicitDependencyRunnableSubgraph) {
                activities.addAll(subActivity.dependencies);
                continue;
            }
            activities.add(subActivity);
        }
        activity.dependencies.clear();
        activity.dependencies.addAll(activities);
    }

    private void checkBuildabilityForFindOutputs(JobDef def) throws IOException {
        FlowGraphService fghs = (FlowGraphService)SpringUtils.getBean(FlowGraphService.class);
        if (fghs.hasAnyPartitioningInGraph(this.graph, def.projectKey)) {
            throw new IllegalArgumentException("'Find outputs' mode (build all reachable outputs and recursively all their dependencies) is not supported when Flow has some partitioning");
        }
    }
}

