/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec;

import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.common.CodeBasedThingHelper;
import com.dataiku.dip.dataflow.common.JobProcessExecution;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.Initializable;
import com.dataiku.dip.dataflow.exec.JobExecutionResultHandler;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.variables.VariablesService;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractCodeBasedActivityRunner
implements FlowRunnable,
Initializable,
EnvironmentStash.AppendModeGetter {
    protected final JobActivity activity;
    protected final RunnableSubgraph subgraph;
    protected String projectKey;
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected VariablesService variablesService;
    @Autowired
    protected APITicketService apiTicketService;
    @Autowired
    protected JobAuthCtxService authCtxService;

    public AbstractCodeBasedActivityRunner(JobActivity activity) {
        this.activity = activity;
        this.subgraph = activity.getSubgraph();
        activity.initStatus();
    }

    protected EnvironmentStash prepareEnvStash(File tmpDir, Map<String, String> extraEnv, ContainerExecRuntimeConfig containerConfig, String envName) throws IOException, SQLException, CodedException, DKUSecurityException, InterruptedException {
        EnvironmentStash environmentStash = new EnvironmentStash();
        if (containerConfig == null) {
            environmentStash.fillDefault();
        } else {
            environmentStash.fillDefaultForRemote();
        }
        environmentStash.fillForUserCodeRecipe(this.authCtxService.getAuthCtx(), this.activity, tmpDir, this);
        environmentStash.env.putAll(extraEnv);
        if (StringUtils.isNotBlank((CharSequence)envName)) {
            environmentStash.env.put("DKU_CODE_ENV_NAME", envName);
        }
        return environmentStash;
    }

    protected JobExecutionResultHandler getExecutionResultHandler() {
        return new JobExecutionResultHandler();
    }

    protected JobProcessExecution getProcessExecution() {
        return new JobProcessExecution(this.authCtxService.getAuthCtx(), this.projectKey);
    }

    protected CodeBasedThingHelper.ExecutionResult execute(ProcessBuilder builder, File logFile, Object optionalInput, String languageInfo, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType, boolean forceDisableImpersonation) throws Exception {
        CodeBasedThingHelper.ExecutionResult result = this.getProcessExecution().executeNoFail(builder, optionalInput, logFile, cgrouppableProcessType, forceDisableImpersonation);
        this.getExecutionResultHandler().handleExecutionResult(builder.directory(), languageInfo, result);
        return result;
    }

    public static class FlowSpec {
        public String tmpDir;
        public String currentActivityId;
        public List<SpecInput> in = new ArrayList<SpecInput>();
        public List<SpecOutput> out = new ArrayList<SpecOutput>();
        public String jekHost;
        public int jekPort;
        public String tintercomAPIBase;

        public void sortIOAccordingToRoles() {
            Collections.sort(this.in, new Comparator<SpecInput>(){

                @Override
                public int compare(SpecInput a, SpecInput b) {
                    int roleCmp = StringUtils.compare((String)a.role, (String)b.role);
                    if (roleCmp != 0) {
                        return roleCmp;
                    }
                    return a.indexInRole - b.indexInRole;
                }
            });
            Collections.sort(this.out, new Comparator<SpecOutput>(){

                @Override
                public int compare(SpecOutput a, SpecOutput b) {
                    int roleCmp = StringUtils.compare((String)a.role, (String)b.role);
                    if (roleCmp != 0) {
                        return roleCmp;
                    }
                    return a.indexInRole - b.indexInRole;
                }
            });
        }

        public static class SpecOutput {
            public FlowComputable.FCType type;
            public String fullName;
            public String smartName;
            public String partition;
            public String role;
            public int indexInRole;
            public String boxLabel;
            public boolean appendMode;
        }

        public static class SpecInput {
            public FlowComputable.FCType type;
            public String fullName;
            public String smartName;
            public List<String> partitions;
            public String boxLabel;
            public String modelLabel;
            public String role;
            public int indexInRole;
        }
    }
}

