/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.dataquality;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.dataquality.ExtractFailedRowsRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.dataquality.ExtractFailedRowsRecipeRunner;
import com.dataiku.dip.dataflow.exec.dataquality.ExtractFailedRowsRecipeSchemaComputer;
import com.dataiku.dip.dataflow.exec.dataquality.ExtractFailedRowsRecipeStatusComputer;
import com.dataiku.dip.dataflow.pipeline.ExtractFailedRowsRecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.dataquality.FailedRowsExtractRuleVisitor;
import com.dataiku.dip.dataquality.rules.ColumnEmptyRule;
import com.dataiku.dip.dataquality.rules.ColumnMeaningValidityRule;
import com.dataiku.dip.dataquality.rules.ColumnNotEmptyRule;
import com.dataiku.dip.dataquality.rules.ColumnUniqueValuesRule;
import com.dataiku.dip.dataquality.rules.ValuesInRangeRule;
import com.dataiku.dip.dataquality.rules.ValuesInSetRule;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.BasicRecipeLineageHandler;
import com.dataiku.dip.recipes.NoParams;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.dataquality.ExtractFailedRowsRecipeCreator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.ExtractFailedRowsSchemaGenerator;
import com.dataiku.dip.server.services.DataLineageService;
import com.dataiku.dip.spark.InputDatasetsReadParams;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;

public class ExtractFailedRowsRecipeMeta
extends RecipeMeta
implements BasicRecipeLineageHandler {
    public static final ExtractFailedRowsRecipeMeta META = new ExtractFailedRowsRecipeMeta();
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.recipe.dataquality");

    @Override
    public Class<? extends RecipeParams> paramsClass() {
        return NoParams.class;
    }

    @Override
    public String getType() {
        return "extract_failed_rows";
    }

    @Override
    public RecipeRunner buildRunner(JobActivity activity) {
        return new ExtractFailedRowsRecipeRunner(activity);
    }

    @Override
    public RecipeMeta.OutputSchemaComputability getOutputSchemasComputability() {
        return RecipeMeta.OutputSchemaComputability.RELIABLE_STATIC;
    }

    @Override
    public RecipeSchemaComputer buildSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        return new ExtractFailedRowsRecipeSchemaComputer(authCtx, activity);
    }

    @Override
    public ExtractFailedRowsRecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String payload) {
        return new ExtractFailedRowsRecipeStatusComputer(recipe, payload);
    }

    @Override
    public RecipeCreator buildCreator(AuthCtx authCtx) {
        return new ExtractFailedRowsRecipeCreator(authCtx, this);
    }

    @Override
    public RecipeDesc getRecipeDesc() {
        return this.getRecipeDesc("en");
    }

    @Override
    public RecipeDesc getRecipeDesc(String lang) {
        TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        RecipeDesc ret = RecipeDesc.newSisoDesc(ts.translateNoContext(lang, "RECIPE.EXTRACT_FAILED_ROWS.NAME", "extract failed rows", new Object[0]), null).multiEngine(true);
        RecipeDesc.IORoleDef out = ret.outputRoles.get(0);
        out.acceptsDataset = true;
        return ret;
    }

    @Override
    public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
        return new RecipeMeta.RecipeCategoryFlags().withVisualRecipe();
    }

    @Override
    public boolean hasJsonPayload() {
        return true;
    }

    @Override
    public SparkOverrideConfig getSparkConf(SerializedRecipe sr, String payload) {
        ExtractFailedRowsRecipePayloadParams params = (ExtractFailedRowsRecipePayloadParams)JSON.parse((String)payload, ExtractFailedRowsRecipePayloadParams.class);
        return params.engineParams.sparkSQL.sparkConfig;
    }

    @Override
    public String setSparkConf(SerializedRecipe sr, String payload, SparkOverrideConfig config) {
        ExtractFailedRowsRecipePayloadParams params = (ExtractFailedRowsRecipePayloadParams)JSON.parse((String)payload, ExtractFailedRowsRecipePayloadParams.class);
        params.engineParams.sparkSQL.sparkConfig = config;
        return JSON.pretty((Object)params);
    }

    @Override
    public String setEngine(SerializedRecipe sr, String payload, String engine) {
        ExtractFailedRowsRecipePayloadParams params = (ExtractFailedRowsRecipePayloadParams)JSON.parse((String)payload, ExtractFailedRowsRecipePayloadParams.class);
        params.engineType = engine;
        return JSON.pretty((Object)params);
    }

    @Override
    public String setImpalaMode(SerializedRecipe sr, String payload, boolean runInStreamMode) {
        ExtractFailedRowsRecipePayloadParams params = (ExtractFailedRowsRecipePayloadParams)JSON.parse((String)payload, ExtractFailedRowsRecipePayloadParams.class);
        params.engineParams.impala.forceStreamMode = runInStreamMode;
        return JSON.pretty((Object)params);
    }

    @Override
    public HiveRecipeMeta.HiveExecutionEngine getHiveEngine(SerializedRecipe sr, String payload) {
        ExtractFailedRowsRecipePayloadParams params = (ExtractFailedRowsRecipePayloadParams)JSON.parse((String)payload, ExtractFailedRowsRecipePayloadParams.class);
        return params.engineParams.hive.executionEngine;
    }

    @Override
    public String setHiveEngine(SerializedRecipe sr, String payload, HiveRecipeMeta.HiveExecutionEngine executionEngine) {
        ExtractFailedRowsRecipePayloadParams params = (ExtractFailedRowsRecipePayloadParams)JSON.parse((String)payload, ExtractFailedRowsRecipePayloadParams.class);
        params.engineParams.hive.executionEngine = executionEngine;
        return JSON.pretty((Object)params);
    }

    @Override
    public String setSparkEngine(SerializedRecipe sr, String payload, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine) {
        ExtractFailedRowsRecipePayloadParams params = (ExtractFailedRowsRecipePayloadParams)JSON.parse((String)payload, ExtractFailedRowsRecipePayloadParams.class);
        params.engineParams.sparkSQL.executionEngine = executionEngine;
        return JSON.pretty((Object)params);
    }

    @Override
    public InputDatasetsReadParams getInputDatasetsReadParams(SerializedRecipe sr, String payload) {
        return ((ExtractFailedRowsRecipePayloadParams)JSON.parse((String)payload, ExtractFailedRowsRecipePayloadParams.class)).engineParams.sparkSQL.readParams;
    }

    @Override
    public String setInputDatasetsReadParams(SerializedRecipe sr, String payload, InputDatasetsReadParams inputDatasetsReadParams) {
        ExtractFailedRowsRecipePayloadParams params = (ExtractFailedRowsRecipePayloadParams)JSON.parse((String)payload, ExtractFailedRowsRecipePayloadParams.class);
        params.engineParams.sparkSQL.readParams = inputDatasetsReadParams;
        return JSON.pretty((Object)params);
    }

    @Override
    public RecipePipelineHelper buildPipelineHelper(SerializedRecipe recipe, String payload, RecipePipelineHelper.PipelineType pipelineType, AuthCtx authCtx, JobActivity jobActivity) {
        return new ExtractFailedRowsRecipePipelineHelper(authCtx, recipe, payload, pipelineType, jobActivity);
    }

    @Override
    public RecipeLineage getRecipeLineage(DataLineageService.SerializedGraphNodes predecessors, DataLineageService.SerializedGraphNodes successors, String payload, AuthCtx authCtx, JobActivity activity, SerializedRecipe serializedRecipe) throws Exception {
        if (predecessors.datasetsByFullName.isEmpty() || successors.datasetsByFullName.isEmpty()) {
            return new RecipeLineage();
        }
        Preconditions.checkArgument((predecessors.datasetsByFullName.size() == 1 ? 1 : 0) != 0, (Object)"Extract failed rows recipe can have only one input dataset");
        Preconditions.checkArgument((successors.datasetsByFullName.size() == 1 ? 1 : 0) != 0, (Object)"Extract failed rows recipe can have only one output dataset");
        final SerializedDataset inputDataset = predecessors.datasetsByFullName.values().stream().findFirst().get();
        final SerializedDataset outputDataset = successors.datasetsByFullName.values().stream().findFirst().get();
        ExtractFailedRowsRecipePayloadParams payloadParams = (ExtractFailedRowsRecipePayloadParams)JSON.parse((String)payload, ExtractFailedRowsRecipePayloadParams.class);
        final RecipeLineage recipeLineage = this.buildBasicRecipeLineage((BasicRecipeLineageHandler.Params)payloadParams, inputDataset, outputDataset);
        ExtractFailedRowsRecipeSchemaComputer computer = new ExtractFailedRowsRecipeSchemaComputer(authCtx, activity);
        computer.setPayload(payload);
        ExtractFailedRowsSchemaGenerator.FailedRowsSchemaDetails schemaDetails = computer.getSchemaWithDetailsBeforeOverride();
        schemaDetails.outcomeColumnsDetails.outcomeColumns.forEach((outcomeColumnKey, outputColumnName) -> {
            DataQualityRule theRule = inputDataset.getDataQualityRuleSet().getRules().stream().filter(r -> r.getId().equals(outcomeColumnKey.ruleId)).findFirst().orElseThrow();
            class LineageVisitor
            implements FailedRowsExtractRuleVisitor {
                ExtractFailedRowsSchemaGenerator.OutcomeColumnKey outcomeColumnKey;
                String outputColumnName;

                public LineageVisitor(ExtractFailedRowsSchemaGenerator.OutcomeColumnKey outcomeColumnKey, String outputColumnName) {
                    this.outcomeColumnKey = outcomeColumnKey;
                    this.outputColumnName = outputColumnName;
                }

                @Override
                public void visit(ValuesInSetRule rule) {
                    this.abstractMultiColumnRuleVisit();
                }

                @Override
                public void visit(ValuesInRangeRule rule) {
                    this.abstractMultiColumnRuleVisit();
                }

                @Override
                public void visit(ColumnNotEmptyRule rule) {
                    this.abstractMultiColumnRuleVisit();
                }

                @Override
                public void visit(ColumnEmptyRule rule) {
                    this.abstractMultiColumnRuleVisit();
                }

                @Override
                public void visit(ColumnUniqueValuesRule rule) {
                    this.abstractMultiColumnRuleVisit();
                }

                @Override
                public void visit(ColumnMeaningValidityRule rule) {
                    this.abstractMultiColumnRuleVisit();
                }

                public void abstractMultiColumnRuleVisit() {
                    recipeLineage.addFactorizedColumnRelations(this.outcomeColumnKey.ruleColumn, this.outputColumnName, inputDataset, outputDataset);
                }
            }
            theRule.accept(new LineageVisitor((ExtractFailedRowsSchemaGenerator.OutcomeColumnKey)outcomeColumnKey, (String)outputColumnName));
        });
        this.handleColumnNameOverrides(payloadParams, recipeLineage);
        recipeLineage.keepValidRelations();
        return recipeLineage;
    }
}

