/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.dataquality;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.RecipeEnginesPreferenceConfig;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.dataquality.ExtractFailedRowsRecipePayloadParams;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.queries.ExecutionPlanService;
import com.dataiku.dip.recipes.common.RecipeConfigUtils;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.VisualSQLRecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeStatus;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.ExtractFailedRowsRecipeService;
import com.dataiku.dip.server.recipes.ExtractFailedRowsSchemaGenerator;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ExtractFailedRowsRecipeStatusComputer
extends VisualSQLRecipeStatusComputer {
    @Autowired
    private ExtractFailedRowsRecipeService service;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.dataquality.status");

    public ExtractFailedRowsRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    private ExtractFailedRowsRecipeStatus getEngineIndependentBaseStatus(AuthCtx authCtx, StatusInitializer init) {
        ExtractFailedRowsRecipeStatus status = new ExtractFailedRowsRecipeStatus();
        try {
            ExtractFailedRowsRecipePayloadParams params;
            init.activity = new JobActivity(this.recipesValidationService.getSampleSubgraph(new FlowRecipe(this.recipe)));
            status.params = params = this.service.loadParams(this.payload, this.recipe);
            status.engineParams = params.engineParams;
            init.inputDS = init.activity.getSubgraph().getSingleSourceDataset().getMandatoryUnsafe(this.datasetsDAO);
            init.outputDS = init.activity.getSubgraph().getSingleTargetDataset().getMandatoryUnsafe(this.datasetsDAO);
            this.recipesValidationService.checkComplianceWithRecipeDesc(authCtx, this.recipe);
            this.recipesValidationService.checkTargetsAreWritable(init.activity);
            if (!Objects.equals(init.inputDS.getPartitioningSchema(), init.outputDS.getPartitioningSchema())) {
                String warningDetails = "Partitioning scheme mismatch between input and output datasets. This may produce invalid results ";
                logger.warn((Object)warningDetails);
                status.output.withWarning(RecipeCodes.ERR_RECIPE_INCONSISTENT_I_O, warningDetails);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Invalid recipe", (Throwable)e);
            status.output.withFatal(RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, ExceptionUtils.getMessageWithCauses((Throwable)e));
            return status;
        }
        return status;
    }

    public ExtractFailedRowsRecipeStatus fastStatusIgnorePartitions(StatusInitializer init, boolean reportUnknownErrorsToStatus, AuthCtx authCtx) throws IOException, DKUSecurityException {
        ExtractFailedRowsRecipeStatus status;
        block11: {
            RecipeEnginesPreferenceConfig repc;
            ExtractFailedRowsRecipePayloadParams params;
            block10: {
                status = this.getEngineIndependentBaseStatus(authCtx, init);
                if (status.isInvalid()) {
                    return status;
                }
                params = status.params;
                repc = new RecipeConfigUtils().getResolvedPreferenceConfig(this.recipe.projectKey, this.recipe.type, params.enginesPreferences);
                try {
                    this.performBasicStructureChecks(status, authCtx);
                    this.visualRecipesService.initEngines(authCtx, init.activity, status, this.recipe.projectKey);
                    this.performBasicCDEChecks(status, authCtx);
                    this.visualRecipesService.selectEngine(authCtx, init.activity, params.engineType, status, this.recipe.type, repc);
                    this.visualRecipesService.adjustEngineStatus(authCtx, init.activity, status, "Compute failed rows in-database, then streaming of rows");
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to init engine", (Throwable)e);
                    if (status.isInvalid()) break block10;
                    status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to init engine: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                }
            }
            if (!status.isInvalid()) {
                try {
                    this.makeRecipeSpecificEnginesStatus(authCtx, init, status, params);
                    this.visualRecipesService.selectEngine(authCtx, init.activity, params.engineType, status, this.recipe.type, repc);
                    this.visualRecipesService.adjustEngineStatus(authCtx, init.activity, status, "Compute failed rows in-database, then streaming of rows");
                    if (status.selectedEngine == null && !status.isInvalid()) {
                        status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "No engine selected", new Object[0]);
                        return status;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to init engine", (Throwable)e);
                    status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to init engine: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    return status;
                }
                if (status.getSelectedSQLBasedEngine().queryBased) {
                    try {
                        init.dialect = this.visualRecipesService.getDialect(authCtx, init.activity, status.getSelectedSQLBasedEngine());
                        status.sql = this.service.generateSQLIgnorePartitions(init.dialect, params, init.inputDS, init.outputDS);
                    }
                    catch (Exception e) {
                        logger.info((Object)"Failed to generate SQL", (Throwable)e);
                        init.error = ExceptionUtils.getMessageWithCauses((Throwable)e);
                        if (!reportUnknownErrorsToStatus) break block11;
                        status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to generate SQL: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    }
                }
            }
        }
        return status;
    }

    @Override
    public ExtractFailedRowsRecipeStatus getStatusForConversion_NT(AuthCtx authCtx) throws Exception {
        ExtractFailedRowsRecipeStatus status;
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(init, true, authCtx);
            if (status.isInvalid()) {
                logger.warn((Object)"Recipe status is invalid. Try to generate query anyway:");
            }
            status.sql = this.service.generateSQL(init.activity, init.dialect, status.params);
        }
        return status;
    }

    @Override
    public ExtractFailedRowsRecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws IOException, DKUSecurityException {
        boolean lowerCaseColumnsNames;
        ExtractFailedRowsRecipeStatus status;
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(init, false, authCtx);
            if (status.isInvalid()) {
                this.fixupStatusOutputInvalid(status);
                ExtractFailedRowsRecipeStatus extractFailedRowsRecipeStatus = status;
                return extractFailedRowsRecipeStatus;
            }
        }
        ExtractFailedRowsRecipePayloadParams params = status.params;
        VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine = status.getSelectedSQLBasedEngine();
        Dataset inputDS = init.inputDS;
        SQLDialect dialect = init.dialect;
        VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest request = (VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest)JSON.parse((String)requestData, VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest.class);
        if (request != null && !request.exactPlan) {
            this.visualRecipesService.enableSimplifiedExplainPlan(selectedEngine, params);
        }
        try {
            lowerCaseColumnsNames = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)params, selectedEngine);
            Integer identifierMaxLength = dialect == null ? null : Integer.valueOf(dialect.getIdentifiersMaxLength());
            status.rules = new RecipeStatus.StepStatus();
            status.consolidatedColumnRules = ExtractFailedRowsRecipeStatusComputer.consolidateColumnRules(params, init.inputDS, identifierMaxLength, status.rules, selectedEngine != null && selectedEngine.queryBased);
            this.updateRulesStepStatus(status.rules, status.consolidatedColumnRules);
            status.outputSchemaBeforeOverride = this.service.getOutputSchemaBeforeOverride(inputDS, params, lowerCaseColumnsNames, identifierMaxLength);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to compute output schema", (Throwable)e);
            status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute output schema: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
            return status;
        }
        if (status.isInvalid()) {
            this.fixupStatusOutputInvalid(status);
            return status;
        }
        this.checkOutputSchema(status, params, lowerCaseColumnsNames);
        if (this.needToComputeExecutionPlan(selectedEngine, status, request)) {
            boolean executionPlanFailed = false;
            String executionPlanErrMsg = null;
            try {
                status.executionPlan = this.getExecutionPlan(authCtx, inputDS, selectedEngine, status.sql, params.engineParams);
            }
            catch (ExecutionPlanService.HiveTableNotFound e) {
                logger.error((Object)"Failed to compute execution plan", (Throwable)e);
                status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute execution plan, table not found in Hive metastore %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
            }
            catch (Exception e) {
                logger.error((Object)"Failed to compute execution plan", (Throwable)e);
                logger.info((Object)("Query:\n" + status.sql));
                executionPlanFailed = true;
                executionPlanErrMsg = e.getMessage();
                status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute execution plan: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
            }
            if (executionPlanFailed) {
                try {
                    this.investigateExecutionPlanFailure(status, init, executionPlanErrMsg, authCtx);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to determe error cause", (Throwable)e);
                }
            }
        }
        if (init.error != null && !status.isInvalid()) {
            status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Unknown error: %s", new Object[]{init.error});
        }
        this.fixupStatusOutputInvalid(status);
        return status;
    }

    @Override
    public RecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws Exception {
        return this.fastStatusIgnorePartitions(new StatusInitializer(), true, authCtx);
    }

    private void fixupStatusOutputInvalid(VisualSQLRecipeStatus status) {
        if (status.isInvalid() && !status.output.anyFatal()) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "Failed to validate all recipe steps");
        }
    }

    private void makeRecipeSpecificEnginesStatus(AuthCtx authCtx, StatusInitializer init, ExtractFailedRowsRecipeStatus status, ExtractFailedRowsRecipePayloadParams params) throws Exception {
        logger.infoV("Computing engine status for extract failed rows recipe", new Object[0]);
        for (VisualSQLRecipesBaseService.SQLBasedEngineStatus engine : status.getEngines()) {
            if (!engine.isSelectable || !engine.queryBased) continue;
            try {
                SQLDialect dialect = this.visualRecipesService.getDialect(authCtx, init.activity, engine);
                this.service.generateSQLIgnorePartitions(dialect, status.params, init.inputDS, init.outputDS);
            }
            catch (Exception e) {
                if (engine.type.equals("DSS")) {
                    RecipeEngineStatus.setErrorStatus("Recipe configuration is not supported: " + ExceptionUtils.getMessageWithCauses((Throwable)e), engine);
                    continue;
                }
                RecipeEngineStatus.setErrorStatus("Recipe cannot be translated to SQL: " + ExceptionUtils.getMessageWithCauses((Throwable)e), engine);
            }
        }
    }

    private static void updateRuleColumnStatus(@Nullable RecipeStatus.StepStatus stepStatus, ExtractFailedRowsRecipePayloadParams.UIColumnRuleDesc desc, ExtractFailedRowsSchemaGenerator.RuleValidityType ruleValidityType, String invalidRuleMessage) {
        if (stepStatus == null) {
            return;
        }
        desc.detailsSeverity = switch (ruleValidityType) {
            default -> throw new IncompatibleClassChangeError();
            case ExtractFailedRowsSchemaGenerator.RuleValidityType.WHOLE_DATASET_RULE_COMPUTATION_SCOPE, ExtractFailedRowsSchemaGenerator.RuleValidityType.INCOMPATIBLE_RULE -> ExtractFailedRowsRecipePayloadParams.DETAILS_SEVERITY.WARNING;
            case ExtractFailedRowsSchemaGenerator.RuleValidityType.RULE_NOT_SUPPORTED_BY_SELECTED_ENGINE, ExtractFailedRowsSchemaGenerator.RuleValidityType.INVALID_RULE_CONFIG -> ExtractFailedRowsRecipePayloadParams.DETAILS_SEVERITY.ERROR;
            case ExtractFailedRowsSchemaGenerator.RuleValidityType.VALID -> desc.isSelected && desc.isUnderlyingRuleDisabled ? ExtractFailedRowsRecipePayloadParams.DETAILS_SEVERITY.INFO : null;
        };
        switch (ruleValidityType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case WHOLE_DATASET_RULE_COMPUTATION_SCOPE: {
                Object object = "Rule computation scope is the whole partitioned dataset";
                break;
            }
            case RULE_NOT_SUPPORTED_BY_SELECTED_ENGINE: {
                Object object = "Rule is not supported by selected engine";
                break;
            }
            case INVALID_RULE_CONFIG: {
                Object object = "Rule configuration is invalid: " + invalidRuleMessage;
                break;
            }
            case INCOMPATIBLE_RULE: {
                Object object = "Rule type is incompatible with row-level extraction. See <a href=\"https://doc.dataiku.com/dss/latest/other_recipes/extract-failed-rows.html#supported-data-quality-rules\" target=\"_blank\">supported rules</a>.";
                break;
            }
            case VALID: {
                Object object = desc.details = desc.isSelected && desc.isUnderlyingRuleDisabled ? "Rule will produce a column with EMPTY values because the rule is disabled" : null;
            }
        }
        if (desc.isSelected) {
            String message;
            switch (ruleValidityType) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case WHOLE_DATASET_RULE_COMPUTATION_SCOPE: {
                    String string = "Computation scope of " + desc.buildNameForDetails(false, true) + " is the whole partitioned dataset";
                    break;
                }
                case RULE_NOT_SUPPORTED_BY_SELECTED_ENGINE: {
                    String string = desc.buildNameForDetails(true, true) + " is  not supported by selected engine";
                    break;
                }
                case INVALID_RULE_CONFIG: {
                    String string = "Configuration of " + desc.buildNameForDetails(false, true) + " is invalid: " + invalidRuleMessage;
                    break;
                }
                case INCOMPATIBLE_RULE: {
                    String string = "Type of " + desc.buildNameForDetails(false, true) + " is incompatible with row-level extraction";
                    break;
                }
                case VALID: {
                    String string = message = null;
                }
            }
            if (desc.detailsSeverity == ExtractFailedRowsRecipePayloadParams.DETAILS_SEVERITY.WARNING) {
                stepStatus.withWarning(RecipeCodes.WARN_RECIPE_EXTRACT_FAILED_ROWS_INCOMPATIBLE_RULE_SELECTED, message);
            } else if (desc.detailsSeverity == ExtractFailedRowsRecipePayloadParams.DETAILS_SEVERITY.ERROR) {
                stepStatus.withFatal(RecipeCodes.ERR_RECIPE_EXTRACT_FAILED_ROWS_INVALID_RULE_SELECTED, message);
            }
        }
    }

    private void updateRulesStepStatus(RecipeStatus.StepStatus stepStatus, List<ExtractFailedRowsRecipePayloadParams.UIColumnRuleDesc> consolidatedColumnRules) {
        if (consolidatedColumnRules.stream().noneMatch(desc -> desc.isSelected)) {
            stepStatus.withWarning(RecipeCodes.WARN_RECIPE_EXTRACT_FAILED_ROWS_NO_RULES_SELECTED, "The output dataset will be empty");
        }
    }

    public static List<ExtractFailedRowsRecipePayloadParams.UIColumnRuleDesc> consolidateColumnRules(ExtractFailedRowsRecipePayloadParams params, Dataset dataset, Integer identifierMaxLength, @Nullable RecipeStatus.StepStatus stepStatus, boolean isSql) {
        List<DataQualityRule> datasetRules = dataset.getModel().getDataQualityRuleSet().getRules();
        ExtractFailedRowsSchemaGenerator.RulesValidityDetails rulesValidityDetails = ExtractFailedRowsSchemaGenerator.getRulesValidityDetails(datasetRules, dataset, isSql);
        List<DataQualityRule> supportedRules = ExtractFailedRowsSchemaGenerator.getSupportedRules(datasetRules);
        List<DataQualityRule> supportedValidRules = supportedRules.stream().filter(rule -> rulesValidityDetails.getRuleValidityType((String)rule.getId()).isSupported).toList();
        ExtractFailedRowsSchemaGenerator.OutcomeColumnsDetails outcomeColumnsDetails = ExtractFailedRowsSchemaGenerator.generateOutcomeColumnDetails(identifierMaxLength, new Schema(dataset.getSchema()), supportedValidRules, outcomeColumnKey -> true);
        Map existingColumnRulesByOutcomeColumnKey = params.columnRules.stream().collect(Collectors.toMap(desc -> new ExtractFailedRowsSchemaGenerator.OutcomeColumnKey(desc.ruleId, desc.ruleColumn), Function.identity()));
        HashMap outcomeColumnKeysByRuleId = new HashMap();
        outcomeColumnsDetails.outcomeColumns.forEach((outcomeColumnKey, outcomeColumnName) -> {
            String ruleId = outcomeColumnKey.ruleId;
            outcomeColumnKeysByRuleId.computeIfAbsent(ruleId, x -> new ArrayList()).add(outcomeColumnKey);
        });
        ArrayList<ExtractFailedRowsRecipePayloadParams.UIColumnRuleDesc> consolidatedColumnRules = new ArrayList<ExtractFailedRowsRecipePayloadParams.UIColumnRuleDesc>();
        for (DataQualityRule rule2 : datasetRules) {
            String ruleId = rule2.getId();
            List outcomeColumnKeys = (List)outcomeColumnKeysByRuleId.get(ruleId);
            ExtractFailedRowsSchemaGenerator.RuleValidityType ruleValidityType = rulesValidityDetails.getRuleValidityType(ruleId);
            String invalidRuleMessage = Optional.ofNullable(rulesValidityDetails.getRuleValidationError(ruleId)).map(Throwable::getMessage).orElse(null);
            if (outcomeColumnKeys == null || outcomeColumnKeys.isEmpty()) {
                ExtractFailedRowsRecipePayloadParams.UIColumnRuleDesc uiDesc = new ExtractFailedRowsRecipePayloadParams.UIColumnRuleDesc();
                uiDesc.ruleId = ruleId;
                uiDesc.ruleDisplayedName = rule2.getDisplayName();
                uiDesc.ruleColumn = null;
                uiDesc.outcomeColumn = null;
                uiDesc.isSelected = false;
                uiDesc.isSupported = ruleValidityType.isSupported;
                uiDesc.isUnderlyingRuleDisabled = !rule2.enabled;
                ExtractFailedRowsRecipeStatusComputer.updateRuleColumnStatus(stepStatus, uiDesc, ruleValidityType, invalidRuleMessage);
                consolidatedColumnRules.add(uiDesc);
                continue;
            }
            for (ExtractFailedRowsSchemaGenerator.OutcomeColumnKey outcomeColumnKey2 : outcomeColumnKeys) {
                ExtractFailedRowsRecipePayloadParams.UIColumnRuleDesc uiDesc = new ExtractFailedRowsRecipePayloadParams.UIColumnRuleDesc();
                uiDesc.ruleId = ruleId;
                uiDesc.ruleDisplayedName = rule2.getDisplayName();
                uiDesc.ruleColumn = outcomeColumnKey2.ruleColumn;
                uiDesc.outcomeColumn = outcomeColumnsDetails.outcomeColumns.get(outcomeColumnKey2);
                uiDesc.isSelected = !params.explicitColumnSelection || Optional.ofNullable((ExtractFailedRowsRecipePayloadParams.ColumnRuleDesc)existingColumnRulesByOutcomeColumnKey.get(outcomeColumnKey2)).map(desc -> desc.isSelected).orElse(false) != false;
                uiDesc.isSupported = ruleValidityType.isSupported;
                uiDesc.isUnderlyingRuleDisabled = !rule2.enabled;
                ExtractFailedRowsRecipeStatusComputer.updateRuleColumnStatus(stepStatus, uiDesc, ruleValidityType, invalidRuleMessage);
                consolidatedColumnRules.add(uiDesc);
            }
        }
        return consolidatedColumnRules;
    }

    private void checkOutputSchema(ExtractFailedRowsRecipeStatus status, ExtractFailedRowsRecipePayloadParams params, boolean lowerCaseColumnsNames) {
        try {
            if (status.outputSchemaBeforeOverride != null) {
                status.outputSchema = new Schema(status.outputSchemaBeforeOverride);
                if (params.outputColumnNameOverrides != null) {
                    HashSet<String> usedNames = new HashSet<String>();
                    for (SchemaColumn sc : status.outputSchema.columns) {
                        String colName = sc.getName();
                        String overrideName = params.outputColumnNameOverrides.get(sc.getName());
                        if (StringUtils.isNotBlank((String)overrideName)) {
                            colName = overrideName;
                            if (lowerCaseColumnsNames) {
                                overrideName = overrideName.toLowerCase();
                            }
                            sc.setName(overrideName);
                        }
                        if (StringUtils.isNotBlank((String)(colName = colName.toLowerCase())) && usedNames.contains(colName)) {
                            status.output.withFatalV(RecipeCodes.ERR_RECIPE_EXTRACT_FAILED_ROWS_DUPLICATE_OUTPUT, "Duplicate name: '" + colName + "'", new Object[0]);
                        }
                        usedNames.add(colName);
                    }
                }
                if (status.outputSchema.columns.isEmpty()) {
                    status.output.withFatalV(RecipeCodes.ERR_RECIPE_EMPTY_OUTPUT_SCHEMA, "Empty output schema", new Object[0]);
                }
            }
        }
        catch (Exception e) {
            status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Error computing schema: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
        }
    }

    private void investigateExecutionPlanFailure(ExtractFailedRowsRecipeStatus status, StatusInitializer init, String executionPlanErrMsg, AuthCtx authCtx) {
        if (status.getSelectedSQLBasedEngine().type.equals("HIVE")) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_EXECUTION_PLAN_COMPUTATION_FAILED, executionPlanErrMsg);
            return;
        }
        boolean errorOriginFound = false;
        if (!errorOriginFound) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, executionPlanErrMsg);
        }
    }

    public static class ExtractFailedRowsRecipeStatus
    extends VisualSQLRecipeStatus {
        RecipeStatus.StepStatus rules;
        public ExtractFailedRowsRecipePayloadParams params;
        public List<ExtractFailedRowsRecipePayloadParams.UIColumnRuleDesc> consolidatedColumnRules = new ArrayList<ExtractFailedRowsRecipePayloadParams.UIColumnRuleDesc>();

        @Override
        public InfoMessage.InfoMessages gatherAllMessages() {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            ret.mergeFrom(this.topLevelMessages);
            if (this.output != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.output);
            }
            if (this.rules != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.rules);
            }
            return ret;
        }

        @Override
        public boolean isInvalid() {
            return this.gatherAllMessages().anyFatal();
        }
    }

    public static class StatusInitializer {
        public Dataset inputDS;
        public Dataset outputDS;
        public SQLDialect dialect;
        public JobActivity activity;
        public String error;
    }
}

