/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.h2;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.H2Connection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class H2DB
implements AutoCloseable {
    File folder;
    private final SQLConnectionProvider.SQLConnectionData connData;
    private final SQLConnectionProvider.SQLConnectionData adminConnData;
    private final SQLConnectionProvider.SQLConnectionWrapper conn;
    private final SQLConnectionProvider.SQLConnectionWrapper adminConn;
    private final String projectKey;
    private Map<String, Dataset> datasets = new HashMap<String, Dataset>();
    static DKULogger logger = DKULogger.getLogger((String)"dku.h2db");

    public H2DB(String projectKey) throws Exception {
        try {
            Class.forName("org.h2.Driver");
            String id = SecretKeyGenerator.generate((int)8);
            this.folder = FlowJobUtils.getTmpFolder("dataset-to-h2", id);
            this.projectKey = projectKey;
            logger.infoV("Creating a temporary H2 database: %s", new Object[]{this.folder.getAbsolutePath()});
            H2Connection h2AdminConnection = this.createConnection("h2_admin", null);
            this.adminConnData = h2AdminConnection.getConnectionData_NT(DSSAuthCtx.newNone(), projectKey);
            this.adminConn = SQLConnectionProvider.newConnection(this.adminConnData, (AuthCtx)DSSAuthCtx.newNone(), projectKey);
            SQLUtils.safeExec(this.adminConn, "CREATE USER h2_user PASSWORD ''");
            SQLUtils.safeExec(this.adminConn, "GRANT ALL ON SCHEMA public TO h2_user");
            SQLUtils.safeExec(this.adminConn, "CREATE SCHEMA h2_work AUTHORIZATION h2_user");
            SQLUtils.safeExec(this.adminConn, "SET SCHEMA h2_work");
            H2Connection h2UserConnection = this.createConnection("h2_user", "h2_work");
            this.connData = h2UserConnection.getConnectionData_NT(DSSAuthCtx.newNone(), projectKey);
            this.conn = SQLConnectionProvider.newConnection(this.connData, (AuthCtx)DSSAuthCtx.newNone(), projectKey);
            SQLUtils.safeExec(this.conn, "SET TIME ZONE 'UTC'");
        }
        catch (Exception e) {
            logger.error((Object)"Failed to create H2 db", (Throwable)e);
            this.close();
            throw e;
        }
    }

    public void shutdown() throws SQLException, DKUSecurityException, InterruptedException {
        logger.info((Object)"shutdown H2 session");
        try (SQLConnectionProvider.SQLConnectionWrapper adminWrapper = SQLConnectionProvider.newConnection(this.adminConnData, (AuthCtx)DSSAuthCtx.newNone(), this.projectKey);){
            try (Statement st2 = adminWrapper.createStatement();){
                st2.execute("SHUTDOWN IMMEDIATELY");
                logger.info((Object)"shutdown sent to H2");
            }
            catch (Throwable e) {
                logger.error((Object)"H2 unable to shutdown", e);
            }
        }
    }

    private H2Connection createConnection(String userName, String schema) {
        H2Connection connection = new H2Connection();
        connection.name = "internal-h2-connection-for-recipe";
        connection.params.folder = this.folder.getAbsolutePath();
        connection.params.dssRuntimeDB = false;
        connection.params.properties.add(new AbstractSQLConnection.CustomDatabaseProperty("USER", userName, false));
        if (StringUtils.isNotBlank((String)schema)) {
            connection.params.properties.add(new AbstractSQLConnection.CustomDatabaseProperty("SCHEMA", schema, false));
        }
        return connection;
    }

    public File tableFile(String tableName) {
        return DKUFileUtils.getWithin((File)this.folder, (String[])new String[]{tableName + ".csv"});
    }

    @Override
    public void close() throws Exception {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to close H2 connection", (Throwable)e);
            }
        }
        if (this.adminConn != null) {
            try {
                this.adminConn.close();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to close H2 admin connection", (Throwable)e);
            }
        }
        if (this.folder != null && this.folder.isDirectory() && !ApplicationConfigurator.getParams().getBoolParam("dku.recipes.visual.h2based,keepData", false)) {
            DKUFileUtils.deleteDirectory((File)this.folder);
        }
    }

    public SQLConnectionProvider.SQLConnectionData getConnData() {
        return this.connData;
    }

    public SQLConnectionProvider.SQLConnectionWrapper getConn() {
        return this.conn;
    }

    public SQLConnectionProvider.SQLConnectionWrapper getAdminConn() {
        return this.adminConn;
    }

    public void addDataset(Dataset dataset) {
        this.datasets.put(dataset.getName(), dataset);
    }

    public Dataset getDataset(String datasetName) {
        return this.datasets.get(datasetName);
    }
}

