/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.join;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.RecipeEnginesPreferenceConfig;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.QueryGenerationUtils;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeHelper;
import com.dataiku.dip.dataflow.exec.join.JoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeSchemaComputer;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnDesc;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnsStepStatus;
import com.dataiku.dip.dataflow.exec.joinlike.ConditionsMode;
import com.dataiku.dip.dataflow.exec.joinlike.Duplicate;
import com.dataiku.dip.dataflow.exec.joinlike.JoinLikeRecipeStatus;
import com.dataiku.dip.dataflow.exec.joinlike.JoinLikeStatusUtils;
import com.dataiku.dip.dataflow.exec.joinlike.JoinOutputRole;
import com.dataiku.dip.dataflow.exec.joinlike.JoinType;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.queries.ExecutionPlanService;
import com.dataiku.dip.recipes.common.RecipeConfigUtils;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.VisualSQLRecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeStatus;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Predicate;

public class JoinRecipeStatusComputer
extends VisualSQLRecipeStatusComputer {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.join.status");

    public JoinRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    public JoinRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws Exception {
        return this.fastStatusIgnorePartitions(new StatusInitializer(), authCtx);
    }

    private boolean isColumnNameInvalidForH2(String columnName) {
        return columnName.contains(",") || columnName.contains("'") || columnName.trim().length() != columnName.length();
    }

    private boolean isColumnNameInvalidForSPARK(String columnName) {
        return columnName.matches(".*[ ,;{}()\\t\\n=']+.*");
    }

    @Override
    public JoinRecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) {
        JoinRecipeStatus status;
        JoinLikeStatusUtils joinLikeStatusUtils = new JoinLikeStatusUtils(authCtx, this.transactionService);
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(init, authCtx);
        }
        if (status.isInvalid()) {
            return status;
        }
        JoinRecipePayloadParams params = status.params;
        SQLDialect dialect = init.dialect;
        JoinRecipeHelper helper = init.helper;
        List<Dataset> sources = init.sources;
        VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine = status.getSelectedSQLBasedEngine();
        if (status.selectedEngine == null) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "No available engine can run this recipe");
            return status;
        }
        boolean lowerCaseColumnsNames = params.engineParams.lowerCaseSchemaIfEngineRequiresIt && status.getSelectedSQLBasedEngine().lowercasesColumnNames();
        helper.initAliases(params, lowerCaseColumnsNames);
        VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest request = (VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest)JSON.parse((String)requestData, VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest.class);
        if (request != null && !request.exactPlan) {
            this.visualRecipesService.enableSimplifiedExplainPlan(selectedEngine, params);
        }
        List<Object> preFilterSQLExpressions = new ArrayList(params.virtualInputs.size());
        String postFilterSQLExpression = null;
        try {
            if (!status.isInvalid()) {
                preFilterSQLExpressions = this.checkVirtualInputs(init, status, helper);
            }
            if (!status.isInvalid()) {
                this.basicJoinsCheck(status, helper.datasetsMap);
            }
            if (!status.isInvalid()) {
                this.checkLargeOutput(status, helper);
            }
            if (!status.isInvalid()) {
                joinLikeStatusUtils.validateOutputSchema(status, params, dialect != null && dialect.hasCaseInsensitiveColumns(), this.payload, init.activity);
            }
            if (!status.isInvalid() && params.computedColumns != null && !params.computedColumns.isEmpty()) {
                status.computedColumns = new ColumnsStepStatus();
                boolean engineMustLowerColumnNames = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)params, selectedEngine);
                this.visualRecipesService.checkComputedColumns(params.computedColumns, status.outputSchemaWithoutComputedColumns, selectedEngine, dialect, engineMustLowerColumnNames, status.computedColumns);
            }
            if (!status.isInvalid() && params.postFilter != null) {
                if (params.postFilter.enabled) {
                    status.postFilter = new RecipeStatus.StepStatus();
                    boolean translateFully = !status.selectedEngine.type.equals("DSS");
                    postFilterSQLExpression = this.visualRecipesService.checkFilter(params.postFilter, new Dataset().withSchema(status.outputSchema), dialect, status.postFilter, translateFully);
                } else if (params.postFilter.distinct) {
                    status.postFilter = new RecipeStatus.StepStatus();
                }
            }
            boolean executionPlanFailed = false;
            String executionPlanErrMsg = null;
            boolean errorOriginFound = false;
            if (status.selectedEngine instanceof VisualSQLRecipesBaseService.SQLBasedEngineStatus && this.needToComputeExecutionPlan((VisualSQLRecipesBaseService.SQLBasedEngineStatus)status.selectedEngine, status, request)) {
                try {
                    status.executionPlan = this.getExecutionPlan(authCtx, sources, status.getSelectedSQLBasedEngine(), status.sql, params.engineParams);
                }
                catch (ExecutionPlanService.HiveTableNotFound e) {
                    logger.error((Object)"Failed to compute execution plan", (Throwable)e);
                    status.output.withWarning(RecipeCodes.ERR_RECIPE_EXECUTION_PLAN_COMPUTATION_FAILED, "Table not found in Hive global metastore:" + ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to compute execution plan", (Throwable)e);
                    logger.info((Object)("Query:\n" + status.sql));
                    executionPlanErrMsg = e.getMessage();
                    executionPlanFailed = true;
                    status.output.withWarning(RecipeCodes.ERR_RECIPE_EXECUTION_PLAN_COMPUTATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                if (!this.recipe.getOutputsForRole(JoinOutputRole.UNMATCHED_ROWS_LEFT.name).isEmpty()) {
                    try {
                        status.leftUnmatchedStatus.executionPlan = this.getExecutionPlan(authCtx, sources, status.getSelectedSQLBasedEngine(), status.leftUnmatchedStatus.sql, params.engineParams);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to compute execution plan for left unmatched output", (Throwable)e);
                        logger.info((Object)("Query:\n" + status.leftUnmatchedStatus.sql));
                    }
                }
                if (!this.recipe.getOutputsForRole(JoinOutputRole.UNMATCHED_ROWS_RIGHT.name).isEmpty()) {
                    try {
                        status.rightUnmatchedStatus.executionPlan = this.getExecutionPlan(authCtx, sources, status.getSelectedSQLBasedEngine(), status.rightUnmatchedStatus.sql, params.engineParams);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to compute execution plan for right unmatched output", (Throwable)e);
                        logger.info((Object)("Query:\n" + status.rightUnmatchedStatus.sql));
                    }
                }
            }
            this.checkForInvalidCharactersInSelectedColumns(status, params);
            if (init.error != null && !status.isInvalid()) {
                status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, init.error);
            }
            if (executionPlanFailed && status.selectedEngine.type.equals("HIVE")) {
                status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, executionPlanErrMsg);
            } else if (executionPlanFailed) {
                ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
                logger.info((Object)"Check pre-filters");
                for (int i = 0; i < preFilterSQLExpressions.size(); ++i) {
                    String filterSQLExpression = (String)preFilterSQLExpressions.get(i);
                    if (filterSQLExpression == null) continue;
                    JoinRecipePayloadParams.InputDesc input = (JoinRecipePayloadParams.InputDesc)params.virtualInputs.get(i);
                    SelectQueryBuilder qb = new SelectQueryBuilder();
                    SQLUtils.SQLTable table = helper.sqlTablesMap.get(input.name);
                    qb.from(table, null);
                    qb.where(ef.expr(filterSQLExpression));
                    String sql = qb.toSQL(dialect);
                    try {
                        this.getExecutionPlan(authCtx, sources, status.getSelectedSQLBasedEngine(), sql, params.engineParams);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)("Pre-filter " + i + " invalid"), (Throwable)e);
                        status.preFilters.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_JOIN_INVALID_FILTER, (String)ExceptionUtils.getMessageWithCauses((Throwable)e)).withPos(i, 0));
                        errorOriginFound = true;
                    }
                }
                if (!errorOriginFound) {
                    errorOriginFound = this.explainVirtualInputsFailed(init, status, helper, authCtx);
                }
                if (params.computedColumns != null && !errorOriginFound) {
                    errorOriginFound = this.explainPostJoinComputedColumns(init, status, helper, authCtx, sources, lowerCaseColumnsNames, executionPlanErrMsg);
                }
                if (postFilterSQLExpression != null && !errorOriginFound) {
                    logger.info((Object)"Check post-filter");
                    JoinRecipePayloadParams params2 = (JoinRecipePayloadParams)JSON.deepCopy((Object)params);
                    for (JoinRecipePayloadParams.InputDesc input : params.virtualInputs) {
                        input.preFilter = null;
                    }
                    params2.postFilter = null;
                    String sql = helper.generateSQLIgnorePartitioning_NT(authCtx, init.activity, dialect, params2, lowerCaseColumnsNames, JoinOutputRole.MAIN);
                    this.getExecutionPlan(authCtx, sources, status.getSelectedSQLBasedEngine(), sql, params.engineParams);
                    status.postFilter.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_FILTER, this.formatDatabaseErrorMsg(executionPlanErrMsg, dialect));
                    logger.info((Object)"Post-filter invalid");
                    errorOriginFound = true;
                }
                if (!errorOriginFound) {
                    status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, executionPlanErrMsg);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Invalid recipe", (Throwable)e);
            status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        if (status.isInvalid() && !status.output.anyFatal()) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "Some recipe steps did not validate");
        }
        return status;
    }

    private void checkForInvalidCharactersInSelectedColumns(JoinRecipeStatus status, JoinRecipePayloadParams params) {
        StringJoiner[] stringJoiners = new StringJoiner[params.virtualInputs.size()];
        for (int i = 0; i < stringJoiners.length; ++i) {
            stringJoiners[i] = new StringJoiner("; ", " In " + ((JoinRecipePayloadParams.InputDesc)params.virtualInputs.get((int)i)).name + " you should rename the column: ", "");
            stringJoiners[i] = stringJoiners[i].setEmptyValue("");
        }
        Predicate<ColumnDesc> isInvalid = status.selectedEngine.type.equals("SPARK") ? columnDesc -> this.isColumnNameInvalidForSPARK(columnDesc.alias) : columnDesc -> this.isColumnNameInvalidForH2(columnDesc.alias);
        params.getSelectedColumns().stream().filter(isInvalid).forEach(columnDesc -> stringJoiners[columnDesc.table].add(columnDesc.alias));
        for (StringJoiner stringJoiner : stringJoiners) {
            if (stringJoiner.length() == 0) continue;
            if (status.selectedEngine.type.equals("SPARK")) {
                status.selectedColumns.withWarning(RecipeCodes.WARN_RECIPE_JOIN_INVALID_CHAR, "One or more output columns contains one or more of these characters \" ,;{}()\\n\\t='\" which are not supported by some SPARK engine." + String.valueOf(stringJoiner));
                continue;
            }
            status.selectedColumns.withWarning(RecipeCodes.WARN_RECIPE_JOIN_INVALID_CHAR, "Column names can not contain comma, quotation mark, leading or trailing white spaces with DSS engine (when using H2)." + String.valueOf(stringJoiner));
        }
    }

    private boolean explainVirtualInputsFailed(StatusInitializer init, JoinRecipeStatus status, JoinRecipeHelper helper, AuthCtx authCtx) {
        SQLDialect dialect = init.dialect;
        List<Dataset> sources = init.sources;
        JoinRecipePayloadParams params = status.params;
        logger.info((Object)"Check input computed-columns");
        for (int i = 0; i < params.virtualInputs.size(); ++i) {
            JoinRecipePayloadParams.InputDesc inputDesc = (JoinRecipePayloadParams.InputDesc)params.virtualInputs.get(i);
            if (inputDesc.computedColumns == null) continue;
            for (int j = 0; j < inputDesc.computedColumns.size(); ++j) {
                ComputedColumn compCol = (ComputedColumn)inputDesc.computedColumns.get(j);
                SelectQueryBuilder qb = new SelectQueryBuilder();
                SQLUtils.SQLTable table = helper.sqlTablesMap.get(inputDesc.name);
                qb.from(table, null);
                qb.select("*");
                qb = QueryGenerationUtils.computedColumns(qb, (List<ComputedColumn>)Lists.newArrayList((Object[])new ComputedColumn[]{compCol}), dialect, helper.datasetsMap.get(inputDesc.name).getSchema());
                String sql = qb.toSQL(dialect);
                try {
                    this.getExecutionPlan(authCtx, sources, status.getSelectedSQLBasedEngine(), sql, params.engineParams);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)("Input computed-column " + j + " from input " + i + " is invalid"), (Throwable)e);
                    status.inputComputedColumns.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_JOIN_INVALID_INPUT_COMPUTED, (String)ExceptionUtils.getMessageWithCauses((Throwable)e)).withPos(i, 0));
                    return true;
                }
            }
        }
        return false;
    }

    private boolean explainPostJoinComputedColumns(StatusInitializer init, JoinRecipeStatus status, JoinRecipeHelper helper, AuthCtx authCtx, List<Dataset> sources, boolean lowerCaseColumnsNames, String executionPlanErrMsg) {
        SQLDialect dialect = init.dialect;
        JoinRecipePayloadParams params = status.params;
        logger.info((Object)"Check computed columns");
        boolean errorFound = false;
        JoinRecipePayloadParams params2 = (JoinRecipePayloadParams)JSON.deepCopy((Object)params);
        params2.postFilter = null;
        for (JoinRecipePayloadParams.InputDesc input : params.virtualInputs) {
            input.preFilter = null;
        }
        try {
            params2.computedColumns = null;
            String sql = helper.generateSQLIgnorePartitioning_NT(authCtx, init.activity, dialect, params2, lowerCaseColumnsNames, JoinOutputRole.MAIN);
            this.getExecutionPlan(authCtx, sources, status.getSelectedSQLBasedEngine(), sql, params.engineParams);
            List<ComputedColumn> ccparams = params.computedColumns;
            for (int i = 0; i < ccparams.size(); ++i) {
                ComputedColumn ccp = ccparams.get(i);
                if (ccp == null) continue;
                params2.computedColumns = Lists.newArrayList((Object[])new ComputedColumn[]{ccp});
                try {
                    sql = helper.generateSQLIgnorePartitioning_NT(authCtx, init.activity, dialect, params2, lowerCaseColumnsNames, JoinOutputRole.MAIN);
                    this.getExecutionPlan(authCtx, sources, status.getSelectedSQLBasedEngine(), sql, params.engineParams);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"Invalid computed column", (Throwable)e);
                    status.computedColumns.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_JOIN_INVALID_COMPUTED, (String)this.formatDatabaseErrorMsg(executionPlanErrMsg, dialect)).withPos(i, 0));
                    errorFound = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return errorFound;
    }

    private List<String> checkVirtualInputs(StatusInitializer init, JoinRecipeStatus status, JoinRecipeHelper helper) throws Exception {
        JoinRecipePayloadParams params = status.params;
        SQLDialect dialect = init.dialect;
        Map<String, Dataset> datasetsMap = helper.datasetsMap;
        VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine = status.getSelectedSQLBasedEngine();
        ArrayList<String> preFilterSQLExpressions = new ArrayList<String>();
        for (int i = 0; i < params.virtualInputs.size(); ++i) {
            Dataset dataset;
            RecipeStatus.StepStatus fakeStatus;
            JoinRecipePayloadParams.InputDesc input = (JoinRecipePayloadParams.InputDesc)params.virtualInputs.get(i);
            FilterDesc filterDesc = input.preFilter;
            String filterExpression = null;
            List computedColumns = input.computedColumns;
            if (filterDesc != null && (filterDesc.enabled || filterDesc.distinct)) {
                if (status.preFilters == null) {
                    status.preFilters = new RecipeStatus.StepStatus();
                }
                fakeStatus = new RecipeStatus.StepStatus();
                dataset = datasetsMap.get(input.name);
                boolean translateFully = status.getSelectedSQLBasedEngine().queryBased && !status.getSelectedSQLBasedEngine().type.equals("DSS");
                filterExpression = this.visualRecipesService.checkFilter(filterDesc, dataset, dialect, fakeStatus, translateFully);
                if (fakeStatus.anyFatal()) {
                    status.preFilters.addMessage(fakeStatus.firstFatal().withPos(i, 0));
                }
            }
            preFilterSQLExpressions.add(filterExpression);
            if (computedColumns == null || computedColumns.isEmpty()) continue;
            if (status.inputComputedColumns == null) {
                status.inputComputedColumns = new RecipeStatus.StepStatus();
            }
            fakeStatus = new RecipeStatus.StepStatus();
            dataset = datasetsMap.get(input.name);
            boolean engineMustLowerColumnNames = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)params, selectedEngine);
            this.visualRecipesService.checkComputedColumns(computedColumns, dataset.getSchema(), selectedEngine, dialect, engineMustLowerColumnNames, fakeStatus);
            if (!fakeStatus.error) continue;
            for (InfoMessage im : fakeStatus.messages) {
                status.inputComputedColumns.addMessage(im.withPos(im.line.intValue(), i));
            }
        }
        return preFilterSQLExpressions;
    }

    void basicJoinsCheck(JoinRecipeStatus status, Map<String, Dataset> datasetsMap) {
        boolean hasRightUnmatchedOutput;
        JoinRecipePayloadParams params = status.params;
        boolean hasLeftUnmatchedOutput = !this.recipe.getOutputsForRole(JoinOutputRole.UNMATCHED_ROWS_LEFT.name).isEmpty();
        boolean bl = hasRightUnmatchedOutput = !this.recipe.getOutputsForRole(JoinOutputRole.UNMATCHED_ROWS_RIGHT.name).isEmpty();
        if ((hasLeftUnmatchedOutput || hasRightUnmatchedOutput) && params.joins.size() != 1) {
            status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Unmatched output only supports a single join");
        } else {
            if (hasLeftUnmatchedOutput && !JoinOutputRole.UNMATCHED_ROWS_LEFT.isCompatibleWithJoinType(((JoinRecipePayloadParams.JoinDesc)params.joins.get((int)0)).type)) {
                status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Left unmatched output used with incompatible join type " + String.valueOf((Object)((JoinRecipePayloadParams.JoinDesc)params.joins.get((int)0)).type));
            }
            if (hasRightUnmatchedOutput && !JoinOutputRole.UNMATCHED_ROWS_RIGHT.isCompatibleWithJoinType(((JoinRecipePayloadParams.JoinDesc)params.joins.get((int)0)).type)) {
                status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Right unmatched output used with incompatible join type " + String.valueOf((Object)((JoinRecipePayloadParams.JoinDesc)params.joins.get((int)0)).type));
            }
        }
        boolean usedCrossJoin = false;
        for (JoinRecipePayloadParams.JoinDesc join : params.joins) {
            JoinRecipePayloadParams.InputDesc input1 = (JoinRecipePayloadParams.InputDesc)params.virtualInputs.get(join.table1);
            JoinRecipePayloadParams.InputDesc input2 = (JoinRecipePayloadParams.InputDesc)params.virtualInputs.get(join.table2);
            usedCrossJoin = usedCrossJoin || join.type == JoinType.CROSS;
            Dataset ds1 = datasetsMap.get(input1.name);
            Dataset ds2 = datasetsMap.get(input2.name);
            if (ds1 == null) {
                status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Cannot retrieve dataset " + input1.name);
            }
            if (ds2 == null) {
                status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Cannot retrieve dataset " + input2.name);
            }
            if (ds1 == null || ds2 == null) continue;
            Schema schema1 = ds1.getSchema();
            Schema schema2 = ds2.getSchema();
            if (schema1 == null) {
                status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Cannot retrieve schema from dataset " + input1.name);
            }
            if (schema2 != null) continue;
            status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Cannot retrieve schema from dataset " + input2.name);
        }
        if (usedCrossJoin) {
            status.join.withWarning(RecipeCodes.WARN_RECIPE_JOIN_EXPENSIVE, "Cross join may result in a very large output");
        }
    }

    void checkLargeOutput(JoinRecipeStatus status, JoinRecipeHelper helper) {
        boolean joinMayGenerateNSquareRows = false;
        for (JoinRecipePayloadParams.JoinDesc join : status.params.joins) {
            boolean oneOfTheJoinConditionsIsEq = this.oneOfTheJoinConditionsIsEq(join);
            JoinRecipePayloadParams.InputDesc input1 = (JoinRecipePayloadParams.InputDesc)status.params.virtualInputs.get(join.table1);
            JoinRecipePayloadParams.InputDesc input2 = (JoinRecipePayloadParams.InputDesc)status.params.virtualInputs.get(join.table2);
            Dataset ds1 = helper.datasetsMap.get(input1.name);
            Dataset ds2 = helper.datasetsMap.get(input2.name);
            if (ds1 == null || ds2 == null) continue;
            Schema schema1 = ds1.getSchema();
            Schema schema2 = ds2.getSchema();
            for (JoinRecipePayloadParams.MatchingCondition condition : join.getJoinConditions()) {
                if (schema1 == null || schema2 == null) continue;
                joinMayGenerateNSquareRows = joinMayGenerateNSquareRows || this.checkJoinWithSchema(status, input1, schema1, input2, schema2, condition, oneOfTheJoinConditionsIsEq);
            }
        }
        if (joinMayGenerateNSquareRows) {
            status.join.withWarning(RecipeCodes.WARN_RECIPE_JOIN_EXPENSIVE, "Joining with condition 'INFERIOR', 'SUPERIOR' or 'DIFFERENT' may result in a very large output");
        }
    }

    private boolean oneOfTheJoinConditionsIsEq(JoinRecipePayloadParams.JoinDesc join) {
        return join.getJoinConditions().stream().map(condition -> condition.type).anyMatch(matchingType -> Objects.equals(matchingType, (Object)JoinRecipePayloadParams.MatchingType.EQ));
    }

    @VisibleForTesting
    boolean checkJoinWithSchema(JoinRecipeStatus status, JoinRecipePayloadParams.InputDesc input1, Schema schema1, JoinRecipePayloadParams.InputDesc input2, Schema schema2, JoinRecipePayloadParams.MatchingCondition condition, boolean oneOfTheJoinConditionsIsEq) {
        JoinRecipePayloadParams params = status.params;
        SchemaColumn sc1 = JoinLikeStatusUtils.getSchemaColumn(input1, schema1, condition.column1.name, status.join);
        SchemaColumn sc2 = JoinLikeStatusUtils.getSchemaColumn(input2, schema2, condition.column2.name, status.join);
        if (sc1 != null && sc2 != null) {
            Type type1 = sc1.getType();
            Type type2 = sc2.getType();
            if (!params.enableAutoCastInJoinConditions && JoinRecipePayloadParams.incompatibleTypesForJoinCondition(type1, type2)) {
                status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Cannot join columns '" + condition.column1.name + "' (" + String.valueOf(type1) + ") and '" + condition.column2.name + "' (" + String.valueOf(type2) + "). Fix the input dataset types (recommended) or enable auto cast");
            }
            return (condition.type == JoinRecipePayloadParams.MatchingType.LTE || condition.type == JoinRecipePayloadParams.MatchingType.LT || condition.type == JoinRecipePayloadParams.MatchingType.GTE || condition.type == JoinRecipePayloadParams.MatchingType.GT || condition.type == JoinRecipePayloadParams.MatchingType.NE) && !oneOfTheJoinConditionsIsEq;
        }
        return false;
    }

    @Override
    public JoinRecipeStatus getStatusForConversion_NT(AuthCtx authCtx) throws Exception {
        JoinRecipeStatus status;
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(init, authCtx);
            boolean lowerCase = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)status.params, status.getSelectedSQLBasedEngine());
            status.sql = init.helper.generateSQL(authCtx, init.activity, init.dialect, status.params, lowerCase, JoinOutputRole.MAIN);
        }
        return status;
    }

    private JoinRecipeStatus fastStatusIgnorePartitions(StatusInitializer init, AuthCtx authCtx) {
        JoinRecipeStatus status = new JoinRecipeStatus();
        try {
            this.performBasicStructureChecks(status, authCtx);
            init.activity = new JobActivity(this.recipesValidationService.getSampleSubgraph(new FlowRecipe(this.recipe)));
            init.helper = new JoinRecipeHelper();
            String dynamicPayload = null;
            if (this.payload.equals("{}")) {
                RecipesDAO recipesDAO = (RecipesDAO)SpringUtils.getBean(RecipesDAO.class);
                dynamicPayload = recipesDAO.getPayloadOrNull(this.recipe.projectKey, this.recipe.name);
            }
            status.params = init.helper.loadParams(dynamicPayload != null ? dynamicPayload : this.payload, this.recipe);
            status.engineParams = status.params.engineParams;
            this.recipesValidationService.checkComplianceWithRecipeDesc(authCtx, this.recipe);
            this.recipesValidationService.checkTargetsAreWritable(init.activity);
        }
        catch (Exception e) {
            logger.error((Object)"Invalid recipe", (Throwable)e);
            status.join.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
            return status;
        }
        try {
            init.sources = new ArrayList<Dataset>();
            for (FlowDataset fd : init.activity.getSubgraph().getSourceDatasets()) {
                init.sources.add(fd.getMandatoryUnsafe(this.datasetsDAO));
            }
            this.visualRecipesService.initEngines(authCtx, init.activity, status, this.recipe.projectKey);
            this.checkEngines(authCtx, status, status.params, init);
            RecipeEnginesPreferenceConfig repc = new RecipeConfigUtils().getResolvedPreferenceConfig(this.recipe.projectKey, this.recipe.type, status.params.enginesPreferences);
            this.visualRecipesService.selectEngine(authCtx, init.activity, status.params.engineType, status, this.recipe.type, repc);
            this.visualRecipesService.adjustEngineStatus(authCtx, init.activity, status, "Join in-database, then streaming of matches");
            this.checkEngine(authCtx, status.getSelectedSQLBasedEngine(), status, status.params, true, init);
            init.dialect = this.visualRecipesService.getDialect(authCtx, init.activity, status.getSelectedSQLBasedEngine());
            try {
                status.params.validateJoins();
            }
            catch (Exception e) {
                logger.error((Object)"Invalid join params", (Throwable)e);
                status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, ExceptionUtils.getMessageWithCauses((Throwable)e));
                return status;
            }
            try {
                boolean lowerCaseColumnsNames = status.params.engineParams.lowerCaseSchemaIfEngineRequiresIt && status.getSelectedSQLBasedEngine().lowercasesColumnNames();
                boolean caseInsensitive = lowerCaseColumnsNames || init.dialect != null && init.dialect.hasCaseInsensitiveColumns();
                boolean builtinEngine = status.selectedEngine != null && "DSS".equals(status.selectedEngine.type);
                init.helper.initInputDatasets(init.activity, status.params, builtinEngine, init.dialect, caseInsensitive);
                status.sql = init.helper.generateSQLIgnorePartitioning(authCtx, init.activity, init.dialect, status.params, lowerCaseColumnsNames, JoinOutputRole.MAIN);
                if (!this.recipe.getOutputsForRole(JoinOutputRole.UNMATCHED_ROWS_LEFT.name).isEmpty()) {
                    status.leftUnmatchedStatus.sql = init.helper.generateSQLIgnorePartitioning(authCtx, init.activity, init.dialect, status.params, lowerCaseColumnsNames, JoinOutputRole.UNMATCHED_ROWS_LEFT);
                }
                if (!this.recipe.getOutputsForRole(JoinOutputRole.UNMATCHED_ROWS_RIGHT.name).isEmpty()) {
                    status.rightUnmatchedStatus.sql = init.helper.generateSQLIgnorePartitioning(authCtx, init.activity, init.dialect, status.params, lowerCaseColumnsNames, JoinOutputRole.UNMATCHED_ROWS_RIGHT);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to generate SQL query", (Throwable)e);
                init.error = e.getMessage();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Invalid recipe", (Throwable)e);
            status.join.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        return status;
    }

    private void checkEngines(AuthCtx authCtx, JoinRecipeStatus status, JoinRecipePayloadParams params, StatusInitializer init) throws IOException, DKUSecurityException {
        for (VisualSQLRecipesBaseService.SQLBasedEngineStatus engine : status.getEngines()) {
            this.checkEngine(authCtx, engine, status, params, false, init);
        }
        this.performBasicCDEChecks(status, authCtx);
    }

    private void checkEngine(AuthCtx authCtx, VisualSQLRecipesBaseService.SQLBasedEngineStatus engine, JoinRecipeStatus status, JoinRecipePayloadParams params, boolean engineIsSelected, StatusInitializer init) {
        if (engine.isSelectable) {
            if (engine.type.equals("DSS")) {
                VisualSQLRecipesBaseService.h2ModeOn(engine, false, null, null);
                if (engineIsSelected) {
                    JoinLikeStatusUtils.warnIfExpectedEngineIsNotSelectable(init.sources, status.getEngines(), status.join);
                }
            }
            if (!engine.canNonEquiJoin) {
                for (JoinRecipePayloadParams.JoinDesc join : params.joins) {
                    for (Object condition : join.getJoinConditions()) {
                        if (((JoinRecipePayloadParams.MatchingCondition)condition).type == JoinRecipePayloadParams.MatchingType.EQ) continue;
                        String msg = "can only join with equality conditions";
                        engine.setStatus(msg, RecipeEngineStatus.WarningLevel.ERROR);
                        if (!engineIsSelected) continue;
                        status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, msg);
                    }
                }
            }
            if ("IMPALA".equals(engine.type)) {
                for (JoinRecipePayloadParams.JoinDesc join : params.joins) {
                    if (join.type != JoinType.FULL) continue;
                    if (join.conditionsMode == ConditionsMode.OR) {
                        if (join.getJoinConditions().size() == 1 && ((JoinRecipePayloadParams.MatchingCondition)join.getJoinConditions().get((int)0)).type == JoinRecipePayloadParams.MatchingType.EQ) continue;
                        String msg = "can only FULL OUTER join in OR mode with only one equalitiy condition";
                        engine.setStatus(msg, RecipeEngineStatus.WarningLevel.ERROR);
                        if (!engineIsSelected) continue;
                        status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, msg);
                        continue;
                    }
                    if (join.conditionsMode != ConditionsMode.AND) continue;
                    boolean hasEq = false;
                    for (JoinRecipePayloadParams.MatchingCondition condition : join.getJoinConditions()) {
                        if (condition.type != JoinRecipePayloadParams.MatchingType.EQ) continue;
                        hasEq = true;
                        break;
                    }
                    if (hasEq) continue;
                    String msg = "can only FULL OUTER join in AND mode with at least one equality condition";
                    engine.setStatus(msg, RecipeEngineStatus.WarningLevel.ERROR);
                    if (!engineIsSelected) continue;
                    status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, msg);
                }
            }
            JoinLikeStatusUtils.checkFullOuterJoinSupport(engine, engineIsSelected, params.joins, status.join);
            JoinLikeStatusUtils.checkJoinMatchDeduplication(engine, engineIsSelected, status.join, params.joins);
            if (engine.queryBased) {
                try {
                    boolean translateFully = !engine.type.equals("DSS");
                    SQLDialect dialect = this.visualRecipesService.getDialect(authCtx, init.activity, engine);
                    for (JoinRecipePayloadParams.InputDesc virtualInput : params.virtualInputs) {
                        if (virtualInput.preFilter == null || !virtualInput.preFilter.enabled) continue;
                        FilterDescUtils.getSQLExpression(virtualInput.preFilter, dialect, null, translateFully);
                    }
                    if (params.postFilter != null && params.postFilter.enabled) {
                        FilterDescUtils.getSQLExpression(params.postFilter, dialect, null, translateFully);
                    }
                }
                catch (Exception e) {
                    if (engine.type.equals("DSS")) {
                        RecipeEngineStatus.setErrorStatus("Recipe configuration is not supported: " + ExceptionUtils.getMessageWithCauses((Throwable)e), engine);
                    }
                    RecipeEngineStatus.setErrorStatus("Recipe cannot be translated to SQL: " + ExceptionUtils.getMessageWithCauses((Throwable)e), engine);
                }
            }
        }
    }

    public static List<Duplicate> getDuplicateColumns(List<ColumnDesc> selectedColumns, boolean caseInsensitive) {
        ArrayList<Duplicate> duplicates = new ArrayList<Duplicate>();
        for (int i = 0; i < selectedColumns.size(); ++i) {
            ColumnDesc col1 = selectedColumns.get(i);
            String colAlias = col1.alias;
            if (caseInsensitive) {
                colAlias = colAlias.toLowerCase();
            }
            for (int j = i + 1; j < selectedColumns.size(); ++j) {
                ColumnDesc col2 = selectedColumns.get(j);
                String otherColAlias = col2.alias;
                if (caseInsensitive) {
                    otherColAlias = otherColAlias.toLowerCase();
                }
                if (!otherColAlias.equals(colAlias)) continue;
                duplicates.add(new Duplicate(col1.table, col1.name, col2.table, col2.name));
            }
        }
        return duplicates;
    }

    private static class StatusInitializer {
        JoinRecipeHelper helper;
        List<Dataset> sources;
        SQLDialect dialect;
        public JobActivity activity;
        public String error;

        private StatusInitializer() {
        }
    }

    public static class JoinRecipeStatus
    extends VisualSQLRecipeStatus
    implements JoinLikeRecipeStatus {
        public Schema outputSchemaWithoutComputedColumns;
        RecipeStatus.StepStatus preFilters;
        RecipeStatus.StepStatus inputComputedColumns;
        RecipeStatus.StepStatus join = new RecipeStatus.StepStatus();
        ColumnsStepStatus selectedColumns = new ColumnsStepStatus();
        ColumnsStepStatus computedColumns;
        RecipeStatus.StepStatus postFilter;
        UnmatchedOutputStatus leftUnmatchedStatus = new UnmatchedOutputStatus();
        UnmatchedOutputStatus rightUnmatchedStatus = new UnmatchedOutputStatus();
        JoinRecipePayloadParams params;

        @Override
        public InfoMessage.InfoMessages gatherAllMessages() {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            ret.mergeFrom(this.topLevelMessages);
            ret.mergeFrom((InfoMessage.InfoMessages)this.output);
            ret.mergeFrom((InfoMessage.InfoMessages)this.preFilters);
            ret.mergeFrom((InfoMessage.InfoMessages)this.inputComputedColumns);
            ret.mergeFrom((InfoMessage.InfoMessages)this.join);
            ret.mergeFrom((InfoMessage.InfoMessages)this.selectedColumns);
            ret.mergeFrom((InfoMessage.InfoMessages)this.computedColumns);
            ret.mergeFrom((InfoMessage.InfoMessages)this.postFilter);
            return ret;
        }

        @Override
        public boolean isInvalid() {
            return this.gatherAllMessages().anyFatal();
        }

        @Override
        public void setOutputSchema(Schema schema) {
            this.outputSchema = schema;
        }

        @Override
        public ColumnsStepStatus getSelectedColumns() {
            return this.selectedColumns;
        }

        @Override
        public void initOutputSchema(AuthCtx authCtx, JobActivity activity, String payload) throws Exception {
            JoinRecipeSchemaComputer schemaComputer = new JoinRecipeSchemaComputer(authCtx, activity);
            schemaComputer.setPayload(payload);
            this.setOutputSchema(schemaComputer.getSchema(JoinOutputRole.MAIN));
            if (schemaComputer.hasOutput(JoinOutputRole.UNMATCHED_ROWS_LEFT)) {
                this.leftUnmatchedStatus.schema = schemaComputer.getSchema(JoinOutputRole.UNMATCHED_ROWS_LEFT);
            }
            if (schemaComputer.hasOutput(JoinOutputRole.UNMATCHED_ROWS_RIGHT)) {
                this.rightUnmatchedStatus.schema = schemaComputer.getSchema(JoinOutputRole.UNMATCHED_ROWS_RIGHT);
            }
            this.outputSchemaWithoutComputedColumns = schemaComputer.getMainSchemaWithoutComputedColumns();
        }
    }

    public static class UnmatchedOutputStatus {
        public String sql;
        public ExecutionPlanService.ExecutionPlan executionPlan;
        public Schema schema;
    }
}

