/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.joinlike;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeStatusComputer;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnDesc;
import com.dataiku.dip.dataflow.exec.joinlike.Duplicate;
import com.dataiku.dip.dataflow.exec.joinlike.JoinDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinLikeRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.joinlike.JoinLikeRecipeStatus;
import com.dataiku.dip.dataflow.exec.joinlike.JoinType;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Map;

public class JoinLikeStatusUtils {
    private static final DKULogger logger = DKULogger.getLogger((String)"com.dataiku.dip.dataflow.exec.joinlike");
    private final AuthCtx authCtx;
    private final TransactionService transactionService;

    public JoinLikeStatusUtils(AuthCtx authCtx, TransactionService transactionService) {
        this.authCtx = authCtx;
        this.transactionService = transactionService;
    }

    public void validateOutputSchema(JoinLikeRecipeStatus status, JoinLikeRecipePayloadParams<?, ?, ?> params, boolean caseInsensitive, String payload, JobActivity activity) {
        block14: {
            try {
                List<Duplicate> duplicates;
                params.validateSelectedColumns();
                if (!status.getSelectedColumns().anyFatal()) {
                    int[] selectedColumnsCounts = new int[params.getVirtualInputs().size()];
                    for (ColumnDesc cd : params.getSelectedColumns()) {
                        int n = cd.table;
                        selectedColumnsCounts[n] = selectedColumnsCounts[n] + 1;
                    }
                    for (int i = 0; i < params.getVirtualInputs().size(); ++i) {
                        if (selectedColumnsCounts[i] != 0 || !params.areInputColumnsSelectable(i)) continue;
                        String datasetName = ((JoinInputDescBase)params.getVirtualInputs().get((int)i)).name;
                        if (((JoinInputDescBase)params.getVirtualInputs().get((int)i)).outputColumnsSelectionMode == JoinInputDescBase.OutputColumnsSelectionMode.AUTO_NON_CONFLICTING) {
                            status.getSelectedColumns().withWarningV(RecipeCodes.WARN_RECIPE_JOIN_NO_SELECTED_COLUMN_IN_DATASET, "No column from '%s' was selected as they all conflicted. You may want to set a prefix to dedup columns", new Object[]{datasetName});
                            continue;
                        }
                        status.getSelectedColumns().withWarningV(RecipeCodes.WARN_RECIPE_JOIN_NO_SELECTED_COLUMN_IN_DATASET, "No column from '%s' is selected", new Object[]{datasetName});
                    }
                }
                if (!(duplicates = JoinRecipeStatusComputer.getDuplicateColumns(params.getSelectedColumns(), caseInsensitive)).isEmpty()) {
                    status.getSelectedColumns().duplicates = duplicates;
                    for (Duplicate dup : duplicates) {
                        logger.error((Object)"Duplicate column names");
                        status.getSelectedColumns().withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_SELECTED, "Duplicate column name: '" + dup.column1 + "'");
                    }
                    break block14;
                }
                try (Transaction t = this.transactionService.beginRead();){
                    status.initOutputSchema(this.authCtx, activity, payload);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Invalid selected columns", (Throwable)e);
                status.getSelectedColumns().withFatalV(RecipeCodes.ERR_RECIPE_JOIN_INVALID_SELECTED, "%s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
            }
        }
    }

    public static SchemaColumn getSchemaColumn(JoinInputDescBase input1, Schema schema1, String columnName, RecipeStatus.StepStatus status) {
        SchemaColumn sc1 = null;
        try {
            sc1 = ExpressionUtils.getSchemaColumn(columnName, schema1, input1.computedColumns);
        }
        catch (IllegalArgumentException e) {
            status.withFatalV(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Dataset " + input1.name + " has no column " + columnName, new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
        }
        return sc1;
    }

    @VisibleForTesting
    public static void basicJoinsCheck(RecipeStatus.StepStatus stepStatus, Map<String, Dataset> datasetsMap, List<? extends JoinDescBase<?>> joins, List<? extends JoinInputDescBase> virtualInputs) {
        boolean usedCrossJoin = false;
        for (JoinDescBase<?> join : joins) {
            JoinInputDescBase input1 = virtualInputs.get(join.table1);
            JoinInputDescBase input2 = virtualInputs.get(join.table2);
            usedCrossJoin = usedCrossJoin || join.type == JoinType.CROSS;
            Dataset ds1 = datasetsMap.get(input1.name);
            Dataset ds2 = datasetsMap.get(input2.name);
            if (ds1 == null) {
                stepStatus.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Cannot retrieve dataset " + input1.name);
            }
            if (ds2 == null) {
                stepStatus.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Cannot retrieve dataset " + input2.name);
            }
            if (ds1 == null || ds2 == null) continue;
            Schema schema1 = ds1.getSchema();
            Schema schema2 = ds2.getSchema();
            if (schema1 == null) {
                stepStatus.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Cannot retrieve schema from dataset " + input1.name);
            }
            if (schema2 != null) continue;
            stepStatus.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Cannot retrieve schema from dataset " + input2.name);
        }
        if (usedCrossJoin) {
            stepStatus.withWarning(RecipeCodes.WARN_RECIPE_JOIN_EXPENSIVE, "Cross join may result in a very large output");
        }
    }

    public static void warnIfExpectedEngineIsNotSelectable(List<Dataset> sources, List<VisualSQLRecipesBaseService.SQLBasedEngineStatus> engines, RecipeStatus.StepStatus status) {
        String expectedEngine = JoinLikeStatusUtils.getExpectedEngine(sources);
        String cannotUseHiveReason = null;
        String cannotUseImpalaReason = null;
        for (VisualSQLRecipesBaseService.SQLBasedEngineStatus engine : engines) {
            if (engine.isSelectable) continue;
            if ("HIVE".equals(engine.type)) {
                cannotUseHiveReason = engine.statusMessage;
                continue;
            }
            if ("IMPALA".equals(engine.type)) {
                cannotUseImpalaReason = engine.statusMessage;
                continue;
            }
            if (!"SQL".equals(expectedEngine) || !engine.type.equals(expectedEngine)) continue;
            status.withWarning(RecipeCodes.WARN_RECIPE_JOIN_NOT_IN_DATABASE, engine.statusMessage);
        }
        if ("HIVE".equals(expectedEngine) && cannotUseHiveReason != null && cannotUseImpalaReason != null) {
            status.withWarning(RecipeCodes.WARN_RECIPE_JOIN_NOT_IN_DATABASE, "Hive engine not available: " + cannotUseHiveReason);
            status.withWarning(RecipeCodes.WARN_RECIPE_JOIN_NOT_IN_DATABASE, "Impala engine not available: " + cannotUseImpalaReason);
        }
    }

    private static String getExpectedEngine(List<Dataset> sources) {
        String result = "DSS";
        for (Dataset dataset : sources) {
            if (DatasetInspector.isSQL(dataset)) {
                return "SQL";
            }
            if (!DatasetInspector.canHDFS(dataset)) continue;
            result = "HIVE";
        }
        return result;
    }

    public static void checkFullOuterJoinSupport(VisualSQLRecipesBaseService.SQLBasedEngineStatus engine, boolean engineIsSelected, List<? extends JoinDescBase<?>> joins, RecipeStatus.StepStatus status) {
        if (!engine.canFullOuterJoin) {
            for (JoinDescBase<?> join : joins) {
                if (join.type != JoinType.FULL) continue;
                String msg = "FULL OUTER join not supported";
                engine.setStatus(msg, RecipeEngineStatus.WarningLevel.ERROR);
                if (!engineIsSelected) continue;
                status.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, msg);
            }
        }
    }

    public static void checkJoinMatchDeduplication(VisualSQLRecipesBaseService.SQLBasedEngineStatus engine, boolean engineIsSelected, RecipeStatus.StepStatus status, List<? extends JoinDescBase<?>> joins) {
        if (!engine.canDeduplicateJoinMatches) {
            for (JoinDescBase<?> join : joins) {
                if (!join.hasImplicitOrExplicitRightLimit()) continue;
                String msg = "cannot deduplicate join matches";
                engine.setStatus(msg, RecipeEngineStatus.WarningLevel.ERROR);
                if (!engineIsSelected) continue;
                status.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, msg);
            }
        }
    }
}

