/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.pivot;

import com.dataiku.dip.dataflow.exec.pivot.ModalitySlugifier;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipePayloadParams;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;

public class ModalitySlugifiers {
    public static ModalitySlugifier getSlugifier(PivotRecipePayloadParams.ModalitySlugification slugification) {
        switch (slugification) {
            case NONE: {
                return new NoneSlugifier();
            }
            case SOFT_SLUGIFY: {
                return new RegexSlugifier("[\\p{Punct}\\p{Space}]");
            }
            case HARD_SLUGIFY: {
                return new RegexSlugifier("[^a-zA-Z0-9_\\-]");
            }
            case NUMBER: {
                return new NumberingSlugifier();
            }
        }
        throw new Error("unreachable : " + String.valueOf((Object)slugification));
    }

    private static class NoneSlugifier
    implements ModalitySlugifier {
        private NoneSlugifier() {
        }

        @Override
        public String slugify(String value) {
            return value;
        }
    }

    private static class RegexSlugifier
    implements ModalitySlugifier {
        private final Set<String> slugified = Sets.newHashSet();
        private final String pattern;

        public RegexSlugifier(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public String slugify(String value) {
            String slug = value.replaceAll(this.pattern, "_");
            int i = 0;
            while (this.slugified.contains(this.buildSuffixedSlug(slug, i))) {
                ++i;
            }
            String suffixedSlug = this.buildSuffixedSlug(slug, i);
            this.slugified.add(suffixedSlug);
            return suffixedSlug;
        }

        private String buildSuffixedSlug(String slug, int i) {
            return i == 0 ? slug : slug + i;
        }
    }

    private static class NumberingSlugifier
    implements ModalitySlugifier {
        private final Map<String, String> indexed = Maps.newHashMap();

        private NumberingSlugifier() {
        }

        @Override
        public String slugify(String value) {
            if (!this.indexed.containsKey(value)) {
                this.indexed.put(value, "modality_" + (this.indexed.size() + 1));
            }
            return this.indexed.get(value);
        }
    }
}

