/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sampling;

import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.SISORecipeExecutor;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.sampling.SamplingRecipeExecutor;
import com.dataiku.dip.dataflow.exec.sql.SQLGenerator;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import java.util.List;

public abstract class SQLBasedSamplingExecutor
extends SISORecipeExecutor
implements SamplingRecipeExecutor,
AbortableRecipeRunner {
    protected SQLGenerator sqlGenerator;
    private volatile boolean abortNotified;
    protected AbortableRecipeRunner runner;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sampling.sql.base");

    public SQLBasedSamplingExecutor(SQLGenerator sqlGenerator) {
        this.sqlGenerator = sqlGenerator;
    }

    @Override
    public void setFilter(FilterDesc filterDesc) {
    }

    @Override
    public void setSelection(StreamableDatasetSelection selection) {
    }

    @Override
    public List<FlowRunnable> getRunnables() {
        return Lists.newArrayList();
    }

    @Override
    public void run() throws Exception {
        if (this.abortNotified) {
            logger.info((Object)"Abort already notified, skipping run");
            return;
        }
        this.runner.run();
    }

    @Override
    public void notifyBeforeAborting() {
        this.abortNotified = true;
        AbortableRecipeRunner runner = this.runner;
        if (runner != null) {
            runner.notifyBeforeAborting();
        }
    }
}

