/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.DatabricksConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.sync.CloudBlobSupport;
import com.dataiku.dip.dataflow.exec.sync.FastPathDatasetTypeStraightener;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DatabricksSupport {
    private static Logger logger = Logger.getLogger((String)"dip.databricks.support");

    static void validateAzureConnection(AuthCtx authCtx, Dataset dataset) throws IOException, DKUSecurityException {
        AzureConnection azure = (AzureConnection)new FastPathDatasetTypeStraightener().getMandatoryConnectionUnsafeUnexpanded(authCtx, dataset, "Azure");
        if (StringUtils.isBlank((String)azure.params.storageAccount)) {
            throw new AzureBlobDatabricksImpossibleException("Missing storage account name on Azure Blob Storage");
        }
        switch (azure.params.authType) {
            case OAUTH2_APP: {
                if (StringUtils.isBlank((String)azure.params.appId)) {
                    throw new AzureBlobDatabricksImpossibleException("Missing app id  for Oauth2 on Azure Blob Storage");
                }
                if (azure.credentialsMode == DSSConnection.CredentialsMode.GLOBAL && StringUtils.isBlank((String)azure.params.appSecret)) {
                    throw new AzureBlobDatabricksImpossibleException("Missing app secret for Oauth2 on Azure Blob Storage (the OAuth2 Client can't be public)");
                }
                if (azure.credentialsMode != DSSConnection.CredentialsMode.PER_USER || !azure.useRemoteCredentialsProvider()) break;
                throw new AzureBlobDatabricksImpossibleException("Cannot use a private app for oauth2 when copying to Databricks");
            }
            case SHARED_KEY: {
                if (!StringUtils.isBlank((String)azure.params.accessKey)) break;
                throw new AzureBlobDatabricksImpossibleException("Missing access key for shared access on Azure Blob Storage");
            }
            case SAS: {
                if (!StringUtils.isBlank((String)azure.params.getSasTokenForFastPath())) break;
                throw new AzureBlobDatabricksImpossibleException("Missing SAS token for shared access on Azure Blob Storage");
            }
            default: {
                throw new AzureBlobDatabricksImpossibleException("Authentication on Azure Blob Storage not supported: " + String.valueOf((Object)azure.params.authType));
            }
        }
    }

    static void setAzureCredentials(AuthCtx authCtx, Statement stmt, AzureConnection azure) throws SQLException, DKUSecurityException, IOException {
        for (AbstractSQLConnection.CustomDatabaseProperty prop : azure.getHadoopConfigForAzureAccess(authCtx)) {
            String sqlSet = "SET `%s`= `%s`";
            String cmd = String.format(sqlSet, prop.name, prop.value);
            logger.info((Object)("Run command to setup credentials property " + prop.name + " -> " + (prop.secret ? "***" : prop.value)));
            stmt.execute(cmd);
        }
    }

    static void setS3Credentials(AuthCtx authCtx, Statement stmt, EC2Connection ec2, String bucket) throws SQLException, IOException, DKUSecurityException {
        for (AbstractSQLConnection.CustomDatabaseProperty prop : ec2.getHadoopConfigForS3Access(authCtx, bucket)) {
            String sqlSet = "SET `%s`= `%s`";
            String cmd = String.format(sqlSet, prop.name, prop.value);
            logger.info((Object)("Run command to setup credentials property " + prop.name + " -> " + (prop.secret ? "***" : prop.value)));
            stmt.execute(cmd);
        }
    }

    public static String generateFormat(CloudBlobSupport.CopyMode mode) {
        switch (mode.type) {
            case CSV: {
                return "CSV";
            }
            case PARQUET: {
                return "PARQUET";
            }
            case ORC: {
                return "ORC";
            }
            case AVRO: {
                return "AVRO";
            }
        }
        return "";
    }

    public static String generateFormatOption(CloudBlobSupport.CopyMode mode) {
        switch (mode.type) {
            case CSV: {
                return DatabricksSupport.generateFormatCSVOption(mode);
            }
            case PARQUET: {
                return DatabricksSupport.generateFormatParquetOption(mode);
            }
            case ORC: {
                return DatabricksSupport.generateFormatORCOption(mode);
            }
            case AVRO: {
                return DatabricksSupport.generateFormatAvroOption(mode);
            }
        }
        return "";
    }

    public static String quoteChar(char c2) {
        if (c2 == '\t') {
            return "\\t";
        }
        if (c2 == '\\') {
            return "\\\\";
        }
        if (c2 >= ' ' && c2 < '\u007f' && c2 != '\'') {
            return Character.toString(c2);
        }
        return String.format("\\%03o", c2);
    }

    public static String generateFormatCSVOption(CloudBlobSupport.CopyMode mode) {
        StringBuilder sb = new StringBuilder();
        if (mode.delimiter != '\u0000') {
            DatabricksSupport.addOption(sb, "delimiter", DatabricksSupport.quoteChar(mode.delimiter));
        }
        if (mode.writeHeader) {
            DatabricksSupport.addOption(sb, "header", "true");
        }
        if (mode.quote != '\u0000') {
            DatabricksSupport.addOption(sb, "quote", String.valueOf(mode.quote));
        }
        if (mode.escape != '\u0000') {
            DatabricksSupport.addOption(sb, "escape", DatabricksSupport.quoteChar(mode.escape));
        }
        if (mode.multiline) {
            DatabricksSupport.addOption(sb, "multiLine", String.valueOf(mode.multiline));
        }
        return sb.toString();
    }

    public static String generateFormatParquetOption(CloudBlobSupport.CopyMode mode) {
        StringBuilder sb = new StringBuilder();
        if (mode.parquetCompressionMethod != null) {
            DatabricksSupport.addOption(sb, "parquet.compression", mode.parquetCompressionMethod.name());
        }
        return sb.toString();
    }

    public static String generateFormatORCOption(CloudBlobSupport.CopyMode mode) {
        StringBuilder sb = new StringBuilder();
        if (mode.orcCompressionMethod != null) {
            DatabricksSupport.addOption(sb, "orc.compress", mode.orcCompressionMethod.name());
        }
        return sb.toString();
    }

    public static String generateFormatAvroOption(CloudBlobSupport.CopyMode mode) {
        StringBuilder sb = new StringBuilder();
        if (mode.avroCompressionMethod != null) {
            DatabricksSupport.addOption(sb, "avro.compress", mode.avroCompressionMethod.name());
        }
        return sb.toString();
    }

    private static void addOption(StringBuilder sb, String key, String value) {
        if (sb.length() > 0) {
            sb.append(",");
        }
        sb.append(" '").append(key).append("'='").append(value).append("'");
    }

    public static String getCatalog(SQLUtils.SQLTable inputTable, DatabricksConnection connection, String defaultValue) {
        if (StringUtils.isNotEmpty((String)connection.params.temporaryCatalog)) {
            return connection.params.temporaryCatalog;
        }
        if (StringUtils.isNotEmpty((String)inputTable.getCatalog())) {
            return inputTable.getCatalog();
        }
        if (StringUtils.isNotEmpty((String)connection.params.defaultCatalog)) {
            return connection.params.defaultCatalog;
        }
        return defaultValue;
    }

    public static String getSchema(SQLUtils.SQLTable inputTable, DatabricksConnection connection, String defaultValue) {
        if (StringUtils.isNotEmpty((String)connection.params.temporarySchema)) {
            return connection.params.temporarySchema;
        }
        if (StringUtils.isNotEmpty((String)inputTable.getSchemaNullIfBlank())) {
            return inputTable.getSchemaNullIfBlank();
        }
        if (StringUtils.isNotEmpty((String)connection.params.defaultSchema)) {
            return connection.params.defaultSchema;
        }
        return defaultValue;
    }

    public static class AzureBlobDatabricksImpossibleException
    extends CloudBlobSupport.CloudBlobToSQLImpossibleException {
        private static final long serialVersionUID = 1L;

        AzureBlobDatabricksImpossibleException(String message) {
            super(message);
        }
    }
}

