/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.DatabricksConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.sync.CloudBlobSupport;
import com.dataiku.dip.dataflow.exec.sync.CloudToDatabricks;
import com.dataiku.dip.dataflow.exec.sync.FastPathDatasetTypeStraightener;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.S3DatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class S3ToDatabricks
extends CloudToDatabricks<S3DatasetHandler> {
    @Autowired
    private PasswordEncryptionService symetricCryptoService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.s3todatabricks");

    public static void setCompatible(Dataset inputDS, Dataset outputDS, RecipeEngineStatus status) throws IOException, DKUSecurityException {
        DatasetHandler.DatasetMeta<?, ?> outputMeta = DatasetHandlerFactory.getMeta(outputDS);
        status.isSelectable = true;
        if (!new FastPathDatasetTypeStraightener().isEquivalentTo(inputDS, "S3")) {
            status.markAsNonSelectable("Input dataset is not in S3", RecipeEngineStatus.WarningLevel.ERROR);
            return;
        }
        if (outputMeta != BuiltinSQLDatasets.DATABRICKS_META) {
            status.markAsNonSelectable("Output dataset is not in Databricks", RecipeEngineStatus.WarningLevel.ERROR);
            return;
        }
        try {
            S3ToDatabricks.getCopyMode(inputDS);
        }
        catch (CloudBlobSupport.CloudBlobToSQLImpossibleException e) {
            status.markAsNonSelectable(e.getMessage(), RecipeEngineStatus.WarningLevel.ERROR);
        }
    }

    @Override
    void setUpCredentials(S3DatasetHandler blobHandler, SQLConnectionProvider.SQLConnectionData connData, Statement stmt) throws SQLException {
    }

    @Override
    String getRoot(S3DatasetHandler blobHandler) throws CodedException, IOException, DKUSecurityException {
        return blobHandler.getInformationalRootPath();
    }

    private void validateCredentials(EC2Connection.S3FastPathCredentials credentials) throws DKUSecurityException {
        if (StringUtils.isBlank((String)credentials.getAccessKey())) {
            throw new DKUSecurityException("No access key provided, authentication is not supported");
        }
        if (StringUtils.isBlank((String)credentials.getSecretKey())) {
            throw new DKUSecurityException("No secret key provided, authentication is not supported");
        }
        if (StringUtils.isBlank((String)credentials.getSessionToken())) {
            throw new DKUSecurityException("No session token provided, authentication is not supported");
        }
    }

    @Override
    CloudToDatabricks.DisplayableSQLChunk getCredentials(S3DatasetHandler blobDShandler, SQLConnectionProvider.SQLConnectionData connData) throws DKUSecurityException, IOException {
        EC2Connection ec2 = blobDShandler.getConnection();
        String bucket = blobDShandler.getBucket();
        String storageCredential = ((DatabricksConnection)connData.getConnection()).params.getStorageCredentials(bucket);
        if (storageCredential == null) {
            EC2Connection.S3FastPathCredentials s3Credentials = ec2.getS3CredentialsForFastPath(this.authCtx);
            this.validateCredentials(s3Credentials);
            return new CloudToDatabricks.DisplayableSQLChunk(String.format("WITH ( CREDENTIALS ( %s ) )", s3Credentials.getCredentialStringForDatabricks()), "WITH ( CREDENTIALS ( *** ) )");
        }
        if (StringUtils.isBlank((String)storageCredential)) {
            return new CloudToDatabricks.DisplayableSQLChunk("");
        }
        return new CloudToDatabricks.DisplayableSQLChunk(String.format("WITH ( CREDENTIAL `%s` )", storageCredential));
    }

    @Override
    public void run() throws Exception {
        try (AbstractSQLTableDatasetHandler vti = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build(this.authCtx, this.outputDS);
             S3DatasetHandler sdh = (S3DatasetHandler)new FastPathDatasetTypeStraightener().getDatasetHandler(this.authCtx, this.inputDS);){
            SQLConnectionProvider.SQLConnectionData connData = vti.getConnectionData();
            SQLUtils.SQLTable outputTable = vti.getResolvedTable();
            CloudBlobSupport.CopyMode copyMode = S3ToDatabricks.getCopyMode(this.inputDS);
            boolean isAppendMode = this.originalWriteMode == Output.WriteMode.APPEND;
            SQLConnectionProvider.SQLConnectionWrapper connection = vti.newConnection();
            try {
                SQLUtils.executePreWriteStatements(connData, connection, this.outputDS);
                this.prepareOutputTable(connection, connData);
                this.executeCopy(connData, connection, sdh, copyMode, this.outputDS, outputTable, isAppendMode);
                SQLUtils.executePostWriteStatements(connData, connection, this.outputDS);
                connection.close();
            }
            catch (Exception e) {
                logger.error((Object)"Databricks load failed", (Throwable)e);
                SQLUtils.unsafeRollbackAndClose(connection);
                throw e;
            }
        }
    }
}

