/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.topn;

import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.topn.AbstractTopNRecipeSQLlikeMultiRunnerExecutor;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipePayloadParams;
import com.dataiku.dip.dataflow.utils.FakeJobActivityBuilder;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.code.hive.HiveConfHelper;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.code.hive.HiveRecipeRunner;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.HiveSQLDialect;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class TopNRecipeHiveExecutor
extends AbstractTopNRecipeSQLlikeMultiRunnerExecutor {
    @Autowired
    protected JobAuthCtxService authCtxService;
    private static final HiveSQLDialect dialect = new HiveSQLDialect();
    private HiveRecipeMeta.HiveRecipeParams hiveParams;

    public TopNRecipeHiveExecutor(JobActivity activity, TopNRecipePayloadParams params, HiveRecipeMeta.HiveRecipeParams hiveParams) {
        super(activity, params);
        this.hiveParams = hiveParams;
    }

    @Override
    protected AbortableRecipeRunner getRunner(String outputDatasetFullName, String role) throws Exception {
        HiveRecipeRunnerCustom runner = new HiveRecipeRunnerCustom(FakeJobActivityBuilder.fakeJobActivity(this.activity).build(outputDatasetFullName), role);
        SpringUtils.getInstance().autowire((Object)runner);
        return runner;
    }

    private class HiveRecipeRunnerCustom
    extends HiveRecipeRunner {
        private String role;

        public HiveRecipeRunnerCustom(JobActivity activity, String role) {
            super(activity);
            this.role = role;
        }

        @Override
        protected String getSql() throws Exception {
            return TopNRecipeHiveExecutor.this.generateSQL(dialect, this.role);
        }

        @Override
        protected String getPreQueries() throws Exception {
            return TopNRecipeHiveExecutor.this.hiveParams.preQueries;
        }

        @Override
        protected HiveRecipeMeta.HiveExecutionEngine getExecutionEngine() throws Exception {
            return TopNRecipeHiveExecutor.this.hiveParams.executionEngine;
        }

        @Override
        protected boolean addDkuUdf() throws Exception {
            return TopNRecipeHiveExecutor.this.hiveParams.addDkuUdf;
        }

        @Override
        protected List<SimpleKeyValue> getExtraConf() throws IOException, DKUSecurityException {
            return new HiveConfHelper().getResolvedConf(TopNRecipeHiveExecutor.this.authCtxService.getAuthCtx(), TopNRecipeHiveExecutor.this.recipe.getModel().projectKey, TopNRecipeHiveExecutor.this.hiveParams);
        }

        @Override
        protected boolean canOverrideDatabase() {
            return false;
        }
    }
}

