/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.upsert;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbstractInitializedRunner;
import com.dataiku.dip.dataflow.exec.AbstractStagedThreadedBuiltinRunner;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.filter.GrelExpression;
import com.dataiku.dip.dataflow.exec.upsert.UpsertRecipePayloadParams;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.join.MergeJoiner;
import com.dataiku.dip.datalayer.sort.NumberedRow;
import com.dataiku.dip.datalayer.sort.Sorter;
import com.dataiku.dip.datalayer.sort.SpilledRowsStorage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public class UpsertRecipeBuiltinRunner
extends AbstractStagedThreadedBuiltinRunner {
    private volatile boolean stopped = false;
    private UpsertRecipePayloadParams params;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.upsert.builtin");

    public UpsertRecipeBuiltinRunner(JobActivity activity, UpsertRecipePayloadParams params) {
        super(activity);
        this.params = params;
    }

    @Override
    public void notifyBeforeAborting() {
        this.stopped = true;
    }

    @VisibleForTesting
    public UpsertStage makeStage(File tmpDir, Schema schema, ColumnFactory existingCf, RowInputStream existing, List<String> keyColumns) {
        return new UpsertStage(tmpDir, schema, existingCf, existing, keyColumns);
    }

    @Override
    public List<AbstractInitializedRunner.Output> prepareStages(File tempDirectory) throws Exception {
        assert (this.inputs.containsKey("main"));
        assert (!((List)this.inputs.get("main")).isEmpty());
        assert (this.outputs.containsKey("main"));
        assert (!((List)this.outputs.get("main")).isEmpty());
        AbstractInitializedRunner.Input source = (AbstractInitializedRunner.Input)((List)this.inputs.get("main")).get(0);
        AbstractInitializedRunner.Input target = (AbstractInitializedRunner.Input)((List)this.inputs.get("main")).get(1);
        AbstractInitializedRunner.Output temp = (AbstractInitializedRunner.Output)((List)this.outputs.get("main")).get(0);
        FlowDataset sourceFD = this.activity.getSubgraph().getSourceDataset(source.fullId);
        Dataset sourceDS = sourceFD.getMandatory(this.datasetsDAO);
        FlowDataset targetFD = this.activity.getSubgraph().getSourceDataset(target.fullId);
        Dataset targetDS = targetFD.getMandatory(this.datasetsDAO);
        GrelExpression preFilterExpression = FilterDescUtils.willFilter(this.params.preFilter) ? FilterDescUtils.getGrelFilterExpression(this.params.preFilter) : null;
        if (this.params.preFilter != null && this.params.preFilter.distinct) {
            this.stages.add(new AbstractStagedThreadedBuiltinRunner.KeepDistinctRowsThread(source.schema, new File(tempDirectory, "prefilter")));
        }
        if (preFilterExpression != null) {
            this.stages.add(new AbstractStagedThreadedBuiltinRunner.FilteringThread(preFilterExpression));
        }
        Schema schemaAfterComputedCols = new Schema(source.schema);
        if (this.params.computedColumns != null && !this.params.computedColumns.isEmpty()) {
            this.stages.add(new AbstractStagedThreadedBuiltinRunner.ComputedColumnsThread(this.params.computedColumns));
            for (ComputedColumn cc : this.params.computedColumns) {
                schemaAfterComputedCols.addColumn(cc.name, Type.forName((String)cc.type));
            }
        }
        UpsertStage upsertStage = new UpsertStage(tempDirectory, schemaAfterComputedCols, (ColumnFactory)target.cf, target.is, this.params.keys.stream().map(k -> k.column).collect(Collectors.toList()));
        this.stages.add(upsertStage);
        return Lists.newArrayList((Object[])new AbstractInitializedRunner.Output[]{temp});
    }

    public class UpsertStage
    extends AbstractStagedThreadedBuiltinRunner.ComputationStage {
        private ColumnFactory sourceCf;
        private RowInputStream source;
        private final File tmpDir;
        private final Schema schema;
        private final ColumnFactory targetCf;
        private final RowInputStream target;
        private final List<String> keyColumns;
        private ColumnFactory outputCf;
        private RowFactory outputRf;
        private ProcessorOutput output;
        private Throwable exception;

        private UpsertStage(File tmpDir, Schema schema, ColumnFactory existingCf, RowInputStream existing, List<String> keyColumns) {
            this.tmpDir = tmpDir;
            this.schema = schema;
            this.targetCf = existingCf;
            this.target = existing;
            this.keyColumns = keyColumns;
        }

        @Override
        public void setInputFactories(ColumnFactory cf, RowFactory rf, RowInputStream input) {
            this.sourceCf = cf;
            this.source = input;
        }

        @Override
        public void setOutputFactories(ColumnFactory cf, RowFactory rf, ProcessorOutput output) {
            this.outputCf = cf;
            this.outputRf = rf;
            this.output = output;
        }

        @Override
        public void run() {
            File folder = Files.createTempDir();
            System.out.println("spill to " + folder.getAbsolutePath());
            Sorter.MergeSortParams mergeSortParams = new Sorter.MergeSortParams(1000000L);
            try (SpilledRowsStorage sourceStorage = new SpilledRowsStorage(new File(this.tmpDir, "input-sorted"), SpilledRowsStorage.factoryColumnsOfSchema(this.sourceCf, this.schema), mergeSortParams);
                 SpilledRowsStorage targetStorage = new SpilledRowsStorage(new File(this.tmpDir, "existing-sorted"), SpilledRowsStorage.factoryColumnsOfSchema(this.targetCf, this.schema), mergeSortParams);){
                List specs = this.keyColumns.stream().map(c2 -> new Sorter.SortSpec((String)c2, true)).collect(Collectors.toList());
                MergeJoiner.JoinerSide sourceSide = new MergeJoiner.JoinerSide(this.schema, this.sourceCf, this.outputCf, this.outputRf);
                MergeJoiner.JoinerSide targetSide = new MergeJoiner.JoinerSide(this.schema, this.targetCf, this.outputCf, this.outputRf);
                sourceSide.specs = specs;
                targetSide.specs = specs;
                this.sortSide(sourceSide, sourceStorage, new MergeJoiner.RowInputRowStream(this.source));
                this.sortSide(targetSide, targetStorage, new MergeJoiner.RowInputRowStream(this.target));
                UpsertOutputStage outputStage = new UpsertOutputStage(this.output);
                MergeJoiner.Merger merger = new MergeJoiner.Merger(sourceSide, targetSide, true, true, outputStage);
                merger.iterateJoin();
                this.output.lastRowEmitted();
            }
            catch (Throwable e) {
                logger.error((Object)"Upsert stage failed", e);
                this.exception = e;
            }
        }

        private void sortSide(MergeJoiner.JoinerSide side, SpilledRowsStorage storage, MergeJoiner.RowStream is) throws Exception {
            side.sorter = new Sorter(side.specs, side.schema, side.inputCf, storage, side.outputRf, side.outputCf, UpsertRecipeBuiltinRunner.this.mergeSortParams);
            side.rowCount = 0;
            NumberedRow row = is.next();
            while (!UpsertRecipeBuiltinRunner.this.stopped && row != null) {
                side.sorter.emitRow(row.row);
                ++side.rowCount;
                row = is.next();
            }
            side.sorter.lastRowEmitted();
            storage.doneWriting();
            logger.info((Object)("Sort for side ready (" + side.rowCount + " rows), now iterating"));
        }

        @Override
        protected Throwable getException() {
            return this.exception;
        }

        public class UpsertOutputStage
        implements MergeJoiner.JoinerStage {
            private final ProcessorOutput output;

            UpsertOutputStage(ProcessorOutput output) {
                this.output = output;
            }

            @Override
            public void runJoin(MergeJoiner.RowStream left, MergeJoiner.RowStream right) throws Exception {
                if (left == null) {
                    MergeJoiner.UnicityProbingRowStream wrappedRight = new MergeJoiner.UnicityProbingRowStream(right);
                    if (wrappedRight.notUnique()) {
                        throw new IOException("Key unicity broken on right side");
                    }
                    NumberedRow row = wrappedRight.next();
                    while (row != null) {
                        this.output.emitRow(row.row);
                        row = wrappedRight.next();
                    }
                } else if (right == null) {
                    MergeJoiner.UnicityProbingRowStream wrappedLeft = new MergeJoiner.UnicityProbingRowStream(left);
                    if (wrappedLeft.notUnique()) {
                        throw new IOException("Key unicity broken on left side");
                    }
                    NumberedRow row = wrappedLeft.next();
                    while (row != null) {
                        this.output.emitRow(row.row);
                        row = wrappedLeft.next();
                    }
                } else {
                    MergeJoiner.UnicityProbingRowStream wrappedLeft = new MergeJoiner.UnicityProbingRowStream(left);
                    if (wrappedLeft.notUnique()) {
                        throw new IOException("Key unicity broken on left side");
                    }
                    NumberedRow row = wrappedLeft.next();
                    while (row != null) {
                        this.output.emitRow(row.row);
                        row = wrappedLeft.next();
                    }
                }
            }
        }
    }
}

