/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.vstack;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.vstack.VStackRecipeCreator;
import com.dataiku.dip.dataflow.exec.vstack.VStackRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.vstack.VStackRecipeRunner;
import com.dataiku.dip.dataflow.exec.vstack.VStackRecipeSchemaComputer;
import com.dataiku.dip.dataflow.exec.vstack.VStackRecipeStatusComputer;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.VStackRecipePipelineHelper;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.MetaWithContainerizablePayload;
import com.dataiku.dip.recipes.NoParams;
import com.dataiku.dip.recipes.ParamsWithContainerizable;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.DataLineageService;
import com.dataiku.dip.spark.InputDatasetsReadParams;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class VStackRecipeMeta
extends RecipeMeta
implements MetaWithContainerizablePayload {
    public static final VStackRecipeMeta META = new VStackRecipeMeta();

    @Override
    public Class<? extends RecipeParams> paramsClass() {
        return NoParams.class;
    }

    @Override
    public String getType() {
        return "vstack";
    }

    @Override
    public RecipeRunner buildRunner(JobActivity activity) {
        return new VStackRecipeRunner(activity);
    }

    @Override
    public RecipeMeta.OutputSchemaComputability getOutputSchemasComputability() {
        return RecipeMeta.OutputSchemaComputability.RELIABLE_STATIC;
    }

    @Override
    public RecipeSchemaComputer buildSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        return new VStackRecipeSchemaComputer(authCtx, activity);
    }

    @Override
    public RecipeCreator buildCreator(AuthCtx authCtx) {
        return new VStackRecipeCreator(authCtx, this);
    }

    @Override
    public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String payload) {
        return new VStackRecipeStatusComputer(recipe, payload);
    }

    @Override
    public RecipeDesc getRecipeDesc() {
        return this.getRecipeDesc("en");
    }

    @Override
    public RecipeDesc getRecipeDesc(String lang) {
        TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        RecipeDesc desc = RecipeDesc.newSisoDesc(ts.translateNoContext(lang, "RECIPE.STACK.NAME", "stack", new Object[0]), null);
        RecipeDesc.IORoleDef mainInput = desc.inputRoles.get(0);
        mainInput.arity = RecipeDesc.IOArity.NARY;
        mainInput.withEditable(true, false);
        mainInput.description = ts.translateNoContext(lang, "RECIPE.IO.INPUT_DATASETS_CAN_BE_ADDED", "Input datasets can be added/removed from the settings tab", new Object[0]);
        desc.isMultiEngine = true;
        return desc;
    }

    @Override
    public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
        return new RecipeMeta.RecipeCategoryFlags().withVisualSQL().withVisualRecipe();
    }

    @Override
    public boolean hasJsonPayload() {
        return true;
    }

    @Override
    public SparkOverrideConfig getSparkConf(SerializedRecipe sr, String payload) {
        VStackRecipePayloadParams params = (VStackRecipePayloadParams)JSON.parse((String)payload, VStackRecipePayloadParams.class);
        return params.engineParams.sparkSQL.sparkConfig;
    }

    @Override
    public String setSparkConf(SerializedRecipe sr, String payload, SparkOverrideConfig config) {
        VStackRecipePayloadParams params = (VStackRecipePayloadParams)JSON.parse((String)payload, VStackRecipePayloadParams.class);
        params.engineParams.sparkSQL.sparkConfig = config;
        return JSON.pretty((Object)params);
    }

    @Override
    public String setEngine(SerializedRecipe sr, String payload, String engine) {
        VStackRecipePayloadParams params = (VStackRecipePayloadParams)JSON.parse((String)payload, VStackRecipePayloadParams.class);
        params.engineType = engine;
        return JSON.pretty((Object)params);
    }

    @Override
    public String setImpalaMode(SerializedRecipe sr, String payload, boolean runInStreamMode) {
        VStackRecipePayloadParams params = (VStackRecipePayloadParams)JSON.parse((String)payload, VStackRecipePayloadParams.class);
        params.engineParams.impala.forceStreamMode = runInStreamMode;
        return JSON.pretty((Object)params);
    }

    @Override
    public HiveRecipeMeta.HiveExecutionEngine getHiveEngine(SerializedRecipe sr, String payload) {
        VStackRecipePayloadParams params = (VStackRecipePayloadParams)JSON.parse((String)payload, VStackRecipePayloadParams.class);
        return params.engineParams.hive.executionEngine;
    }

    @Override
    public String setHiveEngine(SerializedRecipe sr, String payload, HiveRecipeMeta.HiveExecutionEngine executionEngine) {
        VStackRecipePayloadParams params = (VStackRecipePayloadParams)JSON.parse((String)payload, VStackRecipePayloadParams.class);
        params.engineParams.hive.executionEngine = executionEngine;
        return JSON.pretty((Object)params);
    }

    @Override
    public String setSparkEngine(SerializedRecipe sr, String payload, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine) {
        VStackRecipePayloadParams params = (VStackRecipePayloadParams)JSON.parse((String)payload, VStackRecipePayloadParams.class);
        params.engineParams.sparkSQL.executionEngine = executionEngine;
        return JSON.pretty((Object)params);
    }

    @Override
    public InputDatasetsReadParams getInputDatasetsReadParams(SerializedRecipe sr, String payload) {
        return ((VStackRecipePayloadParams)JSON.parse((String)payload, VStackRecipePayloadParams.class)).engineParams.sparkSQL.readParams;
    }

    @Override
    public String setInputDatasetsReadParams(SerializedRecipe sr, String payload, InputDatasetsReadParams inputDatasetsReadParams) {
        VStackRecipePayloadParams params = (VStackRecipePayloadParams)JSON.parse((String)payload, VStackRecipePayloadParams.class);
        params.engineParams.sparkSQL.readParams = inputDatasetsReadParams;
        return JSON.pretty((Object)params);
    }

    @Override
    public RecipePipelineHelper buildPipelineHelper(SerializedRecipe recipe, String payload, RecipePipelineHelper.PipelineType pipelineType, AuthCtx authCtx, JobActivity jobActivity) {
        return new VStackRecipePipelineHelper(authCtx, recipe, payload, pipelineType, jobActivity);
    }

    @Override
    public RecipeLineage getRecipeLineage(DataLineageService.SerializedGraphNodes predecessors, DataLineageService.SerializedGraphNodes successors, String payload, AuthCtx authCtx, JobActivity activity, SerializedRecipe serializedRecipe) {
        Schema outputSchema;
        RecipeLineage recipeLineage = new RecipeLineage();
        if (predecessors.datasetsByFullName.isEmpty() || successors.datasetsByFullName.isEmpty()) {
            return recipeLineage;
        }
        Preconditions.checkArgument((successors.datasetsByFullName.size() == 1 ? 1 : 0) != 0, (Object)"Stack recipe can have only one output dataset");
        SerializedDataset outputDataset = successors.datasetsByFullName.values().stream().findFirst().get();
        VStackRecipeSchemaComputer schemaComputer = new VStackRecipeSchemaComputer(authCtx, activity);
        schemaComputer.setPayload(payload);
        VStackRecipePayloadParams vstackParams = schemaComputer.getParams();
        try {
            outputSchema = schemaComputer.getSchema();
        }
        catch (Exception e) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_DATA_LINEAGE_FAILED, "Stack Recipe: Failed to compute output schema", (Throwable)e);
        }
        switch (vstackParams.mode) {
            case UNION: 
            case INTERSECT: 
            case FROM_DATASET: 
            case FROM_INDEX: 
            case CUSTOM: {
                for (SerializedDataset predecessor : predecessors.datasetsByFullName.values()) {
                    Schema schema = predecessor.getSchema();
                    for (SchemaColumn column : schema.getColumns()) {
                        String columnName = column.getName();
                        if (!outputSchema.hasColumn(columnName)) continue;
                        recipeLineage.addRelation(columnName, columnName, predecessor, outputDataset);
                    }
                }
                break;
            }
            case REMAP: {
                if (vstackParams.selectedColumns == null) {
                    return recipeLineage;
                }
                int nSelectedColumns = vstackParams.selectedColumns.size();
                for (int i = 0; i < nSelectedColumns; ++i) {
                    String outputColumnName = vstackParams.selectedColumns.get(i);
                    if (!outputSchema.hasColumn(outputColumnName)) continue;
                    for (VStackRecipePayloadParams.InputDesc inputDesc : vstackParams.virtualInputs) {
                        String inputDatasetName = inputDesc.name;
                        SerializedDataset inputDataset = this.getSerializedDataset(predecessors.datasetsByFullName, inputDatasetName);
                        try {
                            List<String> columnsMatch = ((VStackRecipePayloadParams.InputDesc)vstackParams.virtualInputs.get((int)inputDesc.index)).columnsMatch;
                            String inputColumnName = columnsMatch.get(i);
                            if (!StringUtils.isNotBlank((String)inputColumnName)) continue;
                            recipeLineage.addRelation(inputColumnName, outputColumnName, inputDataset, outputDataset);
                        }
                        catch (Exception e) {
                            throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_DATA_LINEAGE_FAILED, "Stack Recipe: No column found in dataset " + inputDatasetName + "at index " + i, (Throwable)e);
                        }
                    }
                }
                break;
            }
        }
        recipeLineage.keepValidRelations();
        return recipeLineage;
    }

    @Override
    public ContainerExecSelection getContainerExecSelection(SerializedRecipe sr, String payload) {
        VStackRecipePayloadParams params = (VStackRecipePayloadParams)JSON.parse((String)payload, VStackRecipePayloadParams.class);
        return params.getContainerSelection();
    }

    @Override
    public Class<? extends ParamsWithContainerizable> getContainerizableBearingParamsClass() {
        return VStackRecipePayloadParams.class;
    }
}

