/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graph.utils;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.Zone;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graph.utils.GraphSerializerCommon;
import com.dataiku.dip.datalineage.ColumnRelation;
import com.dataiku.dip.datalineage.LineageState;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.DataLineageService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.j2ts.annotations.UIModel;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.fishtank.css.selectors.NodeSelectorException;
import se.fishtank.css.selectors.dom.DOMNodeSelector;

public class DataLineageSerializer
extends GraphSerializerCommon {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private DataLineageService dataLineageService;
    private static final int SHORT_DESC_MAX_SIZE = 140;
    private final String contextProjectKey;
    private final String projectKey;
    private final String datasetName;
    private final String column;
    private final boolean useHardMax;
    private final AuthCtx authCtx;
    private final Template datasetNodeTemplate;
    private final StringBuilder graphvizBodyStringBuilder = new StringBuilder();

    public DataLineageSerializer(String contextProjectKey, DatasetLocUtils.DatasetLoc datasetLoc, String column, boolean useHardMax, AuthCtx authCtx) throws IOException {
        SpringUtils.getInstance().autowire((Object)this);
        this.contextProjectKey = contextProjectKey;
        this.projectKey = datasetLoc.getProjectKey();
        this.datasetName = datasetLoc.getName();
        this.column = column;
        this.useHardMax = useHardMax;
        this.authCtx = authCtx;
        Configuration freemarkerConfig = new Configuration(Configuration.VERSION_2_3_30);
        File datasetNodeTemplateFile = DKUApp.getResourceFile((String[])new String[]{"data-lineage", "dataset-graphviz-node.ftl"});
        String datasetNodeTemplateContent = FileUtils.readFileToString((File)datasetNodeTemplateFile, (Charset)StandardCharsets.UTF_8);
        this.datasetNodeTemplate = new Template("datasetGraphvizNode", (Reader)new StringReader(datasetNodeTemplateContent), freemarkerConfig);
    }

    @Override
    protected String getCacheKeyPrefix() {
        return this.contextProjectKey + "_" + this.projectKey + "_" + this.datasetName + "_" + this.column;
    }

    @Override
    protected void cleanupEdge(Node edgeNode) {
        if (!(edgeNode instanceof Element)) {
            return;
        }
        Element edgeNodeElement = (Element)edgeNode;
        String nodeId = edgeNodeElement.getAttribute("id");
        if (nodeId.isEmpty()) {
            return;
        }
        DataLineageEdgeRemapping edgeRemapping = (DataLineageEdgeRemapping)this.labelsRemapping.get(Integer.parseInt(nodeId));
        edgeNodeElement.setAttribute("data-from", edgeRemapping.from);
        edgeNodeElement.setAttribute("data-to", edgeRemapping.to);
        edgeNodeElement.setAttribute("data-from-column", edgeRemapping.fromColumn);
        edgeNodeElement.setAttribute("data-to-column", edgeRemapping.toColumn);
        if (StringUtils.isNotEmpty((String)edgeRemapping.type)) {
            edgeNodeElement.setAttribute("data-type", edgeRemapping.type);
        }
    }

    @Override
    protected void cleanupEdgePath(Node edgeNodePath) {
        if (!(edgeNodePath instanceof Element)) {
            return;
        }
        Element pathNodeElement = (Element)edgeNodePath;
        String previousPath = pathNodeElement.getAttribute("d");
        String[] pathParts = previousPath.substring(1).split("C");
        String[] mPartCoords = pathParts[0].split(",");
        Double x1 = Double.parseDouble(mPartCoords[0]);
        Double y1 = Double.parseDouble(mPartCoords[1]);
        String[] cPartPoints = pathParts[1].split(" ");
        String[] cLastPointCoords = cPartPoints[cPartPoints.length - 1].split(",");
        Double x2 = Double.parseDouble(cLastPointCoords[0]);
        Double y2 = Double.parseDouble(cLastPointCoords[1]);
        Double xMiddle = (x1 + x2) / 2.0;
        String newPath = String.format("M%s,%sC%s,%s %s,%s %s,%s", x1, y1, xMiddle, y1, xMiddle, y2, x2, y2);
        pathNodeElement.setAttribute("d", newPath);
    }

    @Override
    protected void cleanupNodeText(Node nodeTextNode, String id, boolean replaceTextContent) throws NodeSelectorException {
        super.cleanupNodeText(nodeTextNode, id, replaceTextContent);
        DOMNodeSelector selector = new DOMNodeSelector(nodeTextNode.getParentNode());
        for (Node childNode : selector.querySelectorAll("text")) {
            childNode.setTextContent(DataLineageSerializer.graphVizUnescape(childNode.getTextContent()));
        }
    }

    public Callable<SerializedGraph> serialize_NT() throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        SerializedGraph serializedGraph = new SerializedGraph();
        int maxDatasetCount = this.useHardMax ? DataLineageService.getNbDatasetsHardMax() : DataLineageService.getNbDatasetsSoftMax();
        DataLineageService.GraphNodes graphNodes = this.dataLineageService.getGraphNodes_NT(this.authCtx, this.contextProjectKey, this.projectKey, this.datasetName, this.column, maxDatasetCount);
        serializedGraph.maxNbDatasets = graphNodes.maxNbDatasets;
        serializedGraph.nbDatasets = graphNodes.flowDatasetsByFullId.size();
        HashSet flowDatasetsFullIds = new HashSet();
        ArrayList flowDatasets = new ArrayList();
        ArrayList flowRecipes = new ArrayList();
        graphNodes.flowRecipeByFullId.values().stream().map(nodeWithZone -> (FlowRecipe)nodeWithZone.node).sorted(Comparator.comparing(GraphNode::getFullId)).forEach(flowRecipe -> {
            flowRecipes.add(flowRecipe);
            List<FlowComputable> targets = flowRecipe.getTargets().stream().filter(FlowDataset.class::isInstance).toList();
            for (FlowComputable target : targets) {
                FlowDataset targetFlowDataset = (FlowDataset)target;
                String targetFullId = targetFlowDataset.getFullId();
                if (!graphNodes.flowDatasetsByFullId.containsKey(targetFullId)) continue;
                flowDatasets.add(targetFlowDataset);
                flowDatasetsFullIds.add(targetFullId);
            }
        });
        graphNodes.flowDatasetsByFullId.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            String fullId = (String)entry.getKey();
            FlowDataset flowDataset = (FlowDataset)((DataLineageService.EnrichedGraphNode)entry.getValue()).node;
            if (flowDatasetsFullIds.contains(fullId)) {
                return;
            }
            flowDatasets.add(flowDataset);
        });
        try (Transaction t = this.transactionService.beginRead();){
            for (FlowDataset flowDataset : flowDatasets) {
                SerializedNode datasetNode = this.computeNodeForDataset(flowDataset, graphNodes);
                if (datasetNode == null) continue;
                serializedGraph.nodes.put(datasetNode.id, datasetNode);
            }
        }
        for (FlowRecipe flowRecipe2 : flowRecipes) {
            this.serializeFlowRecipe(serializedGraph, flowRecipe2, graphNodes.lineageStateByRecipeFullId);
        }
        this.serializeColumnRelations(serializedGraph, graphNodes);
        String graphviz = "digraph g {\n    rankdir=LR;    splines=line;    nodesep=.9;    ranksep=1.5;    outputorder=edgesfirst;    ordering=in;\n\n" + String.valueOf(this.graphvizBodyStringBuilder) + "\n}\n";
        return () -> {
            TransactionContext.assertNoAttachedTransaction();
            serializedGraph.svg = this.cleanSVGCache(graphviz, "dot", false, true);
            return serializedGraph;
        };
    }

    private void serializeFlowRecipe(SerializedGraph serializedGraph, FlowRecipe flowRecipe, Map<String, LineageState> lineageStateByRecipeFullId) {
        SerializedNode datasetNode;
        SerializedNode recipeNode = this.computeNodeForRecipe(flowRecipe, lineageStateByRecipeFullId, serializedGraph.nodes.keySet());
        if (recipeNode.predecessors.isEmpty() || recipeNode.successors.isEmpty()) {
            return;
        }
        for (String srcId : recipeNode.predecessors) {
            datasetNode = serializedGraph.nodes.get(srcId);
            this.addRecipeConnection(datasetNode, recipeNode);
        }
        for (String targetId : recipeNode.successors) {
            datasetNode = serializedGraph.nodes.get(targetId);
            this.addRecipeConnection(recipeNode, datasetNode);
        }
        serializedGraph.nodes.put(recipeNode.id, recipeNode);
    }

    private SerializedNode computeNodeForRecipe(FlowRecipe recipe, Map<String, LineageState> lineageStateByRecipeFullId, Set<String> serializedNodeIds) {
        AnyLoc loc = AnyLoc.resolveFull(recipe.getFullId());
        SerializedNode recipeNode = new SerializedNode();
        recipeNode.nodeType = NodeType.RECIPE;
        recipeNode.id = DataLineageSerializer.recipeGraphId(recipe);
        recipeNode.projectKey = recipe.getProjectKey();
        recipeNode.name = recipe.getName();
        recipeNode.smartName = loc.getSmartName(this.contextProjectKey);
        recipeNode.description = recipe.getName();
        recipeNode.shortDesc = StringUtils.isNotBlank((String)recipe.getModel().shortDesc) ? StringUtils.substring((String)recipe.getModel().shortDesc, (int)0, (int)140) : null;
        recipeNode.recipeType = recipe.getModel().type;
        recipeNode.predecessors.addAll(recipe.getPredecessors().stream().filter(FlowDataset.class::isInstance).map(node -> DataLineageSerializer.datasetGraphId((FlowDataset)node)).filter(serializedNodeIds::contains).collect(Collectors.toSet()));
        recipeNode.successors.addAll(recipe.getSuccessors().stream().filter(FlowDataset.class::isInstance).map(node -> DataLineageSerializer.datasetGraphId((FlowDataset)node)).filter(serializedNodeIds::contains).collect(Collectors.toSet()));
        recipeNode.lineageState = lineageStateByRecipeFullId.getOrDefault(recipe.getFullId(), LineageState.UNCERTAIN);
        int idx = this.labelsRemapping.size();
        GraphSerializerCommon.NodeRemapping nr = new GraphSerializerCommon.NodeRemapping();
        nr.id = recipeNode.id;
        nr.name = recipeNode.name;
        nr.label = recipeNode.name;
        nr.description = recipeNode.description;
        nr.type = "RECIPE";
        this.labelsRemapping.add(nr);
        String nodeWidth = "0.7";
        String nodeHeight = "0.7";
        this.graphvizBodyStringBuilder.append(String.format("%s [id=\"%d\", shape=circle, fixedsize=true, width=%s, height=%s, label=\"%s\"];%n", recipeNode.id, idx, nodeWidth, nodeHeight, recipeNode.id));
        return recipeNode;
    }

    private SerializedNode computeNodeForDataset(FlowDataset flowDataset, DataLineageService.GraphNodes graphNodes) throws IOException, TemplateException {
        SerializedDataset serializedDataset = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(AnyLoc.resolveFull(flowDataset.getFullId()));
        if (serializedDataset == null) {
            return null;
        }
        String fullId = serializedDataset.getFullId();
        DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(fullId);
        SerializedNode datasetNode = new SerializedNode();
        String datasetProjectKey = loc.getProjectKey();
        String datasetProjectName = this.projectsService.getMandatoryUnsafe((String)datasetProjectKey).name;
        datasetNode.nodeType = NodeType.DATASET;
        datasetNode.id = DataLineageSerializer.datasetGraphId(fullId);
        datasetNode.projectKey = datasetProjectKey;
        datasetNode.name = serializedDataset.name;
        datasetNode.smartName = loc.getSmartName(this.contextProjectKey);
        DataLineageService.EnrichedGraphNode<FlowDataset> datasetWithZoneAndExposed = graphNodes.flowDatasetsByFullId.get(fullId);
        Zone zone = datasetWithZoneAndExposed.zone;
        if (zone != null) {
            datasetNode.flowZoneId = zone.getId();
            datasetNode.flowZoneName = zone.getName();
            datasetNode.flowZoneColor = zone.getColor();
        }
        datasetNode.isExposed = datasetWithZoneAndExposed.isExposed;
        List<FlowRecipe> predecessorFlowRecipes = graphNodes.flowRecipeByFullId.values().stream().map(nodeWithZone -> (FlowRecipe)nodeWithZone.node).filter(flowRecipe -> flowRecipe.getTargetsMap().containsKey(fullId)).toList();
        List<FlowRecipe> successorFlowRecipes = graphNodes.flowRecipeByFullId.values().stream().map(nodeWithZone -> (FlowRecipe)nodeWithZone.node).filter(flowRecipe -> flowRecipe.getSourcesMap().containsKey(fullId)).toList();
        datasetNode.predecessors.addAll(predecessorFlowRecipes.stream().map(DataLineageSerializer::recipeGraphId).collect(Collectors.toSet()));
        datasetNode.successors.addAll(successorFlowRecipes.stream().map(DataLineageSerializer::recipeGraphId).collect(Collectors.toSet()));
        datasetNode.predecessors.addAll(predecessorFlowRecipes.stream().map(GraphNode::getPredecessors).flatMap(Collection::stream).filter(FlowDataset.class::isInstance).map(node -> DataLineageSerializer.datasetGraphId((FlowDataset)node)).collect(Collectors.toSet()));
        datasetNode.successors.addAll(successorFlowRecipes.stream().map(GraphNode::getSuccessors).flatMap(Collection::stream).filter(FlowDataset.class::isInstance).map(node -> DataLineageSerializer.datasetGraphId((FlowDataset)node)).collect(Collectors.toSet()));
        Set highlightedColumns = graphNodes.columnRelations.stream().flatMap(columnRelation -> {
            if (columnRelation.outputDataset.equals(fullId)) {
                return Stream.of(columnRelation.outputColumn);
            }
            if (columnRelation.inputDataset.equals(fullId)) {
                return Stream.of(columnRelation.inputColumn);
            }
            return Stream.empty();
        }).collect(Collectors.toSet());
        Schema schema = serializedDataset.getSchema();
        datasetNode.nTotalColumns = schema.columns.size();
        datasetNode.selectedColumns.addAll(schema.columns.stream().map(SchemaColumn::getName).filter(schemaColumn -> {
            boolean isBaseDataset = this.projectKey.equals(datasetNode.projectKey) && this.datasetName.equals(datasetNode.name);
            return highlightedColumns.contains(schemaColumn) || isBaseDataset && this.column.equals(schemaColumn);
        }).toList());
        datasetNode.description = loc.getSmartName(datasetProjectKey);
        datasetNode.shortDesc = StringUtils.isNotBlank((String)serializedDataset.shortDesc) ? StringUtils.substring((String)serializedDataset.shortDesc, (int)0, (int)140) : null;
        datasetNode.datasetType = serializedDataset.type;
        int idx = this.labelsRemapping.size();
        GraphSerializerCommon.NodeRemapping nr = new GraphSerializerCommon.NodeRemapping();
        nr.id = datasetNode.id;
        nr.name = datasetNode.name;
        nr.label = datasetNode.name;
        nr.type = String.valueOf((Object)datasetNode.nodeType);
        nr.description = datasetNode.description;
        this.labelsRemapping.add(nr);
        List<Column> datasetColumns = datasetNode.selectedColumns.stream().map(arg_0 -> ((Schema)schema).getColumn(arg_0)).map(schemaColumn -> new Column(schemaColumn.getName(), schemaColumn.getType().getName())).toList();
        HashMap<String, Object> templateVariables = new HashMap<String, Object>();
        templateVariables.put("datasetProjectName", DataLineageSerializer.graphVizEscape(datasetProjectName));
        if (StringUtils.isNotBlank((String)datasetNode.flowZoneName)) {
            templateVariables.put("datasetFlowZoneName", DataLineageSerializer.graphVizEscape(datasetNode.flowZoneName));
        }
        String escapedDatasetName = DataLineageSerializer.graphVizEscape(datasetNode.name);
        templateVariables.put("datasetName", escapedDatasetName);
        templateVariables.put("datasetNameHeaderHeight", escapedDatasetName.length() > 37 ? 60 : 40);
        templateVariables.put("nColumns", schema.getColumns().size());
        templateVariables.put("columns", datasetColumns);
        StringWriter swr = new StringWriter();
        this.datasetNodeTemplate.process(templateVariables, (Writer)swr);
        String graphvizDatasetLabel = swr.toString();
        this.graphvizBodyStringBuilder.append(String.format("%s [id=\"%d\", shape=none, label=<%s>];%n", datasetNode.id, idx, graphvizDatasetLabel));
        return datasetNode;
    }

    private void serializeColumnRelations(SerializedGraph serializedGraph, DataLineageService.GraphNodes graphNodes) {
        for (ColumnRelation columnRelation : graphNodes.columnRelations) {
            String inputColumnName = columnRelation.inputColumn;
            String inputDataset = DataLineageSerializer.datasetGraphId(columnRelation.inputDataset);
            String outputColumnName = columnRelation.outputColumn;
            String outputDataset = DataLineageSerializer.datasetGraphId(columnRelation.outputDataset);
            SerializedColumnRelation serializedColumnRelation = new SerializedColumnRelation();
            if (!serializedGraph.nodes.containsKey(inputDataset) || !serializedGraph.nodes.containsKey(outputDataset)) continue;
            serializedColumnRelation.inNodeId = serializedGraph.nodes.get((Object)inputDataset).id;
            serializedColumnRelation.inputColumnName = inputColumnName;
            serializedColumnRelation.outNodeId = serializedGraph.nodes.get((Object)outputDataset).id;
            serializedColumnRelation.outputColumnName = outputColumnName;
            serializedGraph.columnRelations.add(serializedColumnRelation);
            this.addColumnConnection(serializedColumnRelation);
        }
    }

    private void addRecipeConnection(SerializedNode inNode, SerializedNode outNode) {
        String outputConnectionPort;
        String inputConnectionPort;
        int idx = this.labelsRemapping.size();
        DataLineageEdgeRemapping er = new DataLineageEdgeRemapping();
        er.from = inNode.id;
        er.to = outNode.id;
        this.labelsRemapping.add(er);
        if (NodeType.RECIPE.equals((Object)inNode.nodeType)) {
            inputConnectionPort = String.format("%s:e", inNode.id);
            outputConnectionPort = String.format("%s:header:w", outNode.id);
        } else {
            inputConnectionPort = String.format("%s:header:e", inNode.id);
            outputConnectionPort = String.format("%s:w", outNode.id);
        }
        this.graphvizBodyStringBuilder.append(String.format("%s -> %s [arrowhead=dot, arrowsize=0.5, id=\"%s\", weight=1];%n", inputConnectionPort, outputConnectionPort, idx));
    }

    private void addColumnConnection(SerializedColumnRelation serializedColumnRelation) {
        String inNodeId = serializedColumnRelation.inNodeId;
        String outNodeId = serializedColumnRelation.outNodeId;
        String inColumnName = DataLineageSerializer.graphVizEscape(serializedColumnRelation.inputColumnName);
        String outColumnName = DataLineageSerializer.graphVizEscape(serializedColumnRelation.outputColumnName);
        int idx = this.labelsRemapping.size();
        DataLineageEdgeRemapping er = new DataLineageEdgeRemapping();
        er.from = inNodeId;
        er.to = outNodeId;
        er.fromColumn = serializedColumnRelation.inputColumnName;
        er.toColumn = serializedColumnRelation.outputColumnName;
        er.type = "column-relation";
        this.labelsRemapping.add(er);
        String inputConnectionPort = String.format("%s:port%sOut:e", inNodeId, inColumnName);
        String outputConnectionPort = String.format("%s:port%sIn:w", outNodeId, outColumnName);
        this.graphvizBodyStringBuilder.append(String.format("%s -> %s [arrowhead=none, arrowsize=0.5, id=\"%s\", weight=0];%n", inputConnectionPort, outputConnectionPort, idx));
    }

    private static String datasetGraphId(FlowDataset node) {
        return DataLineageSerializer.datasetGraphId(node.getFullName());
    }

    private static String datasetGraphId(String fullName) {
        return GraphIds.forDataset(fullName);
    }

    private static String recipeGraphId(FlowRecipe recipe) {
        return GraphIds.forRecipe(recipe.getProjectKey() + "." + recipe.getName());
    }

    protected static class DataLineageEdgeRemapping
    extends GraphSerializerCommon.EdgeRemapping {
        String type;
        String fromColumn;
        String toColumn;

        protected DataLineageEdgeRemapping() {
        }
    }

    @UIModel
    public static class SerializedGraph {
        public String svg = "";
        public Map<String, SerializedNode> nodes = new HashMap<String, SerializedNode>();
        public Set<SerializedColumnRelation> columnRelations = new HashSet<SerializedColumnRelation>();
        public int nbDatasets;
        public int maxNbDatasets;
    }

    public static class SerializedNode {
        public NodeType nodeType;
        public String id;
        public String projectKey;
        public String flowZoneId;
        public String flowZoneName;
        public String flowZoneColor;
        public String name;
        public String smartName;
        public String description;
        public String shortDesc;
        public String datasetType;
        public String recipeType;
        public boolean isExposed = false;
        public LineageState lineageState;
        public int nTotalColumns = 0;
        public List<String> selectedColumns = new ArrayList<String>();
        Set<String> predecessors = new HashSet<String>();
        Set<String> successors = new HashSet<String>();
    }

    public static enum NodeType {
        DATASET,
        RECIPE;

    }

    public static class SerializedColumnRelation {
        public String inNodeId;
        public String inputColumnName;
        public String outNodeId;
        public String outputColumnName;
    }

    public static class Column {
        private final String columnName;
        private final String columnType;

        private Column(String columnName, String columnType) {
            this.columnName = columnName;
            this.columnType = columnType;
        }

        public String getColumnName() {
            return GraphSerializerCommon.graphVizEscape(this.columnName);
        }

        public String getColumnType() {
            return this.columnType;
        }
    }
}

