/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomFieldsView
extends AbstractFlowTool.FlowView {
    @Autowired
    private CustomFieldsService customFieldsService;
    private CustomFieldsViewState state;
    private CustomFieldsViewOptions options = new CustomFieldsViewOptions();

    public CustomFieldsView(AuthCtx authCtx, String projectKey) {
        super(authCtx, projectKey);
    }

    @Override
    public AbstractFlowTool.FlowState getFlowState(JsonObject jsonOptions) throws Exception {
        CustomFieldsViewOptions opts = (CustomFieldsViewOptions)JSON.parse((JsonElement)jsonOptions, CustomFieldsViewOptions.class);
        if (opts != null) {
            this.options = opts;
        }
        if (this.state != null) {
            Collection<String> currentFocus = this.state.focused;
            this.computeState();
            this.state.focused = currentFocus;
        } else {
            this.computeState();
        }
        return this.state;
    }

    @Override
    public synchronized CustomFieldsViewState computeState() throws Exception {
        this.state = new CustomFieldsViewState();
        if (StringUtils.isBlank((String)this.options.selectedCustomField)) {
            this.state.valueByNode = new HashMap<String, Object>();
        } else {
            try (Transaction t = this.transactionService.beginRead();){
                this.state.valueByNode = this.getCustomFieldsNodeMap(this.projectKey, this.options.selectedCustomField);
            }
        }
        return this.state;
    }

    @Override
    public void setFocus(Collection<String> focused) throws Exception {
        if (this.state == null) {
            this.computeState();
        }
        this.state.focused = focused == null ? new HashSet<String>() : focused;
    }

    private Map<String, Object> getCustomFieldsNodeMap(String projectKey, String selectedCustomField) throws IOException, InterruptedException {
        HashMap<String, Object> nodeMap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)selectedCustomField)) {
            Map<String, List<CustomFieldsService.PluginComponentCustomFields>> customFieldsMap = this.customFieldsService.getCustomFieldsMap();
            Object dsDefaultValue = this.getDefaultValue(customFieldsMap, ITaggingService.TaggableType.DATASET, selectedCustomField);
            for (Object sds : this.datasetsDAO.listUnsafe(projectKey)) {
                FutureProgressState.checkInterrupt();
                nodeMap.put(GraphIds.forDataset(((SerializedDataset)sds).projectKey, ((SerializedDataset)sds).name), ((SerializedDataset)sds).customFields.has(selectedCustomField) ? ((SerializedDataset)sds).customFields.get(selectedCustomField) : dsDefaultValue);
            }
            Object mfDefaultValue = this.getDefaultValue(customFieldsMap, ITaggingService.TaggableType.MANAGED_FOLDER, selectedCustomField);
            for (Object mf : this.managedFolderDAO.listUnsafe(projectKey)) {
                FutureProgressState.checkInterrupt();
                nodeMap.put(GraphIds.forManagedFolder(projectKey, ((ManagedFolder)mf).id), ((ManagedFolder)mf).customFields.has(selectedCustomField) ? ((ManagedFolder)mf).customFields.get(selectedCustomField) : mfDefaultValue);
            }
            Object smDefaultValue = this.getDefaultValue(customFieldsMap, ITaggingService.TaggableType.SAVED_MODEL, selectedCustomField);
            for (Object sm : this.savedModelsDAO.listUnsafe(projectKey)) {
                FutureProgressState.checkInterrupt();
                nodeMap.put(GraphIds.forSavedModel(projectKey, ((SavedModel)sm).id), ((SavedModel)sm).customFields.has(selectedCustomField) ? ((SavedModel)sm).customFields.get(selectedCustomField) : smDefaultValue);
            }
            Object srDefaultValue = this.getDefaultValue(customFieldsMap, ITaggingService.TaggableType.RECIPE, selectedCustomField);
            for (Object sr : this.recipesDAO.listUnsafe(projectKey)) {
                FutureProgressState.checkInterrupt();
                nodeMap.put(GraphIds.forRecipe(((SerializedRecipe)sr).name), ((SerializedRecipe)sr).customFields.has(selectedCustomField) ? ((SerializedRecipe)sr).customFields.get(selectedCustomField) : srDefaultValue);
            }
            Object ltDefaultValue = this.getDefaultValue(customFieldsMap, ITaggingService.TaggableType.LABELING_TASK, selectedCustomField);
            for (LabelingTask lt : this.labelingTasksDAO.listUnsafe(projectKey)) {
                FutureProgressState.checkInterrupt();
                nodeMap.put(GraphIds.forLabelingTask(projectKey, lt.id), lt.customFields.has(selectedCustomField) ? lt.customFields.get(selectedCustomField) : ltDefaultValue);
            }
            Object rkDefaultValue = this.getDefaultValue(customFieldsMap, ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE, selectedCustomField);
            for (RetrievableKnowledge rk : this.retrievableKnowledgeDAO.listUnsafe(projectKey)) {
                FutureProgressState.checkInterrupt();
                nodeMap.put(GraphIds.forRetrievableKnowledge(projectKey, rk.id), rk.customFields.has(selectedCustomField) ? rk.customFields.get(selectedCustomField) : rkDefaultValue);
            }
        }
        return nodeMap;
    }

    private Object getDefaultValue(Map<String, List<CustomFieldsService.PluginComponentCustomFields>> customFieldsMap, ITaggingService.TaggableType taggableType, String cfName) {
        if (customFieldsMap == null || !customFieldsMap.containsKey(taggableType.name())) {
            return null;
        }
        for (CustomFieldsService.PluginComponentCustomFields compCF : customFieldsMap.get(taggableType.name())) {
            for (ParamDesc cf : compCF.customFields) {
                if (cf.type != ParamDesc.Type.SELECT || !cf.name.equals(cfName)) continue;
                return cf.defaultValue;
            }
        }
        return null;
    }

    public class CustomFieldsViewOptions {
        String selectedCustomField;
    }

    public class CustomFieldsViewState
    implements AbstractFlowTool.FlowState {
        Map<String, Object> valueByNode = new HashMap<String, Object>();
        public CustomFieldsViewOptions options;
        public Collection<String> focused = new HashSet<String>();
    }
}

