/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.jobrunner;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.dataflow.jobrunner.JobBackendLoggingContext;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.AsyncAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class PerJobBackendLoggingAppender
extends AsyncAppender {
    private static final String CONTEXT_PROPERTY = "jobBackendContext";
    private final SyncPerJobBackendLoggingAppender appender = new SyncPerJobBackendLoggingAppender();
    private final Set<JobBackendLoggingContext.Topic> disabledTopics;

    public PerJobBackendLoggingAppender() {
        this.addAppender((Appender)this.appender);
        Params params = DKUApp.getParams();
        this.setBufferSize(params.getIntParam("dku.jobs.backendLogAppender.bufferSize", Integer.valueOf(128)));
        this.setBlocking(params.getBoolParam("dku.jobs.backendLogAppender.blocking", true));
        this.disabledTopics = new HashSet<JobBackendLoggingContext.Topic>();
        for (JobBackendLoggingContext.Topic topic : JobBackendLoggingContext.Topic.values()) {
            boolean topicEnabled = params.getBoolParam("dku.jobs.backendLogAppender.topic." + topic.name() + ".enabled", true);
            if (topicEnabled) continue;
            this.disabledTopics.add(topic);
        }
    }

    public void append(LoggingEvent event) {
        JobBackendLoggingContext context = JobBackendLoggingContext.getCurrentJobContext();
        if (context == null || this.disabledTopics.contains((Object)context.topic)) {
            return;
        }
        event.setProperty(CONTEXT_PROPERTY, JSON.json((Object)context));
        super.append(event);
    }

    public void setLayout(Layout layout) {
        super.setLayout(layout);
        this.appender.setLayout(layout);
    }

    public static void writeToLogFile(JobBackendLoggingContext context, String data) {
        if (context.activity != null) {
            try {
                File activityFile = DKUFileUtils.getWithin((File)FlowJobUtils.jobFolder(false, context.projectKey, context.jobId), (String[])new String[]{context.activity + "." + context.topic.suffix + ".log"});
                FileUtils.writeStringToFile((File)activityFile, (String)data, (String)"utf8", (boolean)true);
            }
            catch (IOException e) {
                System.out.println("Failed to log per-activity line: " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            try {
                File jobFile = new File(FlowJobUtils.jobFolder(false, context.projectKey, context.jobId), "log." + context.topic.suffix + ".log");
                FileUtils.writeStringToFile((File)jobFile, (String)data, (String)"utf8", (boolean)true);
            }
            catch (IOException e) {
                System.out.println("Failed to log per-job line: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private static class SyncPerJobBackendLoggingAppender
    extends AppenderSkeleton {
        private SyncPerJobBackendLoggingAppender() {
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return true;
        }

        protected void append(LoggingEvent event) {
            String[] s;
            String contextStr = event.getProperty(PerJobBackendLoggingAppender.CONTEXT_PROPERTY);
            if (Strings.isNullOrEmpty((String)contextStr)) {
                return;
            }
            JobBackendLoggingContext context = (JobBackendLoggingContext)JSON.parse((String)contextStr, JobBackendLoggingContext.class);
            StringBuilder data = new StringBuilder(this.layout.format(event));
            if (this.layout.ignoresThrowable() && (s = event.getThrowableStrRep()) != null) {
                for (int i = 0; i < s.length; ++i) {
                    data.append(s[i]);
                    data.append(Layout.LINE_SEP);
                }
            }
            PerJobBackendLoggingAppender.writeToLogFile(context, data.toString());
        }
    }
}

