/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.kernel.master;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.dataflow.kernel.master.JobExecutionKernelHandle;
import com.dataiku.dip.kernels.DSSKernelManagerBase;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.utils.DKULogger;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Service;

@Service
public class JobKernelsManager
extends DSSKernelManagerBase<JobExecutionKernelHandle> {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.job.manager");

    public JobKernelsManager() {
        super(logger, "dku.job.kernels", MainLoggingConfigurator.ProcessType.JEK.name(), new DSSKernelManagerBase.KernelManagerConfig(){

            public int getPoolCheckInterval() {
                return ApplicationConfigurator.getParams().getIntParam("dku.jek.pool.waitStartMS", Integer.valueOf(1000));
            }

            public int getPoolStartWait() {
                return ApplicationConfigurator.getParams().getIntParam("dku.jek.pool.checkIntervalMS", Integer.valueOf(30000));
            }

            public int getTargetMinFreeKernels() {
                return ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().jekSettings.numberOfReadyJEKs;
            }

            public int getMaxFreeKernels() {
                throw new IllegalArgumentException("JEK has no max kernel");
            }

            public boolean canReuseKernels() {
                return false;
            }
        });
    }

    @PostConstruct
    public void onStart() {
        if (!FeatureFlags.isEnabled((String)"LEAN_BOOT")) {
            new DSSKernelManagerBase.PoolMaintainerThread((DSSKernelManagerBase)this).start();
        }
        super.onStart();
    }

    public JobExecutionKernelHandle createKernelHandle(String id) {
        return new JobExecutionKernelHandle(id);
    }

    JobExecutionKernelHandle acquireKernel(String projectKey, String jobId) throws Exception {
        return (JobExecutionKernelHandle)super.acquireKernel(jobId, null, projectKey);
    }

    public void onRegister(String kernelId, int port, int jvmPID) {
        JobExecutionKernelHandle jekh = (JobExecutionKernelHandle)this.getStarting(kernelId);
        if (jekh == null) {
            logger.error((Object)("Registration from unknown kernel: " + kernelId));
            return;
        }
        jekh.onRegister(port, jvmPID);
    }
}

