/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.kernel.master.postactions;

import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.dataflow.kernel.master.postactions.PerActivityPostJobAction;
import com.dataiku.dip.server.services.LogsService;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class CleanupH2Databases
extends PerActivityPostJobAction {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.jobs.postactions.h2");

    public CleanupH2Databases(String projectKey, String jobId) {
        super(projectKey, jobId);
    }

    @Override
    public void runForActivity(String activityId, SerializedJobActivityStatus status) throws Exception {
        File activityFolder = DKUFileUtils.getWithin((File)LogsService.getJobFolder(this.projectKey, this.jobId), (String[])new String[]{activityId});
        if (!activityFolder.isDirectory()) {
            return;
        }
        Files.walkFileTree(activityFolder.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attr) throws IOException {
                if (attr.isRegularFile() && path.toFile().getName().endsWith(".mv.db")) {
                    logger.info((Object)("Removing stray H2 database in activity: " + String.valueOf(path)));
                    DKUFileUtils.delete((File)path.toFile());
                }
                if (attr.isRegularFile() && path.toString().contains("dataset-to-h2") && path.toFile().getName().endsWith(".csv")) {
                    logger.info((Object)("Removing stray CSV copy in activity: " + String.valueOf(path)));
                    DKUFileUtils.delete((File)path.toFile());
                }
                if (attr.isRegularFile() && path.toString().contains("dataset-to-h2") && path.toFile().getName().endsWith(".temp.db")) {
                    logger.info((Object)("Removing stray H2 temp file in activity: " + String.valueOf(path)));
                    DKUFileUtils.delete((File)path.toFile());
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

