/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.kernel.master.postactions;

import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.dataflow.kernel.master.postactions.PerActivityPostJobAction;
import com.dataiku.dip.server.services.LogsService;
import com.dataiku.dip.server.services.ProjectsUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Params;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;

public class ReduceActivityProcessOutputLogs
extends PerActivityPostJobAction {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.jobs.postactions.processLogs");

    public ReduceActivityProcessOutputLogs(String projectKey, String jobId) {
        super(projectKey, jobId);
    }

    @Override
    public void runForActivity(String activityId, SerializedJobActivityStatus status) throws Exception {
        File activityFolder = DKUFileUtils.getWithin((File)LogsService.getJobFolder(this.projectKey, this.jobId), (String[])new String[]{activityId});
        if (!activityFolder.isDirectory()) {
            return;
        }
        Params p = ProjectsUtils.getProjectDKUPropertiesAsParamsWithSystemOverrideEvenIfProjectDoesNotExist_AutoTXN(this.projectKey);
        if (!p.getBoolParam("dku.jobs.postActions.reduceJobLogs.enabled", true)) {
            logger.info((Object)"Not reducing job logs (requested by project property)");
            return;
        }
        final long minSizeForProcessLogCompressionKB = p.getLongParam("dku.jobs.postActions.reduceJobLogs.minSizeForProcessLogCompressionKB", 200L);
        final HashSet compressible = Sets.newHashSet((Object[])new String[]{"process-out.log", "python-output.log", "R-output.log", "executors-logs.log", "pods-describe.log", "spark-submit-out.log"});
        Files.walkFileTree(activityFolder.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attr) throws IOException {
                if (attr.isRegularFile() && compressible.contains(path.toFile().getName())) {
                    File logFile = path.toFile();
                    logger.trace(() -> "compressible file " + logFile.getAbsolutePath() + " of size " + logFile.length());
                    if (minSizeForProcessLogCompressionKB > 0L && logFile.length() > minSizeForProcessLogCompressionKB * 1024L) {
                        logger.debug((Object)("Compressing too large process output log file:" + String.valueOf(logFile)));
                        DKUFileUtils.gzCompress((File)logFile);
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

