/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pipeline;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.processors.AppliesToProcessor;
import com.dataiku.dip.shaker.processors.expr.CreateColumnWithGREL;
import com.dataiku.dip.shaker.processors.filtering.ColumnsSelector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OverridesHelper {
    public static Response generateScriptData(Request request) {
        Response res = new Response();
        res.steps = OverridesHelper.generateStepsFromFilters(request);
        res.outputSchema = OverridesHelper.generateOutputSchemaFromFilters(request);
        return res;
    }

    private static List<ScriptStep> generateStepsFromFilters(Request request) {
        ArrayList<ScriptStep> steps = new ArrayList<ScriptStep>();
        steps.add(OverridesHelper.getStepOutputColumnWithDefaultValue(request.outputColumn, request.defaultOverrideValue));
        steps.addAll(OverridesHelper.getStepForOverrides(request.filters, request.outputColumn));
        steps.add(OverridesHelper.getStepKeepOnlyOutputColumn(request.outputColumn));
        return steps;
    }

    private static ScriptStep getStepOutputColumnWithDefaultValue(String outputColumn, String defaultOverrideValue) {
        CreateColumnWithGREL.Parameter createColParams = new CreateColumnWithGREL.Parameter();
        createColParams.column = outputColumn;
        createColParams.expression = "'" + defaultOverrideValue + "'";
        return ProcessorScriptStep.ofType(CreateColumnWithGREL.META).withParams(createColParams);
    }

    private static List<ScriptStep> getStepForOverrides(List<Request.FilterData> filters, String outputColumn) {
        ArrayList<ScriptStep> steps = new ArrayList<ScriptStep>();
        for (Request.FilterData filterData : filters) {
            CreateColumnWithGREL.Parameter formulaParams = new CreateColumnWithGREL.Parameter();
            formulaParams.column = outputColumn;
            String escapedFilterName = FilterDescUtils.getGrelQuotedString(filterData.name);
            formulaParams.expression = "if(" + FilterDescUtils.getFilterRepr(filterData.filter) + ", " + escapedFilterName + ", " + outputColumn + ")";
            steps.add(ProcessorScriptStep.ofType(CreateColumnWithGREL.META).withParams(formulaParams));
        }
        return steps;
    }

    private static ScriptStep getStepKeepOnlyOutputColumn(String outputColumn) {
        ColumnsSelector.Parameter selectorParams = new ColumnsSelector.Parameter();
        selectorParams.keep = true;
        selectorParams.appliesTo = AppliesToProcessor.AppliesTo.COLUMNS;
        selectorParams.columns = Collections.singletonList(outputColumn);
        return ProcessorScriptStep.ofType(ColumnsSelector.META).withParams(selectorParams);
    }

    private static Schema generateOutputSchemaFromFilters(Request request) {
        SchemaColumn column = new SchemaColumn(request.outputColumn, Type.STRING);
        Schema schema = new Schema();
        schema.addColumn(column);
        return schema;
    }

    public static class Response {
        List<ScriptStep> steps;
        Schema outputSchema;
    }

    public static class Request {
        List<FilterData> filters;
        String outputColumn;
        String defaultOverrideValue;

        public static class FilterData {
            String name;
            FilterDesc filter;
        }
    }
}

