/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pipeline;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.pipeline.PipelineabilityEvaluator;
import com.dataiku.dip.dataflow.pipeline.SparkPipelineDef;
import com.dataiku.dip.dataflow.pipeline.SqlPipelineElement;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.resources.ResourcesGatherer;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.ImmutableList;
import java.util.List;

public abstract class RecipePipelineHelper {
    protected final PipelineType pipelineType;
    private String expectedEngineType;
    static final String UNKNOWN_ENGINE = "Unknown";
    protected final AuthCtx authCtx;
    protected final SerializedRecipe recipe;
    protected final String payload;
    private final boolean allowGlobalMetastore;
    boolean allowPipelineStart;
    boolean allowPipelineMerge;
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.flow.compute.pipeline.evaluator");

    RecipePipelineHelper(AuthCtx authCtx, SerializedRecipe recipe, String payload, PipelineType pipelineType, JobActivity jobActivity) {
        this.authCtx = authCtx;
        this.recipe = recipe;
        this.payload = payload;
        this.pipelineType = pipelineType;
        this.allowGlobalMetastore = ApplicationConfigurator.getParams().getBoolParam("dku.spark.pipelines.allowGlobalMetastore", false);
        this.initialize(jobActivity);
        switch (this.pipelineType) {
            case SPARK: {
                this.expectedEngineType = "SPARK";
                this.initializeForSpark();
                break;
            }
            case SQL: {
                this.expectedEngineType = "SQL";
                this.initializeForSql();
                break;
            }
            default: {
                throw new IllegalStateException(String.format("%s is not supported. Only Spark and Sql pipelines are.", new Object[]{this.pipelineType}));
            }
        }
    }

    protected void initialize(JobActivity jobActivity) {
    }

    protected abstract void initializeForSpark();

    protected abstract void initializeForSql();

    protected String engineType() {
        RecipeMeta meta = RecipeRegistry.getMeta(this.recipe.type);
        try {
            RecipeStatus status = meta.buildStatusComputer(this.recipe, this.payload).fastStatusIgnorePartitions(this.authCtx);
            RecipeEngineStatus es = status.selectedEngine;
            return es.type;
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "Unable to get engine type for recipe %s", new Object[]{this.recipe.getDisplayName()});
            return UNKNOWN_ENGINE;
        }
    }

    PipelineabilityEvaluator.Pipelineability buildPipelineability() {
        if (this.isPipelineable()) {
            return new PipelineabilityEvaluator.Pipelineability(this.allowPipelineStart, this.allowPipelineMerge);
        }
        return PipelineabilityEvaluator.NOT_PIPELINEABLE;
    }

    SparkPipelineDef.SparkPipelineElt buildPipelineElt(JobActivity activity, ResourcesGatherer gatherer) throws Exception {
        this.assertConfiguration();
        SparkPipelineDef.SparkPipelineElt elt = new SparkPipelineDef.SparkPipelineElt();
        SparkSQLDialect dialect = new SparkSQLDialect();
        elt.type = this.recipe.type;
        this.finalizeElt(elt, activity, dialect, gatherer);
        return elt;
    }

    List<SqlPipelineElement> generateSqlQueries(JobActivity activity, SQLDialect dialect) throws Exception {
        return ImmutableList.of((Object)new SqlPipelineElement(activity, this.generateSqlQuery(activity, dialect)));
    }

    protected String generateSqlQuery(JobActivity activity, SQLDialect dialect) throws Exception {
        throw new IllegalStateException(String.format("Recipe is not SQL pipelineable: %s", this.recipe.type));
    }

    boolean getGlobalMetastoreFromRecipeActivity() {
        this.assertConfiguration();
        return this.useGlobalMetastore();
    }

    SparkOverrideConfig getSparkConfFromRecipeActivity() {
        this.assertConfiguration();
        return this.sparkConfig();
    }

    AbstractSparkRecipeParams.SparkExecutionEngine getSparkExecutionEngineFromRecipeActivity() {
        this.assertConfiguration();
        return this.sparkExecutionEngine();
    }

    boolean canSetSparkPipelineability() {
        return true;
    }

    boolean canSetSqlPipelineability() {
        return true;
    }

    public boolean canSetPipelineability() {
        switch (this.pipelineType) {
            case SPARK: {
                return this.canSetSparkPipelineability();
            }
            case SQL: {
                return this.canSetSqlPipelineability();
            }
        }
        throw new IllegalStateException(String.format("%s is not supported. Only Spark and Sql pipelines are.", new Object[]{this.pipelineType}));
    }

    abstract String setSparkPipelineability(boolean var1, boolean var2);

    abstract String setSqlPipelineability(boolean var1, boolean var2);

    public String setPipelineability(boolean allowStart, boolean allowMerge) {
        switch (this.pipelineType) {
            case SPARK: {
                return this.setSparkPipelineability(allowStart, allowMerge);
            }
            case SQL: {
                return this.setSqlPipelineability(allowStart, allowMerge);
            }
        }
        throw new IllegalStateException(String.format("%s is not supported. Only Spark and Sql pipelines are.", new Object[]{this.pipelineType}));
    }

    protected void assertConfiguration() {
    }

    protected boolean forcePipelinableForTests() {
        return false;
    }

    protected abstract String getEngineType();

    boolean isValidEngine() {
        return this.expectedEngineType.equals(this.getEngineType());
    }

    protected abstract boolean isValidConfiguration();

    protected abstract boolean useGlobalMetastore();

    protected abstract void finalizeElt(SparkPipelineDef.SparkPipelineElt var1, JobActivity var2, SparkSQLDialect var3, ResourcesGatherer var4) throws Exception;

    protected abstract SparkOverrideConfig sparkConfig();

    protected abstract AbstractSparkRecipeParams.SparkExecutionEngine sparkExecutionEngine();

    private boolean isPipelineable() {
        if (this.forcePipelinableForTests()) {
            return true;
        }
        return this.isValidConfiguration() && this.isValidEngine() && (PipelineType.SQL.equals((Object)this.pipelineType) || this.isMetastoreFlagOK());
    }

    private boolean isMetastoreFlagOK() {
        return !this.useGlobalMetastore() || this.allowGlobalMetastore;
    }

    public static enum PipelineType {
        SPARK,
        SQL;

    }
}

