/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pipeline;

import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.partitioning.Partition;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

class SqlPipelineElement {
    final String jobActivityId;
    final RecipeRunnableSubgraph subgraph;
    final Partition targetPartition;
    final FlowDataset targetFlowDataset;
    final String sqlQuery;
    final List<String> setupSqlQueries = new ArrayList<String>();
    final List<String> teardownSqlQueries = new ArrayList<String>();
    boolean sqlQueryIsCommentFree = false;
    boolean sqlQueryMayContainUnionOrSelect = true;
    boolean needExecutionPlan = true;

    SqlPipelineElement(JobActivity jobActivity, String sqlQuery) {
        this.sqlQuery = sqlQuery;
        this.jobActivityId = jobActivity.id();
        this.subgraph = (RecipeRunnableSubgraph)jobActivity.getSubgraph();
        this.targetFlowDataset = this.subgraph.getSingleTargetDataset();
        this.targetPartition = this.subgraph.getTargetPartition(this.targetFlowDataset);
    }

    public SqlPipelineElement withSetupSqlQueries(String ... queries) {
        return this.withSetupSqlQueries(Lists.newArrayList((Object[])queries));
    }

    public SqlPipelineElement withSetupSqlQueries(List<String> queries) {
        this.setupSqlQueries.addAll(queries);
        return this;
    }

    public SqlPipelineElement withTeardownSqlQueries(String ... queries) {
        return this.withTeardownSqlQueries(Lists.newArrayList((Object[])queries));
    }

    public SqlPipelineElement withTeardownSqlQueries(List<String> queries) {
        this.teardownSqlQueries.addAll(queries);
        return this;
    }
}

