/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.utils;

import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SinkProcessorOutput;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import java.util.Random;

public class ReservoirSamplingProcessorOutput
extends SinkProcessorOutput {
    private final MemTable table;
    private final int targetRecords;
    private final Random rnd;
    private int alreadySent;
    private long maxMemoryUsed = -1L;
    private long memoryUsed = 0L;

    public ReservoirSamplingProcessorOutput(MemTable table, int targetRecords, Long seed) {
        this.table = table;
        this.targetRecords = targetRecords;
        this.rnd = seed != null ? new Random(seed) : new Random();
    }

    public void setMaxMemoryUsed(long size) {
        this.maxMemoryUsed = size;
    }

    public void emitRow(Row row) throws Exception {
        if (this.targetRecords <= 0) {
            return;
        }
        MemRow memRow = (MemRow)row;
        if (this.alreadySent < this.targetRecords) {
            this.table.appendRow(row);
            this.memoryUsed += memRow.getMemoryUsed();
        } else {
            int rndVal = this.rnd.nextInt() & Integer.MAX_VALUE;
            if ((rndVal %= this.alreadySent) < this.targetRecords) {
                MemRow oldRow = this.table.rows.get(rndVal);
                this.memoryUsed -= oldRow.getMemoryUsed();
                this.table.rows.set(rndVal, memRow);
                this.memoryUsed += memRow.getMemoryUsed();
            }
        }
        if (this.maxMemoryUsed > 0L && this.memoryUsed >= this.maxMemoryUsed) {
            throw new MemTableAppendingOutput.MemTableSizeLimitReachedException(this.table.rows.size(), this.memoryUsed);
        }
        ++this.alreadySent;
    }
}

