/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.window;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.sort.RowValueAccessorFactory;
import com.dataiku.dip.datalayer.sort.RowsComparator;
import com.dataiku.dip.datalayer.window.WindowAggregation;
import com.google.common.annotations.VisibleForTesting;
import java.util.Comparator;
import java.util.TreeMap;

public class MinOrMaxAggregation
extends WindowAggregation {
    public static final int MAX_BUFFER_SIZE_DEFAULT = 100;
    @VisibleForTesting
    static int maxBufferSize = 100;
    private final TreeMap<Object, Integer> bufferContents;
    private final Comparator<Object> bufferSorter;
    private boolean hasDiscardedValues = false;
    private boolean needsReset = false;

    public static SchemaColumn buildOutputSchemaColumn(String name, SchemaColumn schemaColumn) {
        return new SchemaColumn(name, schemaColumn.getType());
    }

    public MinOrMaxAggregation(Column column, Column result, SchemaColumn schemaColumn, boolean isMin) {
        super(column, result, schemaColumn, MinOrMaxAggregation.buildOutputSchemaColumn(result.getName(), schemaColumn));
        this.bufferSorter = RowValueAccessorFactory.getComparator(schemaColumn, column, isMin, RowsComparator.NullsOrdering.NULLS_LAST);
        this.bufferContents = new TreeMap(this.bufferSorter);
    }

    @Override
    public boolean needsReset() {
        return this.needsReset;
    }

    @Override
    public void reset() {
        this.bufferContents.clear();
        this.needsReset = false;
        this.hasDiscardedValues = false;
    }

    @Override
    public void expandInternal(Object value) {
        if (value != null) {
            if (this.bufferContents.containsKey(value)) {
                this.bufferContents.put(value, 1 + this.bufferContents.get(value));
            } else if (this.bufferContents.size() == 0) {
                this.bufferContents.put(value, 1);
            } else {
                Object last = this.bufferContents.lastKey();
                if (this.bufferSorter.compare(value, last) < 0 || !this.hasDiscardedValues) {
                    if (this.bufferContents.size() >= maxBufferSize) {
                        this.bufferContents.remove(last);
                        this.hasDiscardedValues = true;
                    }
                    this.bufferContents.put(value, 1);
                }
            }
        }
    }

    @Override
    public void shrinkInternal(Object value) {
        if (value != null && this.bufferContents.containsKey(value)) {
            int c2 = this.bufferContents.get(value) - 1;
            if (c2 == 0) {
                this.bufferContents.remove(value);
                if (this.bufferContents.size() == 0 && this.hasDiscardedValues) {
                    this.needsReset = true;
                }
            } else {
                this.bufferContents.put(value, c2);
            }
        }
    }

    @Override
    public Object produceValueInternal() {
        return this.bufferContents.size() > 0 ? this.bufferContents.firstKey() : null;
    }
}

