/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality;

import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@UIModel
public class DataQualityTemplate {
    @JSON.FileTransient
    String id = SecretKeyGenerator.generate((int)8);
    String name;
    String description;
    List<DataQualityRule> rules;

    public DataQualityTemplate(String displayName, String description, List<DataQualityRule> rules) {
        this.name = displayName;
        this.description = description != null ? description : "";
        this.rules = this.cleanRulesForTemplateConfig(rules);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<DataQualityRule> getRules() {
        return this.rules;
    }

    public DataQualityTemplate withRules(List<DataQualityRule> rules) {
        this.rules = new ArrayList<DataQualityRule>(rules);
        return this;
    }

    private List<DataQualityRule> cleanRulesForTemplateConfig(List<DataQualityRule> rules) {
        return rules.stream().map(rule -> ((DataQualityRule)JSON.deepCopy((Object)rule)).withId(SecretKeyGenerator.generate((int)8))).collect(Collectors.toList());
    }
}

