/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality.dqmetrics;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataquality.dqmetrics.ValuesInRangeMetric;
import com.dataiku.dip.dataquality.rules.AbstractColumnsInRangeRule;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.engines.HiveMetricsEngine;
import com.dataiku.dip.metrics.engines.ImpalaMetricsEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.engines.MetricsQueryBuilder;
import com.dataiku.dip.metrics.engines.SQLMetricsEngine;
import com.dataiku.dip.metrics.engines.SparkMetricsEngine;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class ValuesInRangeSQLLikeComputer {
    private ValuesInRangeSQLLikeComputer() {
    }

    public static void addAggregations(MetricComputation computation, SelectQueryBuilder queryBuilder) throws Exception {
        SelectQueryBuilder.SelectRefBuilder ref;
        ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
        ValuesInRangeSQLLikeComputerSession session = (ValuesInRangeSQLLikeComputerSession)computation.session;
        ValuesInRangeMetric metric = (ValuesInRangeMetric)computation.metric;
        String columnName = metric.getColumn();
        Optional<ExpressionBuilder> hardCondition = AbstractColumnsInRangeRule.buildViolationCondition(ebf, columnName, metric.minimumEnabled, metric.minimum, metric.maximumEnabled, metric.maximum);
        if (hardCondition.isPresent()) {
            ExpressionBuilder hardCaseExpr = ebf.caseWhen(hardCondition.get(), ebf.cst(1), ebf.cst(0));
            ref = queryBuilder.select(hardCaseExpr.sum().cast(Type.BIGINT));
        } else {
            ref = queryBuilder.select(ebf.cst(0).cast(Type.BIGINT));
        }
        session.offsets.add(ref.getIndex());
        Optional<ExpressionBuilder> softCondition = AbstractColumnsInRangeRule.buildViolationCondition(ebf, columnName, metric.softMinimumEnabled, metric.softMinimum, metric.softMaximumEnabled, metric.softMaximum);
        if (softCondition.isPresent()) {
            ExpressionBuilder softCaseExpr = ebf.caseWhen(softCondition.get(), ebf.cst(1), ebf.cst(0));
            ref = queryBuilder.select(softCaseExpr.sum().cast(Type.BIGINT));
        } else {
            ref = queryBuilder.select(ebf.cst(0).cast(Type.BIGINT));
        }
        session.offsets.add(ref.getIndex());
    }

    public static String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
        int softCountPosition;
        int hardCountPosition;
        HashMap<String, Long> counts = new HashMap<String, Long>();
        counts.put("hard", 0L);
        counts.put("soft", 0L);
        ValuesInRangeSQLLikeComputerSession session = (ValuesInRangeSQLLikeComputerSession)computation.session;
        if (rs2.rows.isEmpty() || session.offsets.size() != 2) {
            return JSON.json(counts);
        }
        String[] row = rs2.rows.get(0);
        if (row.length > Math.max(hardCountPosition = session.offsets.get(0) - 1, softCountPosition = session.offsets.get(1) - 1)) {
            try {
                counts.put("hard", Long.parseLong(row[hardCountPosition]));
                counts.put("soft", Long.parseLong(row[softCountPosition]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return JSON.json(counts);
    }

    public static class ValuesInRangeSQLLikeComputerSession {
        public List<Integer> offsets = Lists.newArrayList();
    }

    public static class ValuesInRangeSparkComputer
    extends MetricComputer.SparkMetricsEngineComputer {
        @Override
        public String getProbeType() {
            return "temporary_metrics_probe";
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (objectType == MetricTargetType.DATASET) {
                MetricComputation computation = new MetricComputation(probe, this, metric, 3.0);
                computation.session = new ValuesInRangeSQLLikeComputerSession();
                ValuesInRangeMetric valuesInRangeMetric = (ValuesInRangeMetric)metric;
                Dataset dataset = (Dataset)object;
                SchemaColumn column = dataset.getSchema().getColumn(valuesInRangeMetric.getColumn());
                if (column == null || !column.getType().isNumeric()) {
                    return null;
                }
                return new SparkMetricsEngine.SparkMetricsEngineRun().with(computation);
            }
            return null;
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            ValuesInRangeSQLLikeComputer.addAggregations(computation, queryBuilder);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return ValuesInRangeSQLLikeComputer.getAggregate(rs2, computation);
        }
    }

    public static class ValuesInRangeHiveComputer
    extends MetricComputer.HiveMetricsEngineComputer {
        @Override
        public String getProbeType() {
            return "temporary_metrics_probe";
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (objectType == MetricTargetType.DATASET && DatasetInspector.isHDFSDatasetOrHiveTableDataset((Dataset)object)) {
                MetricComputation computation = new MetricComputation(probe, this, metric, 2.0);
                computation.session = new ValuesInRangeSQLLikeComputerSession();
                ValuesInRangeMetric valuesInRangeMetric = (ValuesInRangeMetric)metric;
                Dataset dataset = (Dataset)object;
                SchemaColumn column = dataset.getSchema().getColumn(valuesInRangeMetric.getColumn());
                if (column == null || !column.getType().isNumeric()) {
                    return null;
                }
                return new HiveMetricsEngine.HiveMetricsEngineRun().with(computation);
            }
            return null;
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            ValuesInRangeSQLLikeComputer.addAggregations(computation, queryBuilder);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return ValuesInRangeSQLLikeComputer.getAggregate(rs2, computation);
        }
    }

    public static class ValuesInRangeImpalaComputer
    extends MetricComputer.ImpalaMetricsEngineComputer {
        @Override
        public String getProbeType() {
            return "temporary_metrics_probe";
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (objectType == MetricTargetType.DATASET && DatasetInspector.isHDFSDatasetOrHiveTableDataset((Dataset)object)) {
                MetricComputation computation = new MetricComputation(probe, this, metric, 1.0);
                computation.session = new ValuesInRangeSQLLikeComputerSession();
                ValuesInRangeMetric valuesInRangeMetric = (ValuesInRangeMetric)metric;
                Dataset dataset = (Dataset)object;
                SchemaColumn column = dataset.getSchema().getColumn(valuesInRangeMetric.getColumn());
                if (column == null || !column.getType().isNumeric()) {
                    return null;
                }
                return new ImpalaMetricsEngine.ImpalaMetricsEngineRun(null).with(computation);
            }
            return null;
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            ValuesInRangeSQLLikeComputer.addAggregations(computation, queryBuilder);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return ValuesInRangeSQLLikeComputer.getAggregate(rs2, computation);
        }
    }

    public static class ValuesInRangeSQLComputer
    extends MetricComputer.SQLMetricsEngineComputer {
        @Override
        public String getProbeType() {
            return "temporary_metrics_probe";
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (objectType == MetricTargetType.DATASET && DatasetInspector.isSQLAble(authCtx, (Dataset)object)) {
                MetricComputation computation = new MetricComputation(probe, this, metric, 1.0);
                computation.session = new ValuesInRangeSQLLikeComputerSession();
                ValuesInRangeMetric valuesInRangeMetric = (ValuesInRangeMetric)metric;
                Dataset dataset = (Dataset)object;
                SchemaColumn column = dataset.getSchema().getColumn(valuesInRangeMetric.getColumn());
                if (column == null || !column.getType().isNumeric()) {
                    return null;
                }
                return new SQLMetricsEngine.SQLMetricsEngineRun().with(computation);
            }
            return null;
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            ValuesInRangeSQLLikeComputer.addAggregations(computation, queryBuilder);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return ValuesInRangeSQLLikeComputer.getAggregate(rs2, computation);
        }
    }
}

