/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dip.shaker.types.Date;
import com.dataiku.dip.shaker.types.DateOnly;
import com.dataiku.dip.shaker.types.DatetimeNoTz;
import com.dataiku.dip.shaker.types.DoubleMeaning;
import com.dataiku.dip.shaker.types.GeoPoint;
import com.dataiku.dip.shaker.types.LongMeaning;
import java.util.EnumSet;

public class ColumnStorageTypeInferer {
    EnumSet<Type> rejectedForAutodetection = EnumSet.noneOf(Type.class);
    EnumSet<Type> storable = EnumSet.allOf(Type.class);
    LongMeaning longForStorability = new LongMeaning();
    DoubleMeaning doubleForStorability = new DoubleMeaning();
    GeoPoint geopointForStorability = new GeoPoint();
    Boolean boolForStorability = new Boolean();
    Date dateForStorability = new Date();
    DateOnly dateOnlyForStorability = new DateOnly();
    DatetimeNoTz datetimeNoTzForStorability = new DatetimeNoTz();

    public void rejectAutoDetection(Type ... typesToReject) {
        for (Type t : typesToReject) {
            this.rejectedForAutodetection.add(t);
        }
    }

    public void invalidateStorageTypes(String val) {
        if (this.storable.contains(Type.DOUBLE) && !this.doubleForStorability.validates(val)) {
            this.storable.remove(Type.DOUBLE);
            this.storable.remove(Type.FLOAT);
        }
        if (this.storable.contains(Type.BIGINT) && !this.longForStorability.validates(val)) {
            this.storable.remove(Type.TINYINT);
            this.storable.remove(Type.SMALLINT);
            this.storable.remove(Type.INT);
            this.storable.remove(Type.BIGINT);
        }
        if (this.storable.contains(Type.BOOLEAN) && !this.boolForStorability.validates(val)) {
            this.storable.remove(Type.BOOLEAN);
        }
        if (this.storable.contains(Type.DATE) && !this.dateForStorability.validates(val)) {
            this.storable.remove(Type.DATE);
        }
        if (this.storable.contains(Type.DATEONLY) && !this.dateOnlyForStorability.validates(val)) {
            this.storable.remove(Type.DATEONLY);
        }
        if (this.storable.contains(Type.DATETIMENOTZ) && !this.datetimeNoTzForStorability.validates(val)) {
            this.storable.remove(Type.DATETIMENOTZ);
        }
        if (this.storable.contains(Type.GEOPOINT) && !this.geopointForStorability.validates(val)) {
            this.storable.remove(Type.GEOPOINT);
        }
        if (!(!this.storable.contains(Type.MAP) || val.startsWith("{") && val.endsWith("}"))) {
            this.storable.remove(Type.MAP);
        }
        if (!(!this.storable.contains(Type.OBJECT) || val.startsWith("{") && val.endsWith("}"))) {
            this.storable.remove(Type.OBJECT);
        }
        if (!(!this.storable.contains(Type.ARRAY) || val.startsWith("[") && val.endsWith("]"))) {
            this.storable.remove(Type.ARRAY);
        }
    }

    public static Type[] getFromBestToWorst() {
        return new Type[]{Type.MAP, Type.ARRAY, Type.DATE, Type.DATEONLY, Type.DATETIMENOTZ, Type.BIGINT, Type.DOUBLE, Type.BOOLEAN, Type.STRING};
    }

    public EnumSet<Type> getRejectedForAutodetection() {
        return this.rejectedForAutodetection;
    }

    public EnumSet<Type> getStillStorable() {
        return this.storable;
    }

    public EnumSet<Type> getStillStorableAndDetectable() {
        EnumSet<Type> sad = EnumSet.copyOf(this.storable);
        for (Type t : this.rejectedForAutodetection) {
            sad.remove(t);
        }
        return sad;
    }
}

