/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.utils.JSON;
import java.util.List;
import java.util.stream.Collectors;

public class DatasetSelectionToMemTable
extends DatasetSelection {
    public long maxRecordsForDisplay = -1L;
    public long maxStoredBytes = -1L;
    public long timeout = -1L;

    public static DatasetSelectionToMemTable newHead10K() {
        DatasetSelectionToMemTable ret = new DatasetSelectionToMemTable();
        ret.samplingMethod = SamplingParam.SamplingMethod.HEAD_SEQUENTIAL;
        ret.maxRecords = 10000L;
        return ret;
    }

    public static DatasetSelectionToMemTable newFull() {
        DatasetSelectionToMemTable ret = new DatasetSelectionToMemTable();
        ret.samplingMethod = SamplingParam.SamplingMethod.FULL;
        return ret;
    }

    public DatasetSelectionToMemTable withSelectedPartitions(List<Partition> partitions) {
        this.partitionSelectionMethod = DatasetSelection.PartitionSelectionMethod.SELECTED;
        this.selectedPartitions = partitions.stream().map(Partition::id).collect(Collectors.toList());
        return this;
    }

    public DatasetSelectionToMemTable withMaxStoredBytes(long maxStoredBytes) {
        this.maxStoredBytes = maxStoredBytes;
        return this;
    }

    public static DatasetSelectionToMemTable fromSamplingParam(SamplingParam sp) {
        return (DatasetSelectionToMemTable)((Object)JSON.parse((String)JSON.json((Object)sp), DatasetSelectionToMemTable.class));
    }
}

