/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.GCSConnection;
import com.dataiku.dip.connections.IcebergConnection;
import com.dataiku.dip.connections.SnowflakeConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.datasets.fs.UploadedFilesDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.formats.JSONFormatConfig;
import com.dataiku.dip.input.formats.JSONFormatExtractor;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import java.io.IOException;

public class DatasetSparkInspector {
    public static SparkFastPathStatus isLikelySparkFastReadable(AuthCtx authCtx, Dataset dataset) throws IOException, DKUSecurityException {
        return DatasetSparkInspector.isLikelySparkFastCapable(authCtx, dataset);
    }

    public static SparkFastPathStatus isLikelySparkFastWritable(AuthCtx authCtx, Dataset dataset) throws IOException, DKUSecurityException {
        return DatasetSparkInspector.isLikelySparkFastCapable(authCtx, dataset);
    }

    private static SparkFastPathStatus isLikelySparkFastCapable(AuthCtx authCtx, Dataset dataset) throws IOException, DKUSecurityException {
        ConnectionsDAO connectionsDAO = (ConnectionsDAO)SpringUtils.getBean(ConnectionsDAO.class);
        switch (dataset.getType()) {
            case "HDFS": {
                DSSConnection conn = connectionsDAO.getMandatoryConnection(authCtx, dataset.getParamsAs(HDFSDatasetHandler.Config.class).connection);
                if (!conn.detailsReadableBy(authCtx)) {
                    return SparkFastPathStatus.nok("Connection details are not readable by user");
                }
                return DatasetSparkInspector.isFormatLikelyFastReadable(dataset);
            }
            case "S3": {
                EC2Connection conn = connectionsDAO.getMandatoryConnectionAs(authCtx, dataset.getParamsAs(BuiltinFSDatasets.S3DatasetConfig.class).connection, EC2Connection.class);
                if (!conn.detailsReadableBy(authCtx)) {
                    return SparkFastPathStatus.nok("Connection details are not readable by user");
                }
                if (conn.getHDFSScheme() == null) {
                    return SparkFastPathStatus.nok("Hadoop support not enabled on connection");
                }
                return DatasetSparkInspector.isFormatLikelyFastReadable(dataset);
            }
            case "Azure": {
                AzureConnection conn = connectionsDAO.getMandatoryConnectionAs(authCtx, dataset.getParamsAs(BuiltinFSDatasets.AzureBlobDatasetConfig.class).connection, AzureConnection.class);
                if (!conn.detailsReadableBy(authCtx)) {
                    return SparkFastPathStatus.nok("Connection details are not readable by user");
                }
                if (conn.getHDFSScheme() == null) {
                    return SparkFastPathStatus.nok("Hadoop support not enabled on connection");
                }
                return DatasetSparkInspector.isFormatLikelyFastReadable(dataset);
            }
            case "GCS": {
                GCSConnection conn = connectionsDAO.getMandatoryConnectionAs(authCtx, dataset.getParamsAs(BuiltinFSDatasets.GCSDatasetConfig.class).connection, GCSConnection.class);
                if (!conn.detailsReadableBy(authCtx)) {
                    return SparkFastPathStatus.nok("Connection details are not readable by user");
                }
                if (conn.getHDFSScheme() == null) {
                    return SparkFastPathStatus.nok("Hadoop support not enabled on connection");
                }
                return DatasetSparkInspector.isFormatLikelyFastReadable(dataset);
            }
            case "Snowflake": {
                SnowflakeConnection conn = connectionsDAO.getMandatoryConnectionAs(authCtx, dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).connection, SnowflakeConnection.class);
                if (!conn.detailsReadableBy(authCtx)) {
                    return SparkFastPathStatus.nok("Connection details are not readable by user");
                }
                if (!conn.params.useSparkNativeIntegration) {
                    return SparkFastPathStatus.nok("Spark integration not enabled on connection");
                }
                if (dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).variablesExpansionLoopConfig.isEnabled()) {
                    return SparkFastPathStatus.nok("Repeating mode is enabled on input");
                }
                return SparkFastPathStatus.ok();
            }
            case "iceberg": {
                IcebergConnection conn = connectionsDAO.getMandatoryConnectionAs(authCtx, dataset.getParams().getConnection(), IcebergConnection.class);
                if (!conn.detailsReadableBy(authCtx)) {
                    return SparkFastPathStatus.nok("Connection details are not readable by user");
                }
                return SparkFastPathStatus.ok();
            }
            case "UploadedFiles": {
                try (UploadedFilesDatasetHandler handler = (UploadedFilesDatasetHandler)DatasetHandlerFactory.build(authCtx, dataset);){
                    Dataset realDataset = handler.getRealDataset();
                    SparkFastPathStatus sparkFastPathStatus = DatasetSparkInspector.isLikelySparkFastCapable(authCtx, realDataset);
                    return sparkFastPathStatus;
                }
            }
        }
        return SparkFastPathStatus.nok("Dataset type does not support Spark fast-path");
    }

    private static SparkFastPathStatus isFormatLikelyFastReadable(Dataset dataset) {
        if (DatasetInspector.isFS(dataset) && dataset.getParams() instanceof AbstractFSDatasetHandler.AbstractFSConfig && dataset.getParamsAs(AbstractFSDatasetHandler.AbstractFSConfig.class).variablesExpansionLoopConfig.isEnabled()) {
            return SparkFastPathStatus.nok("Repeating input dataset is enabled");
        }
        if (dataset.getFormatType() == null) {
            return SparkFastPathStatus.nok("Dataset does not have a format?!");
        }
        switch (dataset.getFormatType()) {
            case "parquet": 
            case "orcfile": 
            case "delta": {
                return SparkFastPathStatus.ok();
            }
            case "csv": {
                CSVFormatConfig csvFormatConfig = dataset.getFormatParamsAs(CSVFormatConfig.class);
                if (csvFormatConfig.skipRowsBeforeHeader != 0 || csvFormatConfig.skipRowsAfterHeader != 0) {
                    return SparkFastPathStatus.nok("Skipping rows before or after the header is not supported");
                }
                if (csvFormatConfig.parseHeaderRow) {
                    return SparkFastPathStatus.nok("Non-empty CSV header is not supported");
                }
                return SparkFastPathStatus.ok();
            }
            case "json": {
                JSONFormatConfig jsonFormatConfig = dataset.getFormatParamsAs(JSONFormatConfig.class);
                if (jsonFormatConfig.extractFromSingleElement) {
                    return SparkFastPathStatus.nok("Extracting from single element is not supported");
                }
                if (jsonFormatConfig.nestedArraysHandling != JSONFormatExtractor.NestedArraysHandling.PRESERVE) {
                    return SparkFastPathStatus.nok("Only 'preserve' mode is supported for nested arrays");
                }
                return SparkFastPathStatus.ok();
            }
        }
        return SparkFastPathStatus.nok("Format type does not support Spark fast-path");
    }

    public static class SparkFastPathStatus {
        public boolean ok;
        public String message;

        public static SparkFastPathStatus ok() {
            SparkFastPathStatus ret = new SparkFastPathStatus();
            ret.ok = true;
            return ret;
        }

        public static SparkFastPathStatus nok(String message) {
            SparkFastPathStatus ret = new SparkFastPathStatus();
            ret.ok = false;
            ret.message = message;
            return ret;
        }
    }
}

