/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowOrientedDatasetHandler;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.server.SerializedMemTableSimple;
import com.dataiku.dip.shaker.services.TypeInferrer2;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class InternalDatasetTestHandler
implements DatasetTestHandler {
    @Autowired
    private DatasetsDAO datasetDAO;
    @Autowired
    private TransactionService transactionService;
    private final TypeInferrer2 inferer = new TypeInferrer2();
    protected RowOrientedDatasetHandler datasetHandler;
    private static Logger logger = Logger.getLogger((String)"dku.datasets.internal.test");

    protected InternalDatasetTestHandler(RowOrientedDatasetHandler datasetHandler) {
        this.datasetHandler = datasetHandler;
    }

    @Override
    public void close() throws IOException {
        if (this.datasetHandler != null) {
            try {
                this.datasetHandler.close();
            }
            finally {
                this.datasetHandler = null;
            }
        }
    }

    @Override
    public InfoMessage.InfoMessages checkManagedDatasetNameSafety(String newDatasetName) throws Exception {
        return new InfoMessage.InfoMessages();
    }

    @Override
    public DatasetTestHandler.SchemaConsistencyResult testSchemaConsistency() {
        DatasetTestHandler.SchemaConsistencyResult scr = new DatasetTestHandler.SchemaConsistencyResult();
        scr.empty = false;
        scr.result = new SchemaDetection.SchemaDetectionResult();
        scr.result.detectedSchema = this.getSchema();
        scr.result.type = SchemaDetection.SchemaHandlingType.FIXED_TYPE_AND_SCHEMA;
        scr.result.usedMode = SchemaDetection.Mode.DETECTION_PREFER_DATA;
        return scr;
    }

    public InternalTestResult test(AuthCtx liu) throws IOException, DKUSecurityException, CodedException {
        InternalTestResult ret = new InternalTestResult();
        this.readTablePreview(liu, ret);
        return ret;
    }

    protected abstract Schema getSchema();

    protected abstract void checkAuthorization(AuthCtx var1);

    protected abstract boolean canGetTablePreview(DatasetHandler.DatasetParams var1);

    protected void readTablePreview(AuthCtx liu, InternalTestResult ret) throws DKUSecurityException, CodedException, IOException {
        this.checkAuthorization(liu);
        Dataset dataset = this.datasetHandler.getDataset();
        DatasetInspector.checkDataset(liu, dataset);
        ret.suggestedName = DatasetInspector.slufigyAndUnicize(dataset.getProjectKey(), this.datasetHandler.suggestName(), this.datasetDAO, this.transactionService);
        ret.querySchema = this.getSchema();
        if (this.canGetTablePreview(dataset.getParams())) {
            logger.info((Object)"Gathering table preview");
            try {
                RowsInputSplit split = this.datasetHandler.getSampleSplit();
                MemTable mt = new MemTable();
                split.push((ProcessorOutput)new MemTableAppendingOutput(mt), mt, mt, new ExtractionLimit(10L), null, null);
                this.inferer.processFullAuto(null, mt);
                SerializedMemTableSimple smt = new SerializedMemTableSimple();
                smt.fromMemTable(mt, 0, mt.nrows());
                ret.preview = smt;
            }
            catch (Exception e) {
                logger.error((Object)"Failed to get preview", (Throwable)e);
                ret.previewErrorMsg = e.getMessage();
            }
        }
    }

    public static class InternalTestResult {
        public SerializedMemTableSimple preview;
        public String previewErrorMsg;
        public String suggestedName;
        public Schema querySchema;
    }
}

