/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.consistency;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.consistency.DatasetConsistencyChecker;
import com.dataiku.dip.datasets.consistency.HiveCSVFormatChecker;
import com.dataiku.dip.datasets.consistency.SchemaToDataConsistencyChecker;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;

public class ConsistencyCheckRunner {
    public static DatasetConsistencyChecker.DatasetConsistencyCheckResult checkWithFlow_NT(AuthCtx authCtx, FlowDataset fds, DatasetConsistencyChecker.DatasetConsistencyCheckRequest request) throws Exception {
        Dataset dataset;
        DatasetsDAO datasetsDAO = (DatasetsDAO)SpringUtils.getBean(DatasetsDAO.class);
        TransactionService ts = (TransactionService)SpringUtils.getBean(TransactionService.class);
        DatasetConsistencyChecker.DatasetConsistencyCheckResult result = new DatasetConsistencyChecker.DatasetConsistencyCheckResult();
        DatasetConsistencyChecker checker = null;
        try (Transaction t = ts.beginRead();){
            dataset = fds.getMandatory(datasetsDAO);
            DatasetHandler.DatasetMeta<?, ?> meta = DatasetHandlerFactory.getMeta(dataset);
            checker = meta.buildConsistencyChecker(dataset);
            checker.cheapCheck(request, result);
            new HiveCSVFormatChecker(null, fds).cheapCheck(result);
        }
        new SchemaToDataConsistencyChecker(authCtx, dataset).expensiveCheck(request, result);
        result.summarize();
        return result;
    }
}

